/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectRelation;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Role;

public class CalendarRuleAssignmentImpl
implements CalendarRuleAssignment.Mutable,
ProjectObjectRelation {
    private CalendarRule calendarRule;
    private String calendarRuleId;
    private OrganizationalUnit organizationalUnit;
    private String organizationalUnitId;
    private Role role;
    private String roleId;

    @Override
    public CalendarRuleAssignment.Mutable asMutable() {
        return this;
    }

    @Override
    public void setCalendarRule(CalendarRule calendarRule) {
        this.calendarRule = calendarRule;
        this.calendarRuleId = null;
    }

    @Override
    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        this.organizationalUnitId = null;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public CalendarRule getCalendarRule() {
        if (this.calendarRuleId != null && this.getOrganization().findCalendarRule(this.calendarRuleId) != null) {
            this.calendarRule = this.getOrganization().findCalendarRule(this.calendarRuleId);
            this.calendarRuleId = null;
        }
        return this.calendarRule;
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit() {
        if (this.organizationalUnitId != null && this.getOrganization().findOrganizationalUnit(this.organizationalUnitId) != null) {
            this.organizationalUnit = this.getOrganization().findOrganizationalUnit(this.organizationalUnitId);
            this.organizationalUnit.asMutable().addCalendarRuleAssignment(this);
            this.organizationalUnitId = null;
        }
        return this.organizationalUnit;
    }

    @Override
    public Role getRole() {
        if (this.roleId != null && this.getOrganization().findRoleById(this.roleId) != null) {
            this.role = this.getOrganization().findRoleById(this.roleId);
            this.roleId = null;
        }
        return this.role;
    }

    @Override
    public void addRelation() {
        this.organizationalUnit.asMutable().addCalendarRuleAssignment(this);
        this.calendarRule.asMutable().addCalendarRuleAssignment(this);
        if (this.role != null) {
            this.role.addCalendarRuleAssignment(this);
        }
    }

    @Override
    public void removeRelation() {
        this.organizationalUnit.asMutable().removeCalendarRuleAssignment();
        this.calendarRule.asMutable().removeCalendarRuleAssignment(this);
        if (this.role != null) {
            this.role.removeCalendarRuleAssignment(this);
        }
    }

    @Override
    public Collection<ProjectObject> getRelation() {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        result.add(this.organizationalUnit);
        result.add(this.calendarRule);
        result.add(this.role);
        return result;
    }

    @Override
    public void setCalendarRule(String calendarRuleId) {
        this.calendarRuleId = calendarRuleId;
    }

    @Override
    public String getCalendarRuleId() {
        return this.calendarRuleId;
    }

    @Override
    public void setOrganizationalUnit(String ouId) {
        this.organizationalUnitId = ouId;
    }

    @Override
    public void setRole(String roleId) {
        this.roleId = roleId;
    }

    @Override
    public String getOrganizationalUnitId() {
        return this.organizationalUnitId;
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    public boolean hasOuAssociated(String ouPath) {
        return this.organizationalUnit != null && this.organizationalUnit.getInternalPath().equals(ouPath) || this.organizationalUnitId != null && this.organizationalUnitId.equals(ouPath);
    }

    private Organization getOrganization() {
        if (this.calendarRule != null) {
            return this.calendarRule.getOrganization();
        }
        if (this.role != null) {
            return this.role.getOrganization();
        }
        if (this.organizationalUnit != null) {
            return this.organizationalUnit.getOrganization();
        }
        return null;
    }
}

