/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import oracle.bpm.project.UndeletableFolderContainerImpl;
import oracle.bpm.project.model.BusinessParametersContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.organization.BusinessParameterImpl;
import org.jetbrains.annotations.NotNull;

public class BusinessParametersContainerImpl
extends UndeletableFolderContainerImpl
implements BusinessParametersContainer {
    public BusinessParametersContainerImpl(Project project) {
        super(project, project, Path.BUSINESS_PARAMETER.getName());
        this.adaptProjectObject(this.getVFile(Path.BUSINESS_PARAMETER));
    }

    @Override
    public Path getPath() {
        return Path.BUSINESS_PARAMETER;
    }

    @NotNull
    public ProjectObject.Mutable asMutable() {
        return this;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.BUSINESS_PARAMETERS_CONTAINER;
    }

    @Override
    public BusinessParameter createBusinessParameter() {
        return new BusinessParameterImpl(this.getProject());
    }

    @Override
    public BusinessParameter createBusinessParameter(String id) throws ProjectException {
        BusinessParameter.Mutable variable = this.createBusinessParameter().asMutable();
        variable.setId(id);
        return variable;
    }

    @Override
    public void replaceBusinessParameter(BusinessParameter businessParameter) throws ProjectException {
        BusinessParameter oldBusinessParameter = this.findChild(BusinessParameter.class, businessParameter.getId());
        this.replaceChild(oldBusinessParameter, businessParameter);
    }
}

