/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.fojsp;

import oracle.bpm.log.Log;
import oracle.bpm.project.ContainerImpl;
import oracle.bpm.project.fojsp.WebContainerImpl;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.project.model.fojsp.WebRootContainer;
import org.jetbrains.annotations.NotNull;

public class WebRootContainerImpl
extends ContainerImpl
implements WebRootContainer.Mutable {
    public WebRootContainerImpl(Project project, String name) {
        super(project, null);
        this.setId(name);
        this.setRoot(true);
        this.path = Path.WEB_ROOT;
    }

    @Override
    public WebContainer getCustomJSPRootContainer() {
        WebContainer customJspRootContainer = null;
        try {
            for (Container container : this.getContainers()) {
                if (!container.getId().equals(Path.CUSTOM_JSP.getName())) continue;
                customJspRootContainer = (WebContainer)container;
                break;
            }
            if (customJspRootContainer == null) {
                customJspRootContainer = this.createContainer(Path.CUSTOM_JSP.getName());
                customJspRootContainer.asMutable().setRoot(true);
                customJspRootContainer.asMutable().setDefault(true);
                this.addDefaultContainer(customJspRootContainer);
                this.getWebResourcesRootContainer();
            }
        }
        catch (ProjectException e) {
            Log.logDebug((Throwable)((Object)e));
        }
        return customJspRootContainer;
    }

    @Override
    public WebContainer getWebResourcesRootContainer() {
        WebContainer webResourcesRootContainer = null;
        try {
            for (Container container : this.getContainers()) {
                if (!container.getId().equals(Path.WEB_RESOURCES.getName())) continue;
                webResourcesRootContainer = (WebContainer)container;
                break;
            }
            if (webResourcesRootContainer == null) {
                webResourcesRootContainer = this.createContainer(Path.WEB_RESOURCES.getName());
                webResourcesRootContainer.asMutable().setRoot(true);
                webResourcesRootContainer.asMutable().setDefault(true);
                this.addDefaultContainer(webResourcesRootContainer);
                this.load(WebContainer.class);
            }
        }
        catch (ProjectException e) {
            Log.logDebug((Throwable)((Object)e));
        }
        return webResourcesRootContainer;
    }

    @Override
    public WebContainer.Mutable createContainer(String id) throws ProjectException {
        return new WebContainerImpl(this.getProject(), this, id);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WEB_ROOT_CONTAINER;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public WebContentType getType() {
        return null;
    }

    @Override
    public Container findContainer(Path path) {
        return null;
    }

    @Override
    @NotNull
    public WebRootContainer.Mutable asMutable() {
        return this;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

