/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.fojsp;

import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.fojsp.WebContent;
import oracle.bpm.project.model.fojsp.WebContentType;
import org.jetbrains.annotations.NotNull;

public class WebContentImpl
extends ResourceObjectImpl
implements WebContent.Mutable {
    private String name;
    private WebContainer parent;
    private Path path;
    private String sourceDir;
    private WebContentType type;

    public WebContentImpl(Project project, WebContainer parent, String name, WebContentType type) {
        super(project);
        this.setId(name);
        this.setName(name);
        this.setType(type);
        this.parent = parent;
    }

    @Override
    public WebContentType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WEB_CONTENT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(WebContentType type) {
        this.type = type;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public WebContainer getParent() {
        return this.parent;
    }

    @Override
    public String getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = this.getParent().getPath().create(this.getId());
        }
        return this.path;
    }
}

