/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.events;

import oracle.bpm.project.events.NullProjectListener;
import oracle.bpm.project.events.ProjectEventManager;
import oracle.bpm.project.events.ProjectListenerSet;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;

public class ResourceEventManager
extends ProjectEventManager {
    private ProjectListenerSet listeners = new ProjectListenerSet();

    public ResourceEventManager(ProjectObject projectObject, ProjectEventManager.ParentResolver resolver) {
        super(projectObject, resolver);
    }

    public void addListener(ProjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProjectListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }

    @Override
    protected ProjectListener<ProjectObject> delegate() {
        ProjectListener<ProjectObject> result;
        if (!this.enabled) {
            if (this.projectObject.isActive()) {
                System.out.println("WARNING: events for " + this.projectObject + " are disabled (" + this.projectObject.getClass().getName() + ")");
            }
            result = NullProjectListener.INSTANCE;
        } else if (this.buffer != null) {
            result = this.buffer;
        } else {
            ProjectListenerSet delegate = super.delegate();
            result = this.listeners.isEmpty() ? delegate : this.listeners.concat(delegate);
        }
        return result;
    }
}

