/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.deployment;

import oracle.bpm.project.model.deployment.ProcessDeployment;

public class ProcessDeploymentUtils {
    private static final String OU_SEPARATOR = "/";
    private static final String VARIATION_SEPARATOR = "#";
    private static final String VERSION_SEPARATOR = "-";

    public static String getDeployedProcessId(ProcessDeployment processDeployment) {
        String ou = processDeployment.getOU() == null ? "" : processDeployment.getOU();
        return (ou.length() != 0 ? OU_SEPARATOR : "") + ou + OU_SEPARATOR + processDeployment.getProcessName();
    }

    public static String getVersionDeployedProcessId(ProcessDeployment processDeployment) {
        String processId = ProcessDeploymentUtils.getDeployedProcessId(processDeployment);
        if (processId != null) {
            processId = processId + "-1.0";
        }
        return processId;
    }

    public static String getProcessNameFromDeploymentId(String deploymentId) {
        int ouIndex = deploymentId.lastIndexOf(OU_SEPARATOR);
        return deploymentId.substring(ouIndex + 1);
    }

    public static String getOUFromDeploymentId(String deploymentId) {
        return deploymentId != null ? deploymentId.substring(0, deploymentId.lastIndexOf(OU_SEPARATOR)) : null;
    }
}

