/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.deployment;

import fuego.prefs.engine.EnginePreferences;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import java.io.File;
import oracle.bpm.data.AnalyzerProperties;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.deployment.Engine;
import org.jetbrains.annotations.NotNull;

public class EngineImpl
extends ResourceObjectImpl
implements Engine,
ResourceObject {
    private AnalyzerProperties analyzerProperties;
    private StandaloneEnginePreferences enginePreferences;

    public EngineImpl(Project project) {
        super(project);
        this.initEnginePreferences();
        this.initAnalyzerProperties();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ENGINE;
    }

    @Override
    public StandaloneEnginePreferences getEnginePreferences() {
        return this.enginePreferences;
    }

    @Override
    public void setEnginePreferences(StandaloneEnginePreferences enginePreferences) {
        this.enginePreferences = enginePreferences;
        this.events().objectChanged();
    }

    @Override
    public AnalyzerProperties getAnalyzerProperties() {
        return this.analyzerProperties;
    }

    @Override
    public void setAnalyzerProperties(AnalyzerProperties analyzerProperties) {
        this.analyzerProperties = analyzerProperties;
        this.events().objectChanged();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject().getDeployment();
    }

    private void initEnginePreferences() {
        File logDir = this.project.getLoader().getProjectFileSystem().getLocalFileSystem().getSystemFolder();
        File homeDir = logDir.getParentFile();
        this.enginePreferences = EnginePreferences.createStandalone((EngineType)EngineType.STUDIO, (String)this.getProject().getName(), (String)homeDir.getAbsolutePath(), (String)logDir.getAbsolutePath());
        this.enginePreferences.getRuntimeConfiguration().setValue(this.getProject().getName());
        this.enginePreferences.getCreationConfiguration().setValue(this.getProject().getName());
        this.enginePreferences.getLog().getEngineLogSeverity().setValue("Debug");
        this.enginePreferences.getRoundTrip().getRoundTripGranularity().setValue(1);
        this.enginePreferences.getNetworking().updatePortalUrlContext("workspace");
    }

    private void initAnalyzerProperties() {
        this.analyzerProperties = AnalyzerProperties.createDefault();
        this.analyzerProperties.setLogDefaultSeverities(this.enginePreferences.getLog().getEngineLogSeverity().getValue());
        this.analyzerProperties.setDisableDatawarehouse(true);
        this.analyzerProperties.setDisableUpdate(true);
        this.analyzerProperties.setEnableO3Service(false);
        this.analyzerProperties.setGenerateO3Cubes(false);
        this.analyzerProperties.setDisableDatawarehouse(true);
        this.analyzerProperties.setDisableUpdate(true);
        this.analyzerProperties.setCaducityInHours(24);
        this.analyzerProperties.setUpdateFrequencyMinutes(60);
        this.analyzerProperties.setBamConfiguration(this.getProject().getName() + "_BAM");
        this.analyzerProperties.setBamRuntimeConfiguration(this.analyzerProperties.getBamConfiguration());
        this.analyzerProperties.setConfiguration(this.getProject().getName() + "_RTS");
    }
}

