/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard.drilldown;

import java.io.IOException;
import java.util.List;
import oracle.bpm.dashboard.model.drilldown.DrillDownType;
import oracle.bpm.dashboard.model.drilldown.WidgetDrillDown;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.dashboard.drilldown.DrillDownAdapter;
import oracle.bpm.project.dashboard.generation.DashboardMethodFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.xml.XmlWriter;

public class WidgetDrillDownAdapter
extends DrillDownAdapter
implements WidgetDrillDown {
    private boolean predefined;
    private oracle.bpm.dashboard.model.WidgetModel widget;
    private String widgetName;

    public WidgetDrillDownAdapter() {
    }

    public WidgetDrillDownAdapter(oracle.bpm.dashboard.model.WidgetModel widget, boolean predefined) {
        this(widget.getName(), widget.getProject(), predefined);
        this.widget = widget;
    }

    public WidgetDrillDownAdapter(String widgetName, Project project, boolean predefined) {
        this.type = DrillDownType.WIDGET_DRILL_DOWN;
        this.widgetName = widgetName;
        this.project = project;
        this.predefined = predefined;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
    }

    public MethodTypeDescription[] createDrillDownMethods(oracle.bpm.dashboard.model.WidgetModel drilledDownWidget) {
        return new MethodTypeDescription[]{DashboardMethodFactory.createWidgetDrillDownMethod(this, drilledDownWidget)};
    }

    public String getName() {
        return this.widgetName;
    }

    public oracle.bpm.dashboard.model.WidgetModel getWidget() {
        if (this.widget == null && !this.predefined && this.widgetName != null && this.project != null) {
            List<? extends WidgetModel> list = this.project.getWidgetsList();
            for (WidgetModel widgetModel : list) {
                if (!widgetModel.getName().equals(this.widgetName)) continue;
                this.widget = (oracle.bpm.dashboard.model.WidgetModel)widgetModel;
                break;
            }
        }
        return this.widget;
    }

    public String toString() {
        return "type=" + this.type + ", name=" + this.widgetName + ", widget=" + this.widget;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WidgetDrillDownAdapter that = (WidgetDrillDownAdapter)o;
        return !(this.widgetName != null ? !this.widgetName.equals(that.widgetName) : that.widgetName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.widgetName != null ? this.widgetName.hashCode() : 0);
        return result;
    }

    public void serializeDrillDown(XmlWriter writer) throws IOException {
        writer.printAttribute("widgetName", this.widgetName != null ? this.widgetName : "");
        writer.printAttribute("predefined", String.valueOf(this.predefined));
    }
}

