/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard.drilldown;

import java.io.IOException;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.drilldown.DrillDownType;
import oracle.bpm.dashboard.model.drilldown.ViewDrillDown;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.dashboard.drilldown.DrillDownAdapter;
import oracle.bpm.project.dashboard.generation.DashboardMethodFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.xml.XmlWriter;

public class ViewDrillDownAdapter
extends DrillDownAdapter
implements ViewDrillDown {
    private boolean predefined;
    private View view;
    private String viewId;

    public ViewDrillDownAdapter(Project project, String viewId) {
        this.project = project;
        this.type = DrillDownType.VIEW_DRILL_DOWN;
        this.viewId = viewId;
    }

    public ViewDrillDownAdapter(Project project, View view, boolean predefined) {
        this(project, view.getId());
        this.view = view;
        this.predefined = predefined;
    }

    public MethodTypeDescription[] createDrillDownMethods(WidgetModel drilledDownWidget) {
        return new MethodTypeDescription[]{DashboardMethodFactory.createViewDrillDownMethod(drilledDownWidget, this)};
    }

    public String getViewId() {
        return this.viewId;
    }

    public View getView() {
        if (this.view == null) {
            this.view = this.project.getViewManager().getView(this.viewId);
        }
        return this.view;
    }

    public String toString() {
        return "drillDownType=" + this.type + ", view=" + this.viewId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ViewDrillDownAdapter that = (ViewDrillDownAdapter)o;
        return !(this.viewId != null ? !this.viewId.equals(that.viewId) : that.viewId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.viewId != null ? this.viewId.hashCode() : 0);
        return result;
    }

    public void serializeDrillDown(XmlWriter writer) throws IOException {
        writer.printAttribute("view", this.view.getId());
    }
}

