/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.dashboard.DimensionImpl;
import oracle.bpm.project.dashboard.generation.DimensionFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;

public class DimensionFactoryImpl
implements DimensionFactory {
    private Project project;

    public DimensionFactoryImpl(Project project) {
        this.project = project;
    }

    @Override
    public List<Dimension> getDimensionsFor(WidgetType type, ProjectObject element, Process process) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        result.add(this.getNoneDimension());
        if (element != null && type.equals((Object)WidgetType.ACTIVITY_WORKLOAD)) {
            result.addAll(this.getActivityWorkloadDimensions(element, process));
        } else if (element != null && type.equals((Object)WidgetType.ACTIVITY_PERFORMANCE)) {
            result.addAll(this.getActivityPerformanceDimensions(element, process));
        } else if (element != null && type.equals((Object)WidgetType.PROCESS_PERFORMANCE)) {
            result.addAll(this.getProcessPerformanceDimensions(element, process));
        } else if (element != null && type.equals((Object)WidgetType.ALL_ACTIVITIES_WORKLOAD)) {
            result.addAll(this.getAllActivitiesWorkloadDimensions(element, process));
        } else if (element != null && type.equals((Object)WidgetType.ALL_ACTIVITIES_PERFORMANCE)) {
            result.addAll(this.getAllActivitiesPerformanceDimensions(element, process));
        } else if (type != null && (type.equals((Object)WidgetType.ALL_OUS_ACTIVITY_PERFORMANCE) || type.equals((Object)WidgetType.ALL_OUS_PROCESS_PERFORMANCE) || type.equals((Object)WidgetType.ALL_OUS_WORKLOAD))) {
            result.addAll(this.getAllOusDimensions());
        } else if (type != null && (type.equals((Object)WidgetType.OU_ACTIVITY_PERFORMANCE) || type.equals((Object)WidgetType.OU_PROCESS_PERFORMANCE) || type.equals((Object)WidgetType.OU_WORKLOAD))) {
            result.addAll(this.getOuDimensions());
        }
        return result;
    }

    @Override
    public Dimension createActivityDimension() {
        return this.createActivityDimension(false);
    }

    public Dimension createActivityDimension(boolean totalized) {
        DimensionImpl activity = new DimensionImpl(this.project, DimensionKind.ACTIVITY);
        activity.setDimensionType(totalized ? DimensionType.TOTALIZED : DimensionType.DIMENSION);
        return activity;
    }

    public Dimension createProcessDimension() {
        return this.createProcessDimension(true);
    }

    public Dimension createProcessDimension(boolean totalized) {
        DimensionImpl dimension = new DimensionImpl(this.project, DimensionKind.PROCESS, true);
        dimension.setDimensionType(totalized ? DimensionType.TOTALIZED : DimensionType.DIMENSION);
        return dimension;
    }

    public Dimension createOuDimension() {
        return this.createOuDimension(true);
    }

    public Dimension createOuDimension(boolean totalized) {
        DimensionImpl dimension = new DimensionImpl(this.project, DimensionKind.OU, true);
        dimension.setDimensionType(totalized ? DimensionType.TOTALIZED : DimensionType.DIMENSION);
        return dimension;
    }

    @Override
    public Dimension createBusinessDimension(ProjectDataObject businessDataObject) {
        DimensionImpl dim = new DimensionImpl(this.project, businessDataObject.getId(), DimensionKind.BUSINESS_DIMENSION);
        dim.setType(businessDataObject.getType());
        return dim;
    }

    @Override
    public Dimension createParticipantDimension() {
        return new DimensionImpl(this.project, DimensionKind.PARTICIPANT);
    }

    @Override
    public Dimension createRoleDimension() {
        return new DimensionImpl(this.project, DimensionKind.ROLE);
    }

    private Dimension getNoneDimension() {
        DimensionImpl none = new DimensionImpl(this.project, DimensionKind.NONE);
        return none;
    }

    private List<Dimension> getOuDimensions() {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        result.add(this.createRoleDimension());
        result.add(this.createParticipantDimension());
        result.add(this.createProcessDimension());
        result.add(this.createActivityDimension());
        return result;
    }

    private List<Dimension> getAllOusDimensions() {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        result.add(this.createRoleDimension());
        result.add(this.createParticipantDimension());
        result.add(this.createOuDimension());
        result.add(this.createProcessDimension());
        result.add(this.createActivityDimension());
        return result;
    }

    private List<Dimension> getActivityPerformanceDimensions(ProjectObject element, Process process) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        result.add(this.createRoleDimension());
        result.add(this.createParticipantDimension());
        result.addAll(this.getBusinessDimensions(element, process));
        return result;
    }

    private List<Dimension> getActivityWorkloadDimensions(ProjectObject projectElement, Process process) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        result.add(this.createRoleDimension());
        result.add(this.createParticipantDimension());
        result.addAll(this.getBusinessDimensions(projectElement, process));
        return result;
    }

    private List<Dimension> getAllActivitiesPerformanceDimensions(ProjectObject element, Process process) {
        List<Dimension> result = this.getActivityPerformanceDimensions(element, process);
        result.add(this.createActivityDimension());
        return result;
    }

    private List<Dimension> getAllActivitiesWorkloadDimensions(ProjectObject element, Process process) {
        List<Dimension> result = this.getActivityWorkloadDimensions(element, process);
        result.add(this.createActivityDimension());
        return result;
    }

    private List<Dimension> getBusinessDimensions(ProjectObject projectElement, Process process) {
        return projectElement instanceof MeasurementImpl ? this.getBusinessDimensions((MeasurementImpl)projectElement) : this.getProjectBusinessDimensions(process);
    }

    private List<Dimension> getBusinessDimensions(MeasurementImpl measurement) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Sequence<ProjectDataObject> businessVars = measurement.getBusinessIndicators();
        for (ProjectDataObject businessDataObject : businessVars) {
            this.addBusinessVariable(businessDataObject, result);
        }
        return result;
    }

    private List<Dimension> getProcessPerformanceDimensions(ProjectObject element, Process process) {
        return this.getBusinessDimensions(element, process);
    }

    private List<Dimension> getProjectBusinessDimensions(Process process) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Collection<ProjectDataObject> projectDataObjects = process.getProject().getProjectDataObjects();
        for (ProjectDataObject projectDataObject : projectDataObjects) {
            if (!projectDataObject.isBusiness()) continue;
            this.addBusinessVariable(projectDataObject, result);
        }
        return result;
    }

    private void addBusinessVariable(ProjectDataObject businessDataObject, List<Dimension> businessDims) {
        boolean isValid;
        BusinessVariableData businessVariableData = businessDataObject.getBusinessVariableData();
        boolean hasRanges = businessVariableData != null && businessVariableData.getRange() != null && businessVariableData.getRange().length != 0;
        boolean bl = isValid = businessDataObject.getBusinessVariableType().equals((Object)BusinessVariableType.DIMENSION) && (businessDataObject.getType().getKind() == 5 || businessDataObject.getType().getKind() == 1 || businessDataObject.getType().isNumber() && hasRanges);
        if (isValid) {
            Dimension dim = this.createBusinessDimension(businessDataObject);
            businessDims.add(dim);
        }
    }
}

