/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.builder.Builder;
import oracle.bpm.project.builder.ExprBuilder;
import oracle.bpm.project.builder.Tokens;
import oracle.bpm.type.Argument;

public abstract class MethodBuilder
extends Builder {
    private Map declarations;
    private boolean display;
    private List expressions;
    private boolean generatedCall;
    private Map inArgs;
    private Map initializes;
    private boolean input;
    private String instance;
    private String method;
    private Map outArgs;
    private Map relayArgs;
    private String relayTarget;
    private String returnStmt;
    public static final int PRE_DECL = 0;
    public static final int PRE_INIT = 1;
    public static final int PRE_CALL = 2;
    public static final int POST_CALL = 3;
    private static final int FIRST = 0;
    private static final int LAST = 4;

    public MethodBuilder(Tokens tokens) {
        super(tokens);
    }

    public abstract MethodBuilder createMethodCall();

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setGeneratedCall(boolean generatedCall) {
        this.generatedCall = generatedCall;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public boolean isInput() {
        return this.input;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstanceThis() {
        this.setInstance(this.getThis());
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setRelayTarget(String relayTarget) {
        this.relayTarget = relayTarget;
    }

    public String getRelayTarget() {
        return this.relayTarget;
    }

    public void setReturnStmt(String returnStmt) {
        this.returnStmt = returnStmt;
    }

    public String getReturnStmt() {
        return this.returnStmt;
    }

    public void addArgument(Argument argument, String value) {
        this.addArgument(argument, null, value);
    }

    public void addArgument(Argument argument, String name, String value) {
        String argName;
        String string = argName = name != null ? name : argument.getName();
        if (argument.isIn()) {
            this.addInArgument(argName, value);
        }
        if (argument.isOut()) {
            this.addOutArgument(argName, argName);
        }
    }

    public void addArrayArgument(String var, String[] values) {
        this.addInArgument(var, this.getArrayOpen() + MethodBuilder.join(values, ',', true) + this.getArrayClose());
    }

    public void addArrayInitialize(String var, String[] values) {
        this.addInitialize(var, this.getArrayOpen() + MethodBuilder.join(values, ',', true) + this.getArrayClose());
    }

    public void addDeclaration(String variable, TypeDescription type) {
        if (variable == null) {
            throw new IllegalArgumentException("Variable cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (this.declarations == null) {
            this.declarations = new LinkedHashMap();
        }
        this.declarations.put(variable, type);
    }

    public ExprBuilder addExpr(int position) {
        if (position < 0 || position >= 4) {
            throw new ArrayIndexOutOfBoundsException("Position '" + position + "' is out of bounds [" + 0 + ", " + 4 + "]");
        }
        ExprBuilder expr = Builder.createExprBuilder(this.getLanguage());
        if (this.expressions == null) {
            this.expressions = new ArrayList();
            for (int i = 0; i < 4; ++i) {
                this.expressions.add(null);
            }
        }
        if (this.expressions.get(position) == null) {
            this.expressions.add(position, new ArrayList());
        }
        List exprList = (List)this.expressions.get(position);
        exprList.add(expr);
        return expr;
    }

    public void addInArgument(String argument, String value) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (this.inArgs == null) {
            this.inArgs = new LinkedHashMap();
        }
        this.inArgs.put(argument, value);
    }

    public void addInOutArgument(String argument, String value, String variable) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (variable == null) {
            throw new IllegalArgumentException("Variable cannot be null");
        }
        this.addInArgument(argument, value);
        this.addOutArgument(argument, variable);
    }

    public void addInitialize(String variable, String value) {
        if (variable == null) {
            throw new IllegalArgumentException("Variable cannot be null");
        }
        if (this.initializes == null) {
            this.initializes = new LinkedHashMap();
        }
        this.initializes.put(variable, value);
    }

    public void addMapInitialize(String mapVar, String key, String value) {
        String var = mapVar + this.getMapKeyOpen() + MethodBuilder.quote(key) + this.getMapKeyClose();
        this.addInitialize(var, value);
    }

    public void addOutArgument(String argument, String variable) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (variable == null) {
            throw new IllegalArgumentException("Variable cannot be null");
        }
        if (this.outArgs == null) {
            this.outArgs = new LinkedHashMap();
        }
        this.outArgs.put(argument, variable);
    }

    public void addRelayArgument(String argument, String value) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (this.relayArgs == null) {
            this.relayArgs = new LinkedHashMap();
        }
        this.relayArgs.put(argument, value);
    }

    public ExprBuilder createExpr() {
        return Builder.createExprBuilder(this.getLanguage());
    }

    public void generate(IndentedPrintWriter pw) {
        this.generateComponentCall(pw);
    }

    public void reset() {
        this.setMethod(null);
        this.setInstance(null);
        this.setRelayTarget(null);
        this.getInArgs().clear();
        this.getRelayArgs().clear();
        this.getDeclarations().clear();
        this.getInitializes().clear();
        this.setDisplay(false);
    }

    protected abstract void generateDeclaration(IndentedPrintWriter var1, String var2, TypeDescription var3);

    protected abstract void generateInArg(IndentedPrintWriter var1, String var2, String var3);

    protected abstract void generateInArgsClose(IndentedPrintWriter var1);

    protected abstract void generateInArgsOpen(IndentedPrintWriter var1);

    protected abstract void generateInitialize(IndentedPrintWriter var1, String var2, String var3);

    protected abstract void generateMethodCall(IndentedPrintWriter var1, String var2, String var3);

    protected abstract void generateOutArg(IndentedPrintWriter var1, String var2, String var3);

    protected abstract void generateOutArgsClose(IndentedPrintWriter var1);

    protected abstract void generateOutArgsOpen(IndentedPrintWriter var1);

    protected abstract void generateRelayArgsClose(IndentedPrintWriter var1);

    protected abstract void generateRelayArgsOpen(IndentedPrintWriter var1);

    protected abstract void generateRelayCall(IndentedPrintWriter var1);

    protected abstract void generateReturn(IndentedPrintWriter var1);

    protected Map getDeclarations() {
        if (this.declarations == null) {
            return Collections.EMPTY_MAP;
        }
        return this.declarations;
    }

    protected Map getInArgs() {
        if (this.inArgs == null) {
            return Collections.EMPTY_MAP;
        }
        return this.inArgs;
    }

    protected Map getInitializes() {
        if (this.initializes == null) {
            return Collections.EMPTY_MAP;
        }
        return this.initializes;
    }

    protected Map getOutArgs() {
        if (this.outArgs == null) {
            return Collections.EMPTY_MAP;
        }
        return this.outArgs;
    }

    protected Map getRelayArgs() {
        if (this.relayArgs == null) {
            return Collections.EMPTY_MAP;
        }
        return this.relayArgs;
    }

    protected void generateCall(IndentedPrintWriter pw) {
        List expressions = this.getExpressions();
        if (!expressions.isEmpty() && expressions.get(2) != null) {
            expressions = (List)expressions.get(2);
            for (int i = 0; i < expressions.size(); ++i) {
                ((ExprBuilder)expressions.get(i)).generateAssignStatements(pw);
            }
        }
        String method = this.getMethod();
        String instance = this.getInstance();
        if (this.isDisplay()) {
            method = this.getDisplay();
        }
        if (method != null || instance != null) {
            this.generateMethodCall(pw, method, instance);
            this.setGeneratedCall(true);
        }
    }

    protected void generateCallArgs(IndentedPrintWriter pw) {
        String method = this.getMethod();
        String instance = this.getInstance();
        if (method == null && instance == null) {
            return;
        }
        this.generateInArgsOpen(pw);
        Map allInArgs = this.getInArgs();
        Iterator it = allInArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String var = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.generateInArg(pw, var, text);
            if (!it.hasNext()) continue;
            pw.println(",");
        }
        this.generateInArgsClose(pw);
        Map allOutArgs = this.getOutArgs();
        this.generateOutArgsOpen(pw);
        Iterator it2 = allOutArgs.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            String var = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.generateOutArg(pw, var, text);
            if (!it2.hasNext()) continue;
            pw.println(",");
        }
        this.generateOutArgsClose(pw);
    }

    protected void generateComponentCall(IndentedPrintWriter pw) {
        assert (pw != null) : "out cannot be null";
        this.generateDeclarations(pw);
        this.generateInitializes(pw);
        this.generateCall(pw);
        this.generateCallArgs(pw);
        this.generateRelay(pw);
        this.generatePostCall(pw);
        this.generateReturn(pw);
    }

    protected void generateDeclarations(IndentedPrintWriter pw) {
        Map declarations;
        List expressions = this.getExpressions();
        if (!expressions.isEmpty() && expressions.get(0) != null) {
            expressions = (List)expressions.get(0);
            for (int i = 0; i < expressions.size(); ++i) {
                ((ExprBuilder)expressions.get(i)).generateAssignStatements(pw);
            }
        }
        if ((declarations = this.getDeclarations()).size() > 0) {
            for (Map.Entry entry : declarations.entrySet()) {
                String key = (String)entry.getKey();
                TypeDescription value = (TypeDescription)entry.getValue();
                this.generateDeclaration(pw, key, value);
            }
            pw.println();
        }
    }

    protected void generateInitializes(IndentedPrintWriter pw) {
        Map initializes;
        List expressions = this.getExpressions();
        if (!expressions.isEmpty() && expressions.get(1) != null) {
            expressions = (List)expressions.get(1);
            for (int i = 0; i < expressions.size(); ++i) {
                ((ExprBuilder)expressions.get(i)).generateAssignStatements(pw);
            }
        }
        if ((initializes = this.getInitializes()).size() > 0) {
            for (Map.Entry entry : initializes.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.generateInitialize(pw, key, value);
            }
            pw.println();
        }
    }

    protected void generateRelay(IndentedPrintWriter pw) {
        if (this.hasRelay()) {
            pw.indent();
            this.generateRelayCall(pw);
            this.generateRelayArgs(pw);
            pw.dedent();
        }
    }

    protected void generateRelayArgs(IndentedPrintWriter pw) {
        this.generateRelayArgsOpen(pw);
        Map arguments = this.getRelayArgs();
        Iterator it = arguments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String arg = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.generateInArg(pw, arg, text);
            if (!it.hasNext()) continue;
            pw.println(",");
        }
        this.generateRelayArgsClose(pw);
    }

    protected boolean hasRelay() {
        return this.getRelayTarget() != null;
    }

    private List getExpressions() {
        if (this.expressions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expressions;
    }

    private void generatePostCall(IndentedPrintWriter pw) {
        List expressions;
        if (this.generatedCall()) {
            pw.println(this.getStatementSeparator());
        }
        if (!(expressions = this.getExpressions()).isEmpty() && expressions.get(3) != null && (expressions = (List)expressions.get(3)).size() > 0) {
            pw.println();
            for (int i = 0; i < expressions.size(); ++i) {
                ((ExprBuilder)expressions.get(i)).generateAssignStatements(pw);
            }
        }
    }

    private boolean generatedCall() {
        return this.generatedCall;
    }
}

