/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.builder;

import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.builder.MethodBuilder;
import oracle.bpm.type.TypeRef;

public class FuegoMethodBuilder
extends MethodBuilder {
    public FuegoMethodBuilder() {
        super(FUEGO_TOKENS);
    }

    @Override
    public String getLanguage() {
        return "Fuego";
    }

    @Override
    public MethodBuilder createMethodCall() {
        return new FuegoMethodBuilder();
    }

    @Override
    protected void generateDeclaration(IndentedPrintWriter pw, String key, TypeDescription value) {
        TypeRenderer renderer = TypeRenderer.getInstance((String)"Fuego");
        assert (renderer != null) : "Could not load type renderer for 'Fuego'";
        pw.println(key + " as " + renderer.render((TypeRef)value));
    }

    @Override
    protected void generateInArg(IndentedPrintWriter pw, String var, String text) {
        pw.print(var);
        if (text != null) {
            pw.print(" = ");
            pw.print(text);
        }
    }

    @Override
    protected void generateInArgsClose(IndentedPrintWriter pw) {
        if (this.getInArgs().size() > 0) {
            pw.println();
            pw.dedent();
            pw.dedent();
        }
    }

    @Override
    protected void generateInArgsOpen(IndentedPrintWriter pw) {
        if (this.getInArgs().size() > 0) {
            pw.indent();
            pw.println("using");
            pw.indent();
        }
    }

    @Override
    protected void generateInitialize(IndentedPrintWriter pw, String var, String value) {
        pw.println(var + " = " + value + this.getStatementSeparator());
    }

    @Override
    protected void generateMethodCall(IndentedPrintWriter pw, String method, String instance) {
        assert (method != null) : "Method cannot be null for method calls";
        assert (instance != null) : "Instance cannot be null for method calls";
        pw.print(method);
        pw.print(" ");
        if (this.isDisplay()) {
            pw.println("String(" + instance + ")");
        } else {
            pw.println(instance);
        }
    }

    @Override
    protected void generateOutArg(IndentedPrintWriter pw, String argument, String variable) {
        pw.print(variable);
        pw.print(" = ");
        pw.print(argument);
    }

    @Override
    protected void generateOutArgsClose(IndentedPrintWriter pw) {
        if (this.getOutArgs().size() > 0) {
            pw.println();
            pw.dedent();
            pw.dedent();
        }
    }

    @Override
    protected void generateOutArgsOpen(IndentedPrintWriter pw) {
        if (this.getOutArgs().size() > 0) {
            pw.indent();
            pw.println("returning");
            pw.indent();
        }
    }

    @Override
    protected void generateRelayArgsClose(IndentedPrintWriter pw) {
        if (this.getRelayArgs().size() > 0) {
            pw.println();
            pw.dedent();
            pw.dedent();
        }
    }

    @Override
    protected void generateRelayArgsOpen(IndentedPrintWriter pw) {
        if (this.getRelayArgs().size() > 0) {
            pw.indent();
            pw.println("using");
            pw.indent();
        }
    }

    @Override
    protected void generateRelayCall(IndentedPrintWriter pw) {
        pw.println("relay to " + this.getRelayTarget());
    }

    @Override
    protected void generateReturn(IndentedPrintWriter pw) {
        String returnStmt = this.getReturnStmt();
        if (this.hasRelay() && returnStmt != null) {
            throw new IllegalStateException("Cannot have a relay to with return");
        }
        if (returnStmt != null) {
            pw.print("return " + returnStmt);
        }
    }
}

