/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide.compiler.checker;

import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class MilestoneActivityChecker
extends ProjectObjectChecker {
    private ActivityGuide activityGuide;

    public MilestoneActivityChecker(@NotNull ProjectMessageListener listener, @NotNull ActivityGuide activityGuide) {
        super(listener);
        this.activityGuide = activityGuide;
    }

    public void check() throws ProjectException {
        for (MilestoneActivity milestoneActivity : this.activityGuide.getDescendants(MilestoneActivity.class)) {
            FolderContainer modelsRoot = this.activityGuide.getProject().getModelsRoot();
            Activity activity = modelsRoot.findDescendant(UserTask.class, milestoneActivity.getActivityRef().getActivityId());
            if (activity != null && activity.getBpmnType() == BpmnType.USER_TASK) continue;
            throw new ProjectException(milestoneActivity, ProjectMsg.USER_TASK_DOES_NOT_EXIST(milestoneActivity.getActivity() != null ? milestoneActivity.getActivity().getDefaultLabel() : milestoneActivity.getActivityRef().getId(), milestoneActivity.getMilestone().getName()));
        }
    }
}

