/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.project.FeaturesByTextAnnotation;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AssociatedNodeFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;

public class TextAnnotationImpl
extends ProcessObjectImpl
implements TextAnnotation {
    private Features features;
    private IntFeature h = IntFeature.create("height", MINIMUM_SIZE.getHeight());
    private IntFeature w = IntFeature.create("width", MINIMUM_SIZE.getWidth());
    private IntFeature x = IntFeature.create("x", 0);
    private IntFeature y = IntFeature.create("y", 0);
    private static final String PROPERTY_X = "x";
    private static final String PROPERTY_Y = "y";
    private static final String PROPERTY_WIDTH = "width";
    private static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_TARGET = "target";
    public static final Dimension MINIMUM_SIZE = Dimension.valueOf((int)120, (int)50);
    static final long serialVersionUID = -7937231661389531467L;
    static final long serialCheck = -3989109718671320382L;

    public TextAnnotationImpl(@NotNull ProcessContent content) {
        super(content.getProject(), content);
        this.init();
        this.addModificationListener(this.x, this.y, this.w, this.h);
    }

    @Override
    public void setLocation(@NotNull Point location) {
        this.x.setValue(location.getX());
        this.y.setValue(location.getY());
    }

    @Override
    public boolean isAdjustable() {
        return false;
    }

    @Override
    public Lane getLane() {
        return LaneUtils.getLane(this.getProcess(), this.getLocation());
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.NOTE;
    }

    @Override
    public Class getRawClass() {
        return TextAnnotation.class;
    }

    @Override
    public int getWidth() {
        return this.w.getValue();
    }

    @Override
    public int getHeight() {
        return this.h.getValue();
    }

    @Override
    public int getX() {
        return this.x.getValue();
    }

    @Override
    public int getY() {
        return this.y.getValue();
    }

    @Override
    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void setX(int x) {
        this.x.setValue(x);
    }

    @Override
    public void setY(int y) {
        this.y.setValue(y);
    }

    @Override
    public void setHeight(int height) {
        this.h.setValue(height);
    }

    @Override
    public void setWidth(int width) {
        this.w.setValue(width);
    }

    @Override
    public NodeContainer getParentObject() {
        return this.getProcess();
    }

    @Override
    public void afterRemove(ProjectObjectContainer container) throws ProjectException {
        super.afterRemove(container);
        this.removeModificationListener(this.x, this.y, this.w, this.h);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.getFeature(clazz).getValue();
    }

    @Override
    public void setTarget(FlowNode target) {
        AssociatedNodeFeature associated = this.getFeature(AssociatedNodeFeature.class);
        if (target != null) {
            associated.setValue(target.getId());
        } else {
            associated.setValue(null);
        }
    }

    @Override
    public FlowNode getTarget() {
        AssociatedNodeFeature associated = this.getFeature(AssociatedNodeFeature.class);
        FlowNode result = associated.getValue() != null ? this.getParentObject().findNode(associated.getValue()) : null;
        return result;
    }

    @Override
    public void setLane(@NotNull Lane dummy) {
    }

    private void init() {
        this.features = FeaturesByTextAnnotation.get(this);
        this.addModificationListener(this.features);
    }
}

