/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEventSet;

public class ResourceObjectImpl
extends ProjectObjectContainerImpl
implements ResourceObject {
    private boolean dirty;
    private boolean ignoreDirty;
    private static final String DIRTY = "dirty";

    public ResourceObjectImpl(Project project) {
        super(project);
        this.addListener(new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

            @Override
            public void processPostEvents(ProjectEventSet events) {
                if (!ResourceObjectImpl.this.ignoreDirty) {
                    ResourceObjectImpl.this.dirty = true;
                }
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            try {
                this.ignoreDirty = true;
                this.events().objectChanged(DIRTY, !dirty, dirty);
            }
            finally {
                this.ignoreDirty = false;
            }
        }
    }
}

