/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.collections.maps.MsgLocaleStringMap;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.InstanceVariable;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.VarUtils;

public class ProjectVariableImpl
extends InstanceVariable
implements ProjectDataObject {
    public static final int[] VALID_KINDS = new int[]{1, 2, 4, 6, 3, 5};
    private static final String KEY_BUSINESS_TYPE = "BUSINESS_TYPE";
    private static final String KEY_BUSINESS_DATA = "BUSINESS_DATA";
    public static final String TASK_ID = "PREDEFINE_TASK";
    public static final String PRIORITY_ID = "PREDEFINE_PRIORITY";
    public static final String HAS_ATTACHMENTS = "PREDEFINE_HAS_ATTACHMENTS";
    public static final String HAS_NOTES = "PREDEFINE_HAS_NOTES";
    public static final String DESCRIPTION_ID = "PREDEFINE_DESCRIPTION";
    public static final String PROCESS_ID = "PREDEFINE_PROCESS";
    public static final String ACTIVITY_ID = "PREDEFINE_ACTIVITY";
    public static final String STATUS_ID = "PREDEFINE_STATUS";
    public static final String RECEIVED_ID = "PREDEFINE_RECEIVED TIME";
    public static final String DEADLINE_ID = "PREDEFINE_DEADLINE";
    public static final String PROCESS_DEADLINE_ID = "PREDEFINE_PROCESS DEADLINE";
    public static final String ACTIVITY_DEADLINE_ID = "PREDEFINE_ACTIVITY DEADLINE";
    public static final String PARTICIPANT_ID = "PREDEFINE_PARTICIPANT";
    public static final String COPY_ID = "PREDEFINE_COPY";
    public static final String AUTHOR_ID = "PREDEFINE_AUTHOR";
    public static final String CREATION_TIME_ID = "PREDEFINE_CREATION TIME";
    public static final String PARENT_COPY_ID = "PREDEFINE_PARENT COPY";
    public static final String INSTANCE_NUMBER_ID = "PREDEFINE_INSTANCE NUMBER";
    public static final String NAME_ID = "PREDEFINE_NAME";
    public static final String VERSION_ID = "PREDEFINE_VERSION";
    public static final String CREATOR_ID = "PREDEFINE_CREATOR";
    public static final String SIZE_ID = "PREDEFINE_SIZE";
    public static final String FILENAME_ID = "PREDEFINE_FILE NAME";
    public static final String LOCKER_ID = "PREDEFINE_LOCKER";
    public static final String AUTHOR_DISPLAYNAME_ID = "PREDEFINE_AUTHOR_DISPLAYNAME";
    private static final String MAIN_TASK_PARTICIPANT_ID = "PREDEFINE_MAIN_TASK_PARTICIPANT_ID";

    ProjectVariableImpl(NodeContainer content, String name, CatalogType type) {
        super(content, name, type);
    }

    public static boolean isSupportScale(CatalogType type) {
        return ProjectVariableImpl.isSupportSize(type) && type.getKind() == 3;
    }

    public static boolean isSupportSize(CatalogType type) {
        int kind = type.getKind();
        return kind == 5 || kind == 3;
    }

    public static TypeDescription[] getValidTypes() {
        TypeDescription[] values = new TypeDescription[]{TypeFactory.getBool(), TypeFactory.getInt(), TypeFactory.getReal(), TypeFactory.getTime(), TypeFactory.getDecimal(), TypeFactory.getString()};
        return values;
    }

    public static Collection<ProjectDataObject> createInstanceDefaults(Project project) {
        ArrayList<ProjectDataObject> defaultProjectDataObjects = new ArrayList<ProjectDataObject>();
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, PRIORITY_ID, CatalogType.Default.getInt(), 1, ProjectModelMsg.VAR_PRIORITY_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, HAS_ATTACHMENTS, CatalogType.Default.getBool(), 1, ProjectModelMsg.VAR_HAS_ATTACHMENTS_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, HAS_NOTES, CatalogType.Default.getBool(), 1, ProjectModelMsg.VAR_HAS_NOTES_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, DESCRIPTION_ID, CatalogType.Default.getString(25), 25, CoreMsg.DESCRIPTION));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, PROCESS_ID, CatalogType.Default.getString(15), 15, ProjectModelMsg.PROCESS));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, ACTIVITY_ID, CatalogType.Default.getString(15), 15, ProjectModelMsg.ACTIVITY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, STATUS_ID, CatalogType.Default.getInt(), 7, ProjectModelMsg.VAR_STATUS_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, RECEIVED_ID, CatalogType.Default.getTime(), 12, ProjectModelMsg.VAR_RECEIVED_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, DEADLINE_ID, CatalogType.Default.getTime(), 12, ProjectModelMsg.VAR_DEADLINE_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, PROCESS_DEADLINE_ID, CatalogType.Default.getTime(), 12, ProjectModelMsg.VAR_PROCESS_DEADLINE_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, ACTIVITY_DEADLINE_ID, CatalogType.Default.getTime(), 12, ProjectModelMsg.VAR_ACTIVITY_DEADLINE_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, PARTICIPANT_ID, CatalogType.Default.getString(10), 10, ProjectModelMsg.PARTICIPANT));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, COPY_ID, CatalogType.Default.getInt(), 3, ProjectModelMsg.COPY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, AUTHOR_ID, CatalogType.Default.getString(10), 10, ProjectModelMsg.VAR_AUTHOR_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, CREATION_TIME_ID, CatalogType.Default.getTime(), 12, ProjectModelMsg.VAR_CREATION_TIME_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, PARENT_COPY_ID, CatalogType.Default.getInt(), 3, ProjectModelMsg.VAR_PARENT_COPY_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, INSTANCE_NUMBER_ID, CatalogType.Default.getInt(), 7, ProjectModelMsg.VAR_INSTANCE_NUMBER_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, AUTHOR_DISPLAYNAME_ID, CatalogType.Default.getString(25), 25, ProjectModelMsg.VAR_AUTHOR_DISPLAYNAME_KEY));
        defaultProjectDataObjects.add(ProjectVariableImpl.createDefault(project, MAIN_TASK_PARTICIPANT_ID, CatalogType.Default.getString(), 10, ProjectModelMsg.VAR_MAIN_TASK_PARTICIPANT_ID));
        return defaultProjectDataObjects;
    }

    public static Collection<ProjectDataObject> createAttachmentDefaults(Project project) {
        ArrayList<ProjectDataObject> attDflts = new ArrayList<ProjectDataObject>();
        attDflts.add(ProjectVariableImpl.createDefault(project, NAME_ID, CatalogType.Default.getString(15), 15, CoreMsg.NAME));
        attDflts.add(ProjectVariableImpl.createDefault(project, VERSION_ID, CatalogType.Default.getInt(), 3, ProjectModelMsg.VAR_VERSION_KEY));
        attDflts.add(ProjectVariableImpl.createDefault(project, CREATOR_ID, CatalogType.Default.getString(10), 10, ProjectModelMsg.VAR_CREATOR_KEY));
        attDflts.add(ProjectVariableImpl.createDefault(project, SIZE_ID, CatalogType.Default.getInt(), 3, ProjectModelMsg.VAR_SIZE_KEY));
        attDflts.add(ProjectVariableImpl.createDefault(project, FILENAME_ID, CatalogType.Default.getString(15), 15, ProjectModelMsg.VAR_FILENAME_KEY));
        attDflts.add(ProjectVariableImpl.createDefault(project, LOCKER_ID, CatalogType.Default.getString(10), 10, ProjectModelMsg.VAR_LOCKER_KEY));
        return attDflts;
    }

    public static Collection<ProjectDataObject> createApplicationDefaults(Project project) {
        ArrayList<ProjectDataObject> appDflts = new ArrayList<ProjectDataObject>();
        appDflts.add(ProjectVariableImpl.createDefault(project, TASK_ID, CatalogType.Default.getString(6), 6, ProjectModelMsg.VAR_TASK_KEY));
        appDflts.add(ProjectVariableImpl.createDefault(project, DESCRIPTION_ID, CatalogType.Default.getString(15), 15, CoreMsg.DESCRIPTION));
        appDflts.add(ProjectVariableImpl.createDefault(project, PROCESS_ID, CatalogType.Default.getString(15), 15, ProjectModelMsg.PROCESS));
        return appDflts;
    }

    public static boolean isExternal(Project project, String id) {
        String fixedVariable = VarUtils.getExternalVariableFromDatabaseColumnName((String)id);
        return ProjectVariableImpl.getDefaultVarDefinition(project).get(fixedVariable) == null;
    }

    public static boolean isValidBusinessVariableType(CatalogType typDescription, BusinessVariableType type) {
        return type == BusinessVariableType.DIMENSION || (type == BusinessVariableType.MEASURE || type == BusinessVariableType.COUNTER) && ProjectVariableImpl.isSupportBussinesData(typDescription);
    }

    public static boolean isSupportBussinesData(CatalogType type) {
        int kind = type.getKind();
        return kind == 2 || kind == 3 || kind == 4;
    }

    public static BusinessVariableType getDefaultType(CatalogType type) {
        return ProjectVariableImpl.isSupportBussinesData(type) ? BusinessVariableType.MEASURE : BusinessVariableType.DIMENSION;
    }

    public static int getDefaultLength(CatalogType type) {
        int kind = type.getKind();
        return kind == 5 ? 30 : (kind == 3 ? 18 : -1);
    }

    public static int getDefaultScale(CatalogType type) {
        int kind = type.getKind();
        return kind == 3 ? 3 : -1;
    }

    @Override
    public void setBusinessVariableData(BusinessVariableData data) {
        this.setProperty(KEY_BUSINESS_DATA, data != null ? data.getProperties() : null);
    }

    @Override
    public void setBusinessVariableType(BusinessVariableType type) {
        this.setProperty(KEY_BUSINESS_TYPE, type == null ? null : type.toString());
        this.setReadOnly(type == BusinessVariableType.COUNTER);
    }

    @Override
    public BusinessVariableData getBusinessVariableData() {
        String properties = this.getProperty(KEY_BUSINESS_DATA);
        return properties != null ? BusinessVariableData.create((String)properties) : new BusinessVariableData();
    }

    @Override
    public BusinessVariableType getBusinessVariableType() {
        String properties = this.getProperty(KEY_BUSINESS_TYPE);
        return properties != null ? BusinessVariableType.valueOf((String)properties) : ProjectVariableImpl.getDefaultType(this.getType());
    }

    @Override
    public boolean isBusiness() {
        return this.getProperty(KEY_BUSINESS_TYPE) != null;
    }

    @Override
    public void delete() throws ProjectException {
        this.getProject().removeDataObject(this);
    }

    @Override
    public Class getRawClass() {
        return ProjectDataObject.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private static SortedMap<String, ProjectDataObject> getDefaultVarDefinition(Project project) {
        SortedStringMap result = SortedStringMap.createCaseInsensitive();
        ProjectVariableImpl.addAll((SortedStringMap<ProjectDataObject>)result, project.getDefaultVariables());
        ProjectVariableImpl.addAll((SortedStringMap<ProjectDataObject>)result, ProjectVariableImpl.createApplicationDefaults(project));
        ProjectVariableImpl.addAll((SortedStringMap<ProjectDataObject>)result, ProjectVariableImpl.createAttachmentDefaults(project));
        return result;
    }

    private static ProjectDataObject createDefault(Project project, String id, CatalogType type, int size, Msg msg) {
        ProjectDataObject projectDataObject = project.createVariable(id, type);
        projectDataObject.setLabelMap((LocaleStringMap)new MsgLocaleStringMap(msg));
        projectDataObject.setSize(size);
        return projectDataObject;
    }

    private static void addAll(SortedStringMap<ProjectDataObject> defaultVarDefinitions, Collection<ProjectDataObject> varDefinitions) {
        for (ProjectDataObject var : varDefinitions) {
            defaultVarDefinitions.put((Object)var.getId(), (Object)var);
        }
    }
}

