/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.events.EventSource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectObjectContainerImpl
extends ProjectObjectImpl
implements ProjectObjectContainer {
    private ProjectObjectList<ProjectObject> children;
    public static final String SWAP_CHILDREN = "swap_children";

    public ProjectObjectContainerImpl(Project project) {
        super(project);
    }

    @Override
    public Comparator<ProjectObject> getChildComparator() {
        return null;
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        ProjectObjectList<ProjectObject> children = this.children();
        if (children.contains(child)) {
            throw new IllegalArgumentException("Duplicated component: " + child.getId());
        }
        this.events().preObjectAdded(child, (ProjectObject)this);
        Comparator<ProjectObject> comparator = this.getChildComparator();
        if (comparator != null) {
            int index = Collections.binarySearch(children, child, comparator);
            if (index >= 0) {
                throw new IllegalStateException(child.toString());
            }
            int insertionPoint = -index - 1;
            children.add(insertionPoint, child);
        } else {
            children.add(child);
        }
        this.events().postObjectAdded(child, (ProjectObject)this);
    }

    @Override
    public void addChild(ProjectObject child, int position) throws ProjectException {
        ProjectObjectList<ProjectObject> children = this.children();
        if (children.contains(child)) {
            throw new IllegalArgumentException("Duplicated component: " + child.getId());
        }
        this.events().preObjectAdded(child, (ProjectObject)this);
        children.add(position, child);
        this.events().postObjectAdded(child, (ProjectObject)this);
    }

    @Override
    public void removeChild(ProjectObject child) throws ProjectException {
        ProjectObjectList<ProjectObject> children = this.children();
        try {
            assert (children.contains(child)) : "Removing not contained children in parent. [parent=" + this.getId() + " child=" + child.getId() + "]";
            ProjectObjectImpl childImpl = null;
            if (child instanceof ProjectObjectImpl) {
                childImpl = (ProjectObjectImpl)child;
            }
            if (childImpl != null) {
                childImpl.beforeDelete();
            }
            this.events().preObjectRemoved(child, (ProjectObject)this);
            if (childImpl != null) {
                this.cleanNestedErrors(childImpl);
            }
            children.remove(child);
            this.events().postObjectRemoved(child, (ProjectObject)this);
        }
        catch (CouldNotDeleteResourceException e) {
            if (!children.contains(child)) {
                children.add(child);
            }
            throw e;
        }
    }

    @Override
    public int indexOf(ProjectObject projectObject) {
        return this.children().indexOf(projectObject);
    }

    @Override
    public void moveChild(ProjectObject child, int newPosition) throws ProjectException {
        ProjectObjectList<ProjectObject> children = this.children();
        try {
            int oldPosition = children.indexOf(child);
            if (oldPosition == -1) {
                throw new ProjectException(child);
            }
            if (newPosition < 0 || newPosition >= children.size()) {
                throw new ProjectException(child);
            }
            ProjectObject object = (ProjectObject)children.get(newPosition);
            children.set(newPosition, child);
            children.set(oldPosition, object);
            Math.min(oldPosition, newPosition);
            this.events().objectChanged(this, SWAP_CHILDREN, Math.min(oldPosition, newPosition), Math.max(oldPosition, newPosition));
        }
        catch (CouldNotDeleteResourceException e) {
            if (!children.contains(child)) {
                children.add(child);
            }
            throw e;
        }
    }

    @Override
    public void replaceChild(ProjectObject object, ProjectObject replacement) throws ProjectException {
        if (object == null) {
            throw new ProjectException(object);
        }
        this.cleanNestedErrors((ProjectObjectImpl)object);
        for (int i = 0; i < this.children().size(); ++i) {
            if (this.children().get(i) != object) continue;
            this.children().set(i, replacement);
            break;
        }
        this.events().objectReplaced(object, replacement);
        if (replacement instanceof EventSource) {
            EventSource eventSource = (EventSource)((Object)replacement);
            eventSource.events().enable();
        }
    }

    @Override
    public void clear() {
        if (this.children != null) {
            this.children = null;
        }
    }

    @Override
    public boolean contains(ProjectObject projectObject) {
        return this.children != null && this.children.contains(projectObject);
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        return this.children().asSequence();
    }

    @NotNull
    public <T extends ProjectObject> Sequence<T> getChildrenByType(Class<T> type) {
        return this.children().byType(type);
    }

    @Override
    public <T extends ProjectObject> T findChild(Class<T> type, String id) {
        return this.children().byTypeAndId(type, id);
    }

    @NotNull
    public <T extends ProjectObject> Sequence<T> getDescendants(Class<T> type) {
        ArrayList<T> descendants = new ArrayList<T>();
        for (ProjectObject projectObject : this.getChildren()) {
            if (type.isAssignableFrom(projectObject.getRawClass())) {
                descendants.add(type.cast(projectObject));
            }
            if (!(projectObject instanceof ProjectObjectContainer)) continue;
            ((ProjectObjectContainer)projectObject).getDescendants(type).addAllTo(descendants);
        }
        return CollectionUtils.asSequence(descendants);
    }

    @Override
    public <E extends ProjectObject> E findDescendant(Class<E> type, String id) {
        Sequence<E> seq = this.getDescendants((Class<T>)type);
        for (ProjectObject e : seq) {
            if (!e.getId().equals(id)) continue;
            return (E)e;
        }
        return null;
    }

    protected void addChildSilently(ProjectObject child) {
        this.children().add(child);
    }

    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        return new ProjectObjectList<ProjectObject>();
    }

    protected final ProjectObjectList<ProjectObject> children() {
        if (this.children == null) {
            try {
                this.children = this.loadChildren();
                for (ProjectObject child : this.children) {
                    if (!(child instanceof EventSource)) continue;
                    EventSource eventSource = (EventSource)((Object)child);
                    eventSource.events().enable();
                }
            }
            catch (ProjectException e) {
                this.children = new ProjectObjectList();
                e.printStackTrace();
            }
        }
        return this.children;
    }

    private void cleanNestedErrors(ProjectObjectImpl object) {
        ProjectObjectImpl nestedObject;
        List<ProjectException> nestedErrors = object.getNestedErrors();
        List<ProjectException> nestedWarnings = object.getNestedWarnings();
        for (ProjectException nestedError : nestedErrors) {
            nestedObject = (ProjectObjectImpl)nestedError.getProjectObject();
            nestedObject.setErrors(Collections.<ProjectException>emptyList());
        }
        for (ProjectException nestedWarning : nestedWarnings) {
            nestedObject = (ProjectObjectImpl)nestedWarning.getProjectObject();
            nestedObject.setWarnings(Collections.<ProjectException>emptyList());
        }
        object.setErrors(Collections.<ProjectException>emptyList());
        object.setWarnings(Collections.<ProjectException>emptyList());
    }
}

