/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.bpm.geom.Point;
import oracle.bpm.project.GenericContent;

public abstract class ProjectElement
extends GenericContent
implements Serializable {
    protected SortedMap descriptionsMap_d = new TreeMap();
    protected SortedMap documentationMap_d = new TreeMap();
    protected SortedMap labelsMap_d = new TreeMap();
    protected String language_d;
    protected transient Point objectCoords = new Point(0, 0);
    protected SortedMap useCaseDocumentationMap_d = new TreeMap();
    private String name_d;
    static final long serialVersionUID = -7311816390947186048L;
    static final long serialCheck = -4108162976993714085L;

    protected ProjectElement() {
    }

    protected ProjectElement(String name) {
        this.setId(name);
    }

    public abstract List getContentList();

    public Locale getDefaultLanguage() {
        return Locale.getDefault();
    }

    public void setDescription(String desc, Locale loc) {
        this.descriptionsMap_d.put(loc.getLanguage(), desc);
    }

    public void setDescription(String desc, String language) {
        this.setDescription(desc, new Locale(language, ""));
    }

    public void setDescription(String desc) {
        this.setDescription(desc, this.getDefaultLanguage());
    }

    public String getDescription() {
        String s = this.getDescription(this.getDefaultLanguage());
        if (s == null || s.equals("")) {
            return this.getDescription(new Locale("en", ""));
        }
        return s;
    }

    public String getDescription(Locale loc) {
        String label = (String)this.descriptionsMap_d.get(loc.getLanguage());
        if (label != null) {
            return label;
        }
        if (!loc.getLanguage().equals(new Locale("en", "").getLanguage()) && !loc.getLanguage().equals(Locale.getDefault().getLanguage())) {
            return this.getDescription(new Locale("en", ""));
        }
        return "";
    }

    public void setDescriptionMessageMap(SortedMap tm) {
        this.descriptionsMap_d = tm;
    }

    public SortedMap getDescriptionMessageMap() {
        return this.descriptionsMap_d;
    }

    public void setDocumentation(String doc) {
        this.setDocumentation(doc, this.getDefaultLanguage());
    }

    public void setDocumentation(String desc, Locale loc) {
        this.documentationMap_d.put(loc.getLanguage(), desc);
    }

    public void setDocumentation(String desc, String language) {
        if (language == null) {
            this.setDocumentation(desc);
        } else {
            this.setDocumentation(desc, new Locale(language, ""));
        }
    }

    public String getDocumentation() {
        String doc = this.getDocumentation(this.getDefaultLanguage());
        if ((doc == null || doc.equals("")) && ((doc = this.getDocumentation(new Locale("en", ""))) == null || doc.equals(""))) {
            doc = this.getDefaultDocumentation();
        }
        return doc;
    }

    public String getDocumentation(Locale loc) {
        String label = (String)this.documentationMap_d.get(loc.getLanguage());
        if (label != null) {
            return label;
        }
        return this.getDefaultDocumentation();
    }

    public void setDocumentationMessageMap(SortedMap documentationMap) {
        this.documentationMap_d = documentationMap;
    }

    public SortedMap getDocumentationMessageMap() {
        return this.documentationMap_d;
    }

    public void setId(String name) {
        this.name_d = name;
    }

    public String getId() {
        return this.name_d;
    }

    public boolean isInContent() {
        return this.getContentList().contains(this);
    }

    public void setLabel(String label) {
        this.setLabel(label, this.getDefaultLanguage());
    }

    public void setLabel(String label, String language) {
        if (language == null) {
            this.setLabel(label);
        } else {
            this.setLabel(label, new Locale(language, ""));
        }
    }

    public String getLabel() {
        return this.getLabel(this.getDefaultLanguage());
    }

    public String getLabel(Locale loc) {
        String label = (String)this.labelsMap_d.get(loc.getLanguage());
        if (label == null) {
            if (!loc.getLanguage().equals(this.getDefaultLanguage().getLanguage())) {
                label = (String)this.labelsMap_d.get(this.getDefaultLanguage().getLanguage());
            }
            if (label == null) {
                label = this.getId();
            }
        }
        return label;
    }

    public void setLabelMessageMap(SortedMap tm) {
        this.labelsMap_d = tm;
    }

    public SortedMap getLabelMessageMap() {
        return this.labelsMap_d;
    }

    public void setLanguage(String lang) {
        this.language_d = lang;
    }

    public String getLanguage() {
        return this.language_d;
    }

    public void setLocation(Point p) {
        this.objectCoords = p;
    }

    public void setLocation(String point) {
        StringTokenizer st = new StringTokenizer(point, ",");
        this.setLocation(new Point(Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim())));
    }

    public Point getLocation() {
        return this.objectCoords;
    }

    public void setName(String name) {
        this.setId(name);
    }

    public String getName() {
        return this.getId();
    }

    public void setUseCaseDocumentation(String doc) {
        this.setUseCaseDocumentation(doc, this.getDefaultLanguage());
    }

    public void setUseCaseDocumentation(String desc, Locale loc) {
        this.useCaseDocumentationMap_d.put(loc.getLanguage(), desc);
    }

    public void setUseCaseDocumentation(String desc, String language) {
        if (language == null) {
            this.setUseCaseDocumentation(desc);
        } else {
            this.setUseCaseDocumentation(desc, new Locale(language, ""));
        }
    }

    public String getUseCaseDocumentation() {
        String doc = this.getUseCaseDocumentation(this.getDefaultLanguage());
        if (doc == null || doc.equals("")) {
            doc = this.getUseCaseDocumentation(new Locale("en", ""));
            if (doc == null || doc.equals("")) {
                doc = this.getDefaultDocumentation();
            }
            return doc;
        }
        return doc;
    }

    public String getUseCaseDocumentation(Locale loc) {
        String label = (String)this.useCaseDocumentationMap_d.get(loc.getLanguage());
        if (label != null && !label.equals("")) {
            return label;
        }
        return this.getDefaultDocumentation();
    }

    public SortedMap getUseCaseDocumentationMessageMap() {
        return this.useCaseDocumentationMap_d;
    }

    public void add() {
        this.getContentList().add(this);
    }

    public void remove() {
        this.getContentList().remove(this);
    }

    protected String getDefaultDocumentation() {
        return "";
    }

    protected void setLabel(String label, Locale loc) {
        this.labelsMap_d.put(loc.getLanguage(), label);
    }
}

