/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.FeaturesByProcess;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.NodeContainerManager;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.AuthorFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.features.IsCallableSubprocessFeature;
import oracle.bpm.project.model.features.IsInterfaceFeature;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.features.XmlnsFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessGenerateEvents;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import oracle.bpm.util.PublishUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessContent
extends ResourceObjectImpl
implements Cloneable,
ModelObject,
Localizable.Mutable,
Process {
    protected ProcessGenerateEvents generatesEvents = ProcessGenerateEvents.GENERATE_INTERACTIVE_EVENTS;
    protected boolean storing;
    private ComponentCatalog catalog;
    private ResourceContainer container;
    private ModificationAwareLocaleStringMap documentation;
    private ModificationAwareLocaleStringMap useCaseDocumentation;
    private Features features;
    private DataDeclarationContainer inputArgumentsContainer;
    private LocaleStringMap label;
    private LocaleStringMap description;
    @NotNull
    private final NavigableMap<Integer, Lane> lanes = new TreeMap<Integer, Lane>();
    private NodeContainerManager nodeContainerManager;
    @Nullable
    private ObjectTypeDescription otd;
    private DataDeclarationContainer outputArgumentsContainer;
    @Nullable
    private Map<String, String> renamedCils;
    protected static final int BEGIN_END_ROLE_WIDTH = 450;
    public static final long INSTANCE_SERIAL_VERSION = 0xFEFEFEFEL;

    public ProcessContent(ResourceContainer container, ComponentCatalog componentCatalog) {
        this(container, componentCatalog, false);
    }

    public ProcessContent(ResourceContainer container, ComponentCatalog componentCatalog, boolean isCallable) {
        super(container != null ? container.getProject() : null);
        this.container = container;
        this.catalog = componentCatalog;
        this.nodeContainerManager = new NodeContainerManager(this);
        this.init();
        this.label = this.createLocaleStringMap();
        this.setIsCallableSubprocess(isCallable);
    }

    public static Variable createCILVariable() {
        return new Variable("", (TypeRef)TypeFactory.getAny());
    }

    public static boolean isDefaultProcess(NodeContainer nodeContainer) {
        return nodeContainer instanceof Process && ProcessContent.isDefaultProcess((Process)nodeContainer);
    }

    public static boolean isDefaultProcess(Process process) {
        return "default".equals(process.getId()) && process.getParentObject() instanceof Project;
    }

    @Override
    public Class getRawClass() {
        return Process.class;
    }

    @Override
    public DataObject createDataObject(String dataObjectId, CatalogType type) {
        return this.getNodeContainerManager().createDataObject(dataObjectId, type);
    }

    @Override
    public DataObject findDataObject(String dataObjectId) {
        return this.getNodeContainerManager().findDataObject(dataObjectId);
    }

    @Override
    public Sequence<DataObject> getDataObjects() {
        return this.getNodeContainerManager().getDataObjects();
    }

    @Override
    public void addDataObject(DataObject dataObject) throws ProjectException {
        this.addChild(dataObject);
    }

    @Override
    public void removeDataObject(DataObject dataObject) throws ProjectException {
        this.removeChild(dataObject);
    }

    @Override
    public void removeChild(ProjectObject child) throws ProjectException {
        if (child instanceof Lane) {
            this.removeLane((Lane)child);
        } else {
            super.removeChild(child);
        }
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        return CollectionUtils.concat(super.getChildren(), this.getLanes());
    }

    public boolean isProcessInfoLoaded(String tagName) {
        if (Str.isEmpty((String)this.getId())) {
            return false;
        }
        return tagName.equals("component") || "roles".equals(tagName);
    }

    public void setName(String name) {
        this.setId(name);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL;
    }

    @Override
    public FlowNode findNodeByLabel(String nodeId) {
        return this.getNodeContainerManager().findNodeByLabel(nodeId);
    }

    @Override
    public FlowNode findNode(String activityName) {
        return this.getNodeContainerManager().findNode(activityName);
    }

    @Override
    public Gateway findGateway(String gatewayId) {
        return this.getNodeContainerManager().findGateway(gatewayId);
    }

    @Override
    public Event findEvent(String eventId) {
        return this.getNodeContainerManager().findEvent(eventId);
    }

    @Override
    public BoundaryEvent findBoundaryEvent(String eventId) {
        return this.getNodeContainerManager().findBoundaryEvent(eventId);
    }

    @Override
    public Activity findActivity(String activityId) {
        return this.getNodeContainerManager().findActivity(activityId);
    }

    @Override
    public SequenceFlow findSequenceFlow(String sequenceFlowId) {
        return this.getNodeContainerManager().findSequenceFlow(sequenceFlowId);
    }

    @Override
    public Measurement findMeasurement(String measurementId) {
        return this.getNodeContainerManager().findMeasurement(measurementId);
    }

    @Override
    public Sequence<Measurement> getMeasurements() {
        return this.getNodeContainerManager().getMeasurements();
    }

    @Override
    public Activity createActivity() {
        return this.getNodeContainerManager().createActivity();
    }

    @Override
    public Subprocess createSubprocess() {
        return this.getNodeContainerManager().createSubprocess();
    }

    @Override
    public Subprocess createSubprocess(boolean isTriggeredByEvent) {
        return this.getNodeContainerManager().createSubprocess(isTriggeredByEvent);
    }

    @Override
    public ParallelGateway createParallelGateway() {
        return this.getNodeContainerManager().createParallelGateway();
    }

    @Override
    public InclusiveGateway createInclusiveGateway() {
        return this.getNodeContainerManager().createInclusiveGateway();
    }

    @Override
    public EventBasedGateway createEventBasedGateway() {
        return this.getNodeContainerManager().createEventBasedGateway();
    }

    @Override
    public ComplexGateway createComplexGateway() {
        return this.getNodeContainerManager().createComplexGateway();
    }

    @Override
    public ProcessSealType getSealType() {
        return (ProcessSealType)((Object)this.getFeature(ProcessSealTypeFeature.class).getValue());
    }

    @Override
    public void setSealType(ProcessSealType sealType) {
        this.getFeature(ProcessSealTypeFeature.class).setValue(sealType);
    }

    @Override
    public Sequence<BoundaryEvent> getBoundaryEvents() {
        return this.getNodeContainerManager().getBoundaryEvents();
    }

    @Override
    public ExclusiveGateway createExclusiveGateway() {
        return this.getNodeContainerManager().createExclusiveGateway();
    }

    @Override
    public ThrowEvent createIntermediateThrowEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateThrowEvent(triggerType);
    }

    @Override
    public CatchEvent createIntermediateCatchEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateCatchEvent(triggerType);
    }

    @Override
    public BoundaryEvent createBoundaryEvent(EventTriggerType triggerType, Activity boundaryTarget) {
        return this.getNodeContainerManager().createBoundaryEvent(triggerType, boundaryTarget);
    }

    @Override
    public StartEvent createStartEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createStartEvent(triggerType);
    }

    @Override
    public EndEvent createEndEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createEndEvent(triggerType);
    }

    @Override
    public SequenceFlow createSequenceFlow() {
        return this.getNodeContainerManager().createSequenceFlow();
    }

    @Override
    public SequenceFlow createSequenceFlow(FlowNode source, FlowNode target) {
        return this.getNodeContainerManager().createSequenceFlow(source, target);
    }

    @Deprecated
    public SequenceFlow createSequenceFlow(String sequenceFlowId, FlowNode source, FlowNode target) {
        SequenceFlow sequenceFlow = this.getNodeContainerManager().createSequenceFlow(source, target);
        sequenceFlow.setId(sequenceFlowId);
        return sequenceFlow;
    }

    @Override
    public Sequence<SequenceFlow> getSequenceFlows() {
        return this.getNodeContainerManager().getSequenceFlows();
    }

    @Override
    public Sequence<FlowNode> getFlowNodes() {
        return this.getNodeContainerManager().getFlowNodes();
    }

    @Override
    public <T extends FlowNode> Sequence<T> getFlowNodes(Class<T> clazz) {
        return this.getNodeContainerManager().getFlowNodes(clazz);
    }

    @Override
    public <T extends Activity> Sequence<T> getActivities(Class<T> clazz) {
        return this.getNodeContainerManager().getActivities(clazz);
    }

    @Override
    public Sequence<Activity> getActivities() {
        return this.getNodeContainerManager().getActivities();
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz) {
        return this.getNodeContainerManager().getEvents(clazz);
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz, EventTriggerType trigger) {
        return this.getNodeContainerManager().getEvents(clazz, trigger);
    }

    @Override
    public Sequence<Event> getEvents() {
        return this.getNodeContainerManager().getEvents();
    }

    @Override
    public <T extends Gateway> Sequence<T> getGateways(Class<T> clazz) {
        return this.getNodeContainerManager().getGateways(clazz);
    }

    @Override
    public Sequence<Gateway> getGateways() {
        return this.getNodeContainerManager().getGateways();
    }

    @Override
    public Measurement createMeasurement(String measurementId) {
        return this.getNodeContainerManager().createMeasurement(measurementId);
    }

    @Override
    public TextAnnotation createTextAnnotation(String idAnnotation) {
        return this.getNodeContainerManager().createTextAnnotation(idAnnotation);
    }

    @Override
    public Lane createLane(@Nullable String laneId) {
        LaneImpl lane = new LaneImpl(this);
        if (laneId != null) {
            lane.setId(laneId);
        }
        return lane;
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        if (child instanceof Lane) {
            this.addLane((Lane)child);
        } else {
            this.getNodeContainerManager().validateAddChild(child);
            super.addChild(child);
        }
    }

    @Override
    public void addMeasurement(Measurement measurement) throws ProjectException {
        this.addChild(measurement);
    }

    @Override
    public void removeMeasurement(Measurement measurement) throws ProjectException {
        this.removeChild(measurement);
    }

    public void addLane(Lane lane) throws ProjectException {
        this.events().preObjectAdded(lane, (ProjectObject)this);
        this.getLanesInternal().put(lane.getOffset(), lane);
        this.events().postObjectAdded(lane, (ProjectObject)this);
    }

    public void removeLane(@NotNull Lane lane) throws ProjectException {
        this.events().preObjectRemoved(lane, (ProjectObject)this);
        this.getLanesInternal().remove(lane.getOffset());
        this.events().postObjectRemoved(lane, (ProjectObject)this);
    }

    public void addNote(@NotNull TextAnnotation note) throws ProjectException {
        this.addChild(note);
    }

    public void removeNote(@NotNull TextAnnotation note) throws ProjectException {
        this.removeChild(note);
    }

    @Override
    public LocaleStringMap getDocumentationMap() {
        if (this.documentation == null) {
            this.documentation = this.createLocaleStringMap();
        }
        return this.documentation;
    }

    @Override
    public ProcessGenerateEvents getGeneratesEvents() {
        return (ProcessGenerateEvents)((Object)this.getFeature(ProcessGenerateEventsFeature.class).getValue());
    }

    @Override
    public void clear() {
        super.clear();
        this.getLanesInternal().clear();
    }

    public void createBeginAndEnd(boolean createBeginEnd, boolean createBeginEndTransition, boolean isSync) throws ProjectException {
        if (ModelUtils.getStartEvent(this) == null) {
            Lane lane = ModelUtils.findOrCreateAutomaticLane(this);
            lane.asMutable().setSize(450);
            this.addChild(lane);
            if (createBeginEnd) {
                EventTriggerType trigger = EventTriggerType.MESSAGE;
                if (this.isCallableSubprocess()) {
                    trigger = EventTriggerType.NONE;
                }
                StartEvent begin = this.createStartEvent(trigger);
                begin.setLocation(LaneUtils.getLocationFor(lane, 0.5, 100));
                this.addChild(begin);
                EndEvent end = this.createEndEvent(trigger);
                end.setLocation(LaneUtils.getLocationFor(lane, 0.5, 200));
                this.addChild(end);
                if (createBeginEndTransition) {
                    SequenceFlow seqFlow = this.getNodeContainerManager().createSequenceFlow(begin, end);
                    this.addChild(seqFlow);
                }
                if (!this.isCallableSubprocess()) {
                    begin.setSync(isSync);
                    end.setConversationInitiator(begin);
                    String beginOperationName = ConversationHelper.getDefaultOperationName((ConversationEnabled)begin);
                    begin.setDefinedOperationName(beginOperationName);
                    String endOperationName = isSync ? beginOperationName : ConversationHelper.getDefaultOperationName((ConversationEnabled)end);
                    end.setDefinedOperationName(endOperationName);
                }
            }
        }
    }

    public void createBeginAndEnd(boolean createBeginEnd, boolean createBeginEndTransition, EventTriggerType trigger) throws ProjectException {
        if (ModelUtils.getStartEvent(this) == null) {
            Lane lane = ModelUtils.findOrCreateAutomaticLane(this);
            lane.asMutable().setSize(450);
            this.addChild(lane);
            if (createBeginEnd) {
                if (this.isCallableSubprocess()) {
                    trigger = EventTriggerType.NONE;
                }
                StartEvent begin = this.createStartEvent(trigger);
                begin.setLocation(LaneUtils.getLocationFor(lane, 0.5, 100));
                this.addChild(begin);
                EndEvent end = this.createEndEvent(trigger);
                end.setLocation(LaneUtils.getLocationFor(lane, 0.5, 200));
                this.addChild(end);
                if (createBeginEndTransition) {
                    SequenceFlow seqFlow = this.getNodeContainerManager().createSequenceFlow(begin, end);
                    this.addChild(seqFlow);
                }
            }
        }
    }

    @NotNull
    public ObjectTypeDescription createInstanceType() {
        ObjectTypeDescription type = new ObjectTypeDescription("Instance");
        type.addModifier(4096L);
        type.setProperty("javaSerialId", String.valueOf(0xFEFEFEFEL));
        type.setProperty("initAllFields", "true");
        ProjectException.addDetail((TypeDescription)type, this);
        if (this.getProject() != null) {
            int i = 1;
            String javaPackage = PublishUtils.buildCILClassName((String)this.getName(), (String)this.getId(), (int)i, (int)0, (String)"");
            type.setProperty("package", javaPackage);
        }
        type.setCatalog(this.catalog);
        String prefix = "CIL_";
        type.setProperty("methodPrefix", prefix);
        type.setComponentType(ComponentType.XOBJECT.getText());
        type.addMember(type.createConstructor());
        return type;
    }

    @Override
    public Counter createCounter(String counterId) {
        return this.getNodeContainerManager().createCounter(counterId);
    }

    @Override
    public void addCounter(Counter counter) throws ProjectException {
        this.addChild(counter);
    }

    @Override
    public void removeCounter(Counter counter) throws ProjectException {
        this.removeChild(counter);
    }

    @Override
    public Counter findCounter(String counterId) {
        return this.getNodeContainerManager().findCounter(counterId);
    }

    @Override
    public Sequence<Counter> getCounters() {
        return this.getNodeContainerManager().getCounters();
    }

    public TextAnnotation createNote() {
        return new TextAnnotationImpl(this);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        return this.label;
    }

    @Override
    public String getDefaultLabel() {
        return this.getString((I18nProvider)this.getLabelMap(), this.getId());
    }

    @Override
    public String getDefaultDescription() {
        return this.getString((I18nProvider)this.getDescriptionMap(), "");
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getLabelMap().getString(locale);
    }

    public void fix() {
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public String getAuthor() {
        return this.getFeature(AuthorFeature.class).getValue();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.container;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            Path parentPath = this.getParentObject().getPath();
            this.path = parentPath.create(this.getId());
        }
        return this.path;
    }

    @Override
    public LocaleStringMap getUseCaseDocumentationMap() {
        if (this.useCaseDocumentation == null) {
            this.useCaseDocumentation = this.createLocaleStringMap();
        }
        return this.useCaseDocumentation;
    }

    @Override
    public Localizable.Mutable asMutableLocalizable() {
        return this;
    }

    public ComponentCatalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = this.project.getComponentCatalog();
        }
        return this.catalog;
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        if (this.description == null) {
            this.description = this.createLocaleStringMap();
        }
        return this.description;
    }

    @Override
    public Lane findLane(@NotNull String laneId) {
        return LaneUtils.getLaneForId(this, laneId);
    }

    @Override
    public TextAnnotation findTextAnnotation(String noteId) {
        return this.getNodeContainerManager().findTextAnnotation(noteId);
    }

    @Override
    public Sequence<TextAnnotation> getTextAnnotations() {
        return this.getNodeContainerManager().getTextAnnotations();
    }

    @NotNull
    public Map<String, String> getRenamedCils() {
        Map<String, String> result = this.renamedCils;
        if (result == null) {
            this.renamedCils = result = new TreeMap<String, String>();
        }
        return result;
    }

    @NotNull
    public Sequence<Lane> getRolesForNames(@NotNull String[] laneIds) {
        SequenceBuilder builder = SequenceBuilder.create();
        for (String laneId : laneIds) {
            builder.append(LaneUtils.getLanesForId(this, laneId));
        }
        return builder.build();
    }

    public ComponentCatalog getComponentCatalog() {
        return this.catalog;
    }

    @Override
    public String getName() {
        return this.getDefaultLabel();
    }

    public String getXmlns() {
        return this.getFeature(XmlnsFeature.class).getValue();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public void setAuthor(String name) {
        this.getFeature(AuthorFeature.class).setValue(name);
    }

    @Override
    public void setGeneratesEvents(ProcessGenerateEvents e) {
        this.getFeature(ProcessGenerateEventsFeature.class).setValue(e);
    }

    public void setIsInterface(boolean isInterface) {
        IsInterfaceFeature isInterfaceFeature = this.getFeature(IsInterfaceFeature.class);
        if (isInterfaceFeature != null) {
            isInterfaceFeature.setValue(isInterface);
        }
    }

    public void setIsInterface(String isInterface) {
        this.setIsInterface(Boolean.valueOf(isInterface));
    }

    public void setObjectTypeDescription(ObjectTypeDescription object) {
        this.otd = object;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setXmlns(String xmlns) {
        XmlnsFeature feature = this.getFeature(XmlnsFeature.class);
        if (feature != null) {
            feature.setValue(xmlns);
        }
    }

    public String toString() {
        return this.getId();
    }

    @Override
    @NotNull
    public Sequence<Lane> getLanes() {
        return CollectionUtils.asSequence(this.getLanesInternal().values());
    }

    @Override
    public void setLabelMap(LocaleStringMap label) {
        this.label = label;
    }

    @Override
    public void setDefaultLabel(String defaultLabel) {
        this.getLabelMap().put(this.getDefaultLocale(), defaultLabel);
        this.events().objectChanged("defaultLabel", null, defaultLabel);
    }

    @Override
    public void setDefaultDescription(String defaultDescription) {
        this.getDescriptionMap().put(this.getDefaultLocale(), defaultDescription);
        this.events().objectChanged("defaultDescription", null, defaultDescription);
    }

    @Override
    public void setDescription(LocaleStringMap map) {
        this.description = map;
    }

    @Override
    public void setDocumentation(ModificationAwareLocaleStringMap map) {
        this.documentation = map;
    }

    @Override
    public void setUseCaseDocumentation(ModificationAwareLocaleStringMap map) {
        this.useCaseDocumentation = map;
    }

    @Override
    public String getNamespace() {
        String namespace = (String)this.getFeatureValue(NamespaceFeature.class);
        if ("".equals(namespace)) {
            return "http://xmlns.oracle.com/bpmn/bpmnProcess/" + this.getId();
        }
        return namespace;
    }

    public int getFileRevision() {
        return this.getFeature(FileRevisionFeature.class).getRevision();
    }

    public String getFileVersion() {
        return this.getFeature(FileRevisionFeature.class).getVersion();
    }

    @Override
    public boolean isCallableSubprocess() {
        return this.getFeature(IsCallableSubprocessFeature.class).getValue();
    }

    @Override
    public void init() {
        this.clear();
        if (this.features == null) {
            this.features = FeaturesByProcess.get(this);
            this.addModificationListener(this.features);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public Process getProcess() {
        return this;
    }

    public void setComponentCatalog(MutableComponentCatalog componentCatalog) {
        this.catalog = componentCatalog;
    }

    public void renamedMethod() {
        this.events().objectChanged();
    }

    public NavigableMap<Integer, Lane> getLanesInternal() {
        return this.lanes;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return this.getProject();
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence<DataDeclaration> result = (Sequence<DataDeclaration>)Cast.force(this.getDataObjects());
        Project project = this.getProject();
        if (project == null || project.getProjectModel() == null || !project.getProjectModel().equals(this)) {
            result = PredefinedVariablesHelper.appendPredefinedVariablesForContainer(result, this);
        }
        return result;
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String s) {
        return DataDeclarationImpl.findDeclarationPath(this, s);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDataObject(name, type);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.createDeclaration(name, type);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.addDataObject((DataObject)dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.removeDataObject((DataObject)dataDeclaration);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        for (DataDeclaration declaration : this.getLocalDeclarations()) {
            this.removeDeclaration(declaration);
        }
    }

    @Override
    public DataAssociationSet createInputDataAssociationSet(@NotNull InputArgumentsEnabled inputArgumentsEnabled, @NotNull DataDeclarationContainer dataObjectsContainer) {
        return this.getNodeContainerManager().createInputDataAssociationSet(inputArgumentsEnabled, dataObjectsContainer);
    }

    @Override
    public DataAssociationSet createOutputDataAssociationSet(@NotNull OutputArgumentsEnabled outputArgumentsEnabled, @NotNull DataDeclarationContainer dataObjectsContainer) {
        return this.getNodeContainerManager().createOutputDataAssociationSet(outputArgumentsEnabled, dataObjectsContainer);
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        if (this.inputArgumentsContainer == null) {
            this.inputArgumentsContainer = new ProcessArgumentContainer(this.project);
        }
        return this.inputArgumentsContainer;
    }

    @Override
    public void setInputArgumentsContainer(DataDeclarationContainer inputArgumentsContainer) {
        this.inputArgumentsContainer = inputArgumentsContainer;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        if (this.outputArgumentsContainer == null) {
            this.outputArgumentsContainer = new ProcessArgumentContainer(this.project);
        }
        return this.outputArgumentsContainer;
    }

    @Override
    public void setOutputArgumentsContainer(DataDeclarationContainer outputArgumentsContainer) {
        this.outputArgumentsContainer = outputArgumentsContainer;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private NodeContainerManager getNodeContainerManager() {
        return this.nodeContainerManager;
    }

    private void setIsCallableSubprocess(boolean isCallable) {
        this.getFeature(IsCallableSubprocessFeature.class).setValue(isCallable);
    }

    private ModificationAwareLocaleStringMap createLocaleStringMap() {
        ModificationAwareLocaleStringMap result = ModificationAwareLocaleStringMap.create(this);
        result.addModificationListener(new ModificationListener<ProjectObject>(){

            public void objectModified(ModificationEvent<ProjectObject> event) {
                ProcessContent.this.fireObjectChanged(ProcessContent.this, ProjectEvent.CHANGE(ProcessContent.this, null, event.getOldValue(), event.getNewValue()));
            }
        });
        return result;
    }

    private Locale getDefaultLocale() {
        Project project = this.getProject();
        return project != null ? project.getPreferences().getDefaultLanguage() : Locale.getDefault();
    }
}

