/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.catalog.PredefinedDeclaration;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class PredefinedVariable
extends DataDeclarationImpl
implements PredefinedDeclaration {
    private DataDeclarationType declarationType;
    private Msg description;
    private String name;
    private DataDeclarationContainer parent;
    private TypeRef typeRef;

    public PredefinedVariable(@NotNull DataDeclarationContainer parent, @NotNull String name, @NotNull CatalogType type, @NotNull DataDeclarationType declarationType, @NotNull Msg description) {
        super(parent.getProject());
        this.parent = parent;
        this.name = name;
        this.declarationType = declarationType;
        this.description = description;
        this.setType(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CatalogType getType() {
        return CatalogTypeImpl.get(this.typeRef);
    }

    @Override
    public boolean isIn() {
        return false;
    }

    @Override
    public boolean isOut() {
        return true;
    }

    @Override
    public boolean isPredefinedDeclaration() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(CatalogType type) {
        this.typeRef = type.getDynamicRef();
    }

    @Override
    public DataDeclarationType getDeclarationType() {
        return this.declarationType;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.parent;
    }

    @Override
    public DataDeclarationContainer getDeclarationContainer() {
        return this.parent;
    }

    @Override
    public Msg getDescription() {
        return this.description;
    }
}

