/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Function;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessor;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeComponent;
import oracle.bpm.project.catalog.composite.CompositeImport;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.jaxb.BPELImplementation;
import oracle.bpm.project.catalog.composite.jaxb.BPMNImplementation;
import oracle.bpm.project.catalog.composite.jaxb.CEPImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Component;
import oracle.bpm.project.catalog.composite.jaxb.ComponentType;
import oracle.bpm.project.catalog.composite.jaxb.Composite;
import oracle.bpm.project.catalog.composite.jaxb.CompositeUtils;
import oracle.bpm.project.catalog.composite.jaxb.DecisionImplementation;
import oracle.bpm.project.catalog.composite.jaxb.EventAgentImplementation;
import oracle.bpm.project.catalog.composite.jaxb.Implementation;
import oracle.bpm.project.catalog.composite.jaxb.Import;
import oracle.bpm.project.catalog.composite.jaxb.Interface;
import oracle.bpm.project.catalog.composite.jaxb.MediatorImplementation;
import oracle.bpm.project.catalog.composite.jaxb.ObjectFactory;
import oracle.bpm.project.catalog.composite.jaxb.Property;
import oracle.bpm.project.catalog.composite.jaxb.Reference;
import oracle.bpm.project.catalog.composite.jaxb.Service;
import oracle.bpm.project.catalog.composite.jaxb.WSDLInterface;
import oracle.bpm.project.catalog.composite.jaxb.WorkflowImplementation;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JaxbCompositeAccessor
extends CompositeAccessor {
    private Composite jaxbModel;
    private static final String WSDL_INTERFACE = "#wsdl.interface";
    private static final String HUMAN_TASK_INTERFACE_ID = "(TaskService)";
    private static final String BUSINESS_RULE_INTERFACE_ID = "(IDecisionService)";

    public JaxbCompositeAccessor(@NotNull Project project) {
        super(project);
    }

    @NotNull
    public CompositeInfo parseComposite() throws CompositeAccessorException {
        this.loadComposite();
        return new CompositeInfo(this.getCompositeReferences(), this.getCompositeServices(), this.loadCompositeComponents(), this.getCompositeImports());
    }

    @NotNull
    private Iterable<CompositeComponent> loadCompositeComponents() throws CompositeAccessorException {
        ArrayList<CompositeComponent> result = new ArrayList<CompositeComponent>();
        List components = this.jaxbModel.getComponent();
        if (components != null) {
            for (Component component : components) {
                result.add(this.createComponent(component));
            }
        }
        return result;
    }

    @NotNull
    private Iterable<CompositeInterface> getCompositeReferences() {
        return this.nonNullIterable(this.jaxbModel.getReference(), (Function)new Function<Reference, CompositeInterface>(){

            public CompositeInterface eval(Reference reference) {
                return JaxbCompositeAccessor.this.createInterface(new ElementContainer(JaxbCompositeAccessor.this.getVFileSystemProject(), reference), reference.getName(), null, CatalogInterfaceType.SERVICE, null);
            }
        });
    }

    @NotNull
    private Iterable<CompositeInterface> getCompositeServices() {
        return this.nonNullIterable(this.jaxbModel.getService(), (Function)new Function<Service, CompositeInterface>(){

            public CompositeInterface eval(Service service) {
                return JaxbCompositeAccessor.this.createInterface(new ElementContainer(JaxbCompositeAccessor.this.getVFileSystemProject(), service), service.getName(), null, CatalogInterfaceType.REFERENCE, null);
            }
        });
    }

    private Iterable<CompositeImport> getCompositeImports() {
        return this.nonNullIterable(this.jaxbModel.getImport(), (Function)new Function<Import, CompositeImport>(){

            public CompositeImport eval(Import value) {
                return new CompositeImport(value.getNamespace(), value.getLocation(), value.getImportType());
            }
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadComposite() throws CompositeAccessorException {
        ProjectLoader loader = this.getProject().getLoader();
        ProjectFileSystem fileSystem = loader.getProjectFileSystem();
        VFileSystem fs = fileSystem.getDataFileSystem();
        VFile compositeFile = fs.createFile("composite.xml");
        VFileInputStream vFileInputStream = null;
        try {
            if (compositeFile.exists()) {
                vFileInputStream = new VFileInputStream(compositeFile);
                JAXBElement element = CompositeUtils.loadScaElement((InputStream)vFileInputStream, Composite.class);
                this.jaxbModel = (Composite)element.getValue();
            } else {
                ObjectFactory objectFactory = new ObjectFactory();
                this.jaxbModel = objectFactory.createComposite();
            }
        }
        catch (JAXBException e) {
            try {
                throw new CompositeAccessorException((Throwable)e);
                catch (IOException e2) {
                    throw new CompositeAccessorException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{vFileInputStream});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CompositeComponent createComponent(Component component) throws CompositeAccessorException {
        String name = component.getName();
        JAXBElement implementationElement = component.getImplementation();
        Map<String, ScaPropertyInfo> componentProperties = this.buildPropertyMap(component.getProperty());
        CompositeComponent compositeComponent = new CompositeComponent(name, this.getType((JAXBElement<? extends Implementation>)implementationElement), this.getSrc((JAXBElement<? extends Implementation>)implementationElement), componentProperties);
        ProjectLoader loader = this.getProject().getLoader();
        VFileSystem fs = loader.getProjectFileSystem().getDataFileSystem();
        if (implementationElement == null) return compositeComponent;
        VFileInputStream componentInputStream = null;
        try {
            VFile componentFile = fs.createFile(name + ".componentType");
            if (componentFile.exists()) {
                componentInputStream = new VFileInputStream(componentFile);
                JAXBElement componentElement = CompositeUtils.loadScaElement((InputStream)componentInputStream, ComponentType.class);
                ComponentType componentType = (ComponentType)componentElement.getValue();
                List services = componentType.getService();
                VFileSystem fileSystemProject = this.getVFileSystemProject();
                for (Service service : services) {
                    ElementContainer objectContainer = new ElementContainer(fileSystemProject, service);
                    Map<String, ScaPropertyInfo> properties = this.buildPropertyMap(service.getProperty());
                    CompositeInterface compositeRef = this.createInterface(objectContainer, name, service.getName(), CatalogInterfaceType.SERVICE, properties);
                    if (compositeRef == null) continue;
                    compositeComponent.addService(compositeRef);
                }
                List references = componentType.getReference();
                for (Reference reference : references) {
                    ElementContainer objectContainer = new ElementContainer(fileSystemProject, reference);
                    Map<String, ScaPropertyInfo> properties = this.buildPropertyMap(reference.getProperty());
                    CompositeInterface compositeRef = this.createInterface(objectContainer, name, reference.getName(), CatalogInterfaceType.REFERENCE, properties);
                    if (compositeRef == null) continue;
                    compositeComponent.addReference(compositeRef);
                }
            }
        }
        catch (JAXBException e) {
            try {
                throw new CompositeAccessorException((Throwable)e);
                catch (IOException e2) {
                    throw new CompositeAccessorException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{componentInputStream});
        return compositeComponent;
    }

    private Map<String, ScaPropertyInfo> buildPropertyMap(List<Property> propertyList) {
        Map<String, ScaPropertyInfo> result;
        if (propertyList != null && !propertyList.isEmpty()) {
            result = new HashMap<String, ScaPropertyInfo>();
            for (Property property : propertyList) {
                ScaPropertyInfo info = CompositeUtils.convert((Property)property);
                result.put(info.name, info);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private CompositeServiceType getType(@Nullable JAXBElement<? extends Implementation> implementation) {
        CompositeServiceType result = CompositeServiceType.UNKNOWN;
        if (implementation != null) {
            Implementation value = (Implementation)implementation.getValue();
            if (value instanceof WorkflowImplementation) {
                result = CompositeServiceType.HUMAN_TASK;
            } else if (value instanceof BPELImplementation) {
                result = "implementation.bpmn".equals(implementation.getName().getLocalPart()) ? CompositeServiceType.BPMN : CompositeServiceType.BPEL;
            } else if (value instanceof EventAgentImplementation) {
                result = CompositeServiceType.EVENT_AGENT;
            } else if (value instanceof CEPImplementation) {
                result = CompositeServiceType.CEP;
            } else if (value instanceof MediatorImplementation) {
                result = CompositeServiceType.MEDIATOR;
            } else if (value instanceof DecisionImplementation) {
                result = CompositeServiceType.BUSINESS_RULE;
            } else if (value instanceof BPMNImplementation) {
                result = CompositeServiceType.BPMN;
            }
        }
        return result;
    }

    private String getSrc(@Nullable JAXBElement<? extends Implementation> implementation) {
        String result = null;
        if (implementation != null) {
            Implementation value = (Implementation)implementation.getValue();
            if (value instanceof WorkflowImplementation) {
                WorkflowImplementation impl = (WorkflowImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof BPELImplementation) {
                BPELImplementation impl = (BPELImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof EventAgentImplementation) {
                EventAgentImplementation impl = (EventAgentImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof CEPImplementation) {
                CEPImplementation impl = (CEPImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof MediatorImplementation) {
                MediatorImplementation impl = (MediatorImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof DecisionImplementation) {
                DecisionImplementation impl = (DecisionImplementation)value;
                result = impl.getSrc();
            } else if (value instanceof BPMNImplementation) {
                BPMNImplementation impl = (BPMNImplementation)value;
                result = impl.getSrc();
            }
        }
        return result;
    }

    private static class ElementContainer
    implements CompositeAccessor.CompositeObjectContainer {
        private Reference reference = null;
        private Service service = null;
        private VFileSystem vfileSystem = null;

        ElementContainer(@NotNull VFileSystem vfileSystem, @NotNull Reference reference) {
            this.vfileSystem = vfileSystem;
            this.reference = reference;
        }

        ElementContainer(@NotNull VFileSystem vfileSystem, @NotNull Service service) {
            this.vfileSystem = vfileSystem;
            this.service = service;
        }

        public String getName() {
            return this.service != null ? this.service.getName() : this.reference.getName();
        }

        public QName getInterfaceQName() {
            JAXBElement<? extends Interface> interfaceElement = this.getInterface();
            WSDLInterface wsdlInterface = (WSDLInterface)interfaceElement.getValue();
            String wsdlInterfaceValue = wsdlInterface.getInterface();
            return this.getInterfaceQname(wsdlInterfaceValue);
        }

        public QName getCallbankInterfaceQName() {
            JAXBElement<? extends Interface> interfaceElement = this.getInterface();
            WSDLInterface wsdlInterface = (WSDLInterface)interfaceElement.getValue();
            String callbackInterface = wsdlInterface.getCallbackInterface();
            QName interfaceQname = null;
            if (callbackInterface != null) {
                interfaceQname = this.getInterfaceQname(callbackInterface);
            }
            return interfaceQname;
        }

        public URL getWsdl() {
            Map<QName, String> otherAttributes = this.getOtherAttributes();
            QName qname = new QName("http://xmlns.oracle.com/soa/designer/", "wsdlLocation");
            URL url = null;
            String location = otherAttributes.get(qname);
            if (location != null) {
                try {
                    url = new URL(location);
                }
                catch (MalformedURLException e) {
                    VFile file = this.vfileSystem.createFile(location);
                    try {
                        url = file.toURL();
                    }
                    catch (IOException e1) {
                        url = null;
                    }
                }
            }
            return url;
        }

        @NotNull
        public CompositeServiceType getInterfaceType() {
            WSDLInterface wsdlInterface;
            String value;
            CompositeServiceType result = CompositeServiceType.WEB_SERVICE;
            JAXBElement<? extends Interface> interfaceElement = this.getInterface();
            Interface scaInterface = (Interface)interfaceElement.getValue();
            if (scaInterface != null && scaInterface instanceof WSDLInterface && (value = (wsdlInterface = (WSDLInterface)scaInterface).getInterface()) != null) {
                if (value.contains(JaxbCompositeAccessor.HUMAN_TASK_INTERFACE_ID)) {
                    result = CompositeServiceType.HUMAN_TASK;
                } else if (value.contains(JaxbCompositeAccessor.BUSINESS_RULE_INTERFACE_ID)) {
                    result = CompositeServiceType.BUSINESS_RULE;
                }
            }
            return result;
        }

        private JAXBElement<? extends Interface> getInterface() {
            return this.service != null ? this.service.getInterface() : this.reference.getInterface();
        }

        private Map<QName, String> getOtherAttributes() {
            return this.service != null ? this.service.getOtherAttributes() : this.reference.getOtherAttributes();
        }

        private QName getInterfaceQname(String wsdlInterfaceValue) {
            int index = wsdlInterfaceValue.indexOf(JaxbCompositeAccessor.WSDL_INTERFACE);
            String namespace = wsdlInterfaceValue.substring(0, index);
            String portName = wsdlInterfaceValue.substring(index + JaxbCompositeAccessor.WSDL_INTERFACE.length() + 1, wsdlInterfaceValue.length() - 1);
            return new QName(namespace, portName);
        }
    }
}

