/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectUtils;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class ExternalResourceImpl
extends Configuration
implements ExternalResource.Mutable {
    private boolean deletable = true;
    private boolean dirty;
    private String id;
    private boolean modified;
    private Path path;
    private Project project;
    private boolean readOnly;

    public ExternalResourceImpl(Project project, String name, ConfigType type) {
        this(project, name, type, new Properties());
    }

    public ExternalResourceImpl(Project project, String name, ConfigType type, Properties properties) {
        super(name, type, properties);
        this.project = project;
        this.setId(name);
        ProjectFileSystem projectFileSystem = project.getLoader().getProjectFileSystem();
        File projectBaseDir = projectFileSystem.getLocalFileSystem().getRootFolder();
        this.setProperty("project.basedir", projectBaseDir.getPath());
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.EXTERNAL_RESOURCE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.EXTERNAL_RESOURCES.create(this.getId());
        }
        return this.path;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.equals(projectObject) || this.getProject().equals(projectObject);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    public ProjectObject findChild(ProjectObjectType type, String id) {
        return null;
    }

    public ProjectObject getParent() {
        return this.getProject();
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
    }

    public boolean isModified() {
        return this.modified;
    }

    public ExternalResourceImpl clone(String name) {
        return new ExternalResourceImpl(this.project, name, this.getConfigType(), this.properties);
    }

    public ExternalResourceImpl clone(ConfigType configType) {
        return new ExternalResourceImpl(this.project, this.getName(), configType, this.properties);
    }

    public ExternalResourceImpl clone() {
        return new ExternalResourceImpl(this.project, this.getName(), this.getConfigType(), this.properties);
    }

    @Override
    @NotNull
    public ExternalResource.Mutable asMutable() {
        return this;
    }

    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        return CollectionUtils.emptySequence();
    }

    @Override
    public boolean isActive() {
        return ProjectUtils.isActive(this);
    }

    @Override
    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    @Override
    public void replaceProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void setDefault(boolean isDefault) {
    }

    @Override
    public void delete() throws ProjectException {
    }

    @Override
    public int getPosition() {
        return -1;
    }

    @Override
    public Class getRawClass() {
        return ExternalResource.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    @Override
    public ResourceObject findResourceObject() {
        return this;
    }

    @Override
    public String asXml() throws ProjectException {
        return "";
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void addListener(ProjectListener listener) {
    }

    @Override
    public void removeListener(ProjectListener listener) {
    }
}

