/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bamdata;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import oracle.bpm.bamdata.BAMResourceRunningInfo;
import oracle.bpm.bamdata.BAMRunningInfo;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.bamdata.UnitType;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum TimeIndicator implements Indicator,
I18nProvider
{
    AVG_PROCESS(ProjectMsg.AVG_PROCESS){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getAvgProcessTime());
        }
    }
    ,
    AVG_CYCLE(ProjectMsg.AVG_CYCLE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getAvgCycleTime());
        }
    }
    ,
    MAX_CYCLE(ProjectMsg.MAX_CYCLE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMaxCycleTime());
        }
    }
    ,
    MIN_CYCLE(ProjectMsg.MIN_CYCLE){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMinCycleTime());
        }
    }
    ,
    AVG_WAIT(ProjectMsg.AVG_WAIT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getAvgWaitTime());
        }
    }
    ,
    MAX_WAIT(ProjectMsg.MAX_WAIT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMaxWaitTime());
        }
    }
    ,
    MIN_WAIT(ProjectMsg.MIN_WAIT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMinWaitTime());
        }
    }
    ,
    AVG_WORK(ProjectMsg.AVG_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getAvgWorkTime());
        }
    }
    ,
    MAX_WORK(ProjectMsg.MAX_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMaxWorkTime());
        }
    }
    ,
    MIN_WORK(ProjectMsg.MIN_WORK){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)runningInfo.getMinWorkTime());
        }
    }
    ,
    RESOURCE_BUSY(ProjectMsg.RESOURCE_BUSY){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)((BAMResourceRunningInfo)runningInfo).getBusyTime());
        }
    }
    ,
    RESOURCE_WAIT(ProjectMsg.RESOURCE_WAIT){

        @Override
        public Object get(BAMRunningInfo runningInfo) {
            return Interval.valueOf((long)((BAMResourceRunningInfo)runningInfo).getWaitTime());
        }
    };

    private transient Msg msg;
    public static final Set<TimeIndicator> DEFAULT_INDICATORS;
    public static final Set<TimeIndicator> RESOURCE_INDICATORS;

    private TimeIndicator(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public Object get(BAMRunningInfo runningInfo) {
        return 0.0;
    }

    @Override
    public boolean isResourceIndicator() {
        return RESOURCE_INDICATORS.contains(this);
    }

    @Override
    public UnitType getUnitType() {
        return UnitType.TIME;
    }

    static {
        DEFAULT_INDICATORS = EnumSet.of(AVG_CYCLE, AVG_WAIT, AVG_WORK);
        RESOURCE_INDICATORS = EnumSet.of(RESOURCE_BUSY, RESOURCE_WAIT);
    }
}

