/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.Event;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.Random;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;

public class SplitSimulationActivityImpl
extends SimulationFlowNodeImpl {
    protected SplitSimulationActivityImpl(FlowNode node) {
        super(node);
    }

    @Override
    public void scheduleMove(long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        this.scheduleParent(currentTime, token, eventQueue);
        this.scheduleNormalTransitions(currentTime, token, eventQueue, random);
        this.scheduleOthers(currentTime, token, eventQueue, random);
    }

    protected void scheduleNormalTransitions(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        Sequence<SequenceFlow> list = ModelUtils.getOutgoingSequenceFlows(this.getFlowNode());
        for (SequenceFlow aList : list) {
            SequenceFlowImpl transition = (SequenceFlowImpl)aList;
            boolean schedule = false;
            if (transition.isUnconditional()) {
                schedule = true;
            } else if (transition.isConditional()) {
                double prob = random.nextDouble();
                boolean bl = schedule = prob <= this.getTransitionProbability(transition, 0.0);
            }
            if (!schedule) continue;
            Event event = Event.createMoveEvent(Token.create(token, currentTime, false), currentTime, this.getFlowNode(), transition.getTarget(), transition);
            eventQueue.offer((Object)event);
        }
    }

    protected void scheduleOthers(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        ArrayList<SequenceFlow> list = new ArrayList<SequenceFlow>();
        this.addOtherTransitions(list);
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            SequenceFlowImpl transition;
            double prob = random.nextDouble();
            if (!(prob <= this.getTransitionProbability(transition = (SequenceFlowImpl)list.get(i), 0.0))) continue;
            Event event = Event.createMoveEvent(Token.create(token, currentTime, false), currentTime, this.getFlowNode(), transition.getTarget(), transition);
            eventQueue.offer((Object)event);
        }
    }

    private void scheduleParent(long currentTime, Token token, PriorityQueue<Event> eventQueue) {
        NodeAssociationFeature joinFeature = this.getFlowNode().getFeature(NodeAssociationFeature.class);
        SequenceFlow transition = this.getDynamicTransition(joinFeature.getValue());
        Event event = Event.createImmediateMoveEvent(token, currentTime, this.getFlowNode(), transition.getTarget(), transition);
        eventQueue.offer((Object)event);
    }
}

