/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ModelSimulationProcessImpl;
import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.UndeletableFolderContainerImpl;
import oracle.bpm.project.model.ModelSimulationProcess;
import oracle.bpm.project.model.ModelSimulationsContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectSimulationsContainer;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import org.jetbrains.annotations.NotNull;

public class SimulationsContainerImpl
extends UndeletableFolderContainerImpl
implements SimulationsContainer {
    private ModelSimulationsContainer modelSimulationsContainer;
    private ProjectSimulationsContainer projectSimulationsContainer;

    public SimulationsContainerImpl(@NotNull Project project) {
        super(project, project, Path.SIMULATIONS.getName());
    }

    public SimulationsContainerImpl(@NotNull Project project, ResourceContainer container, @NotNull String id) {
        super(project, container, id);
        this.path = Path.SIMULATIONS;
    }

    @Override
    public ProjectSimulationsContainer getProjectSimulationsContainer() {
        return this.findChild(ProjectSimulationsContainer.class, Path.SIMULATIONS_DEFINITIONS.getName());
    }

    @Override
    public ModelSimulationsContainer getModelSimulationsContainer() {
        return this.findChild(ModelSimulationsContainer.class, Path.SIMULATIONS_MODELS.getName());
    }

    @Override
    public Collection<ProjectSimulation> getProjectSimulations() {
        return CollectionUtils.createCopy(this.getProjectSimulationsContainer().getChildrenByType(ProjectSimulation.class));
    }

    @Override
    @NotNull
    public Sequence<ModelSimulation> getModelSimulationsByProcess(String id) {
        ModelSimulationProcess simulationProcess = this.getModelSimulationsContainer().findChild(ModelSimulationProcess.class, id);
        return simulationProcess == null ? CollectionUtils.emptySequence() : simulationProcess.getChildrenByType(ModelSimulation.class);
    }

    @Override
    public Sequence<ModelSimulation> getModelSimulationsByProcess(Process process) {
        return this.getModelSimulationsByProcess(process.getId());
    }

    @Override
    public ProjectSimulation createAndAddProjectSimulation(String simulationId) throws ProjectException {
        ProjectSimulation projectSimulation = this.createProjectSimulation(simulationId);
        this.addProjectSimulation(projectSimulation);
        return projectSimulation;
    }

    @Override
    public ModelSimulation createAndAddModelSimulation(Process process, String simulationId) throws ProjectException {
        ModelSimulation modelSimulation = this.createModelSimulation(process, simulationId);
        this.addModelSimulation(process.getId(), modelSimulation);
        return modelSimulation;
    }

    @Override
    public void addProjectSimulation(ProjectSimulation simulation) throws ProjectException {
        this.getProjectSimulationsContainer().addChild(simulation);
    }

    @Override
    public void removeProjectSimulation(ProjectSimulation projectSimulation) throws ProjectException {
        this.getProjectSimulationsContainer().removeChild(projectSimulation);
    }

    @Override
    public ProjectSimulation removeProjectSimulation(String simulationId) throws ProjectException {
        ProjectSimulation result = this.findProjectSimulation(simulationId);
        if (result != null) {
            this.removeProjectSimulation(result);
        }
        return result;
    }

    @Override
    public ProjectSimulation findProjectSimulation(String simulationId) {
        return this.getProjectSimulationsContainer().findChild(ProjectSimulation.class, simulationId);
    }

    @Override
    public ModelSimulation findModelSimulation(String modelId, String modelSimulationId) {
        ModelSimulationProcess modelSimulationProcess = this.getModelSimulationsContainer().findChild(ModelSimulationProcess.class, modelId);
        ModelSimulation modelSimulation = null;
        if (modelSimulationProcess != null) {
            modelSimulation = modelSimulationProcess.findChild(ModelSimulation.class, modelSimulationId);
        }
        return modelSimulation;
    }

    @Override
    public ModelSimulation findModelSimulation(Process model, String modelSimulationId) {
        return this.findModelSimulation(model.getId(), modelSimulationId);
    }

    @Override
    public void replaceModelSimulation(ModelSimulation newModelSim) throws ProjectException {
        ModelSimulation modelSimulation = this.findModelSimulation(newModelSim.getProcess(), newModelSim.getId());
        this.getModelSimulationsContainer().replaceChild(modelSimulation, newModelSim);
    }

    @Override
    public void replaceProjectSimulation(ProjectSimulation newObject) throws ProjectException {
        ProjectSimulation projectSimulation = this.findProjectSimulation(newObject.getId());
        this.getProjectSimulationsContainer().replaceChild(projectSimulation, newObject);
    }

    @Override
    public void removeModelSimulations() throws ProjectException {
    }

    @Override
    public void addModelSimulation(String processId, ModelSimulation modelSimulation) throws ProjectException {
        ModelSimulationProcess modelSimulationProcess = this.getModelSimulationsContainer().findChild(ModelSimulationProcess.class, processId);
        if (modelSimulationProcess == null) {
            modelSimulationProcess = new ModelSimulationProcessImpl(this.getProject(), this.getModelSimulationsContainer(), processId);
            this.getModelSimulationsContainer().addChild(modelSimulationProcess);
        }
        modelSimulationProcess.addChild(modelSimulation);
    }

    @Override
    public void removeModelSimulation(String processId, ModelSimulation modelSimulation) throws ProjectException {
        ModelSimulationProcess modelSimulationProcess = this.getModelSimulationsContainer().findChild(ModelSimulationProcess.class, processId);
        if (modelSimulationProcess != null) {
            modelSimulationProcess.removeChild(modelSimulation);
        }
    }

    @Override
    public void removeAllModelSimulations(String processId) throws ProjectException {
        ModelSimulationProcess modelSimulationProcess = this.getModelSimulationsContainer().findChild(ModelSimulationProcess.class, processId);
        if (modelSimulationProcess != null) {
            ProjectObject[] modelSimArray;
            for (ProjectObject modelSimulation : modelSimArray = (ProjectObject[])modelSimulationProcess.getChildren().toArray((Object[])new ProjectObject[0])) {
                modelSimulationProcess.removeChild(modelSimulation);
            }
            this.getModelSimulationsContainer().removeChild(modelSimulationProcess);
        }
    }
}

