/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import org.jetbrains.annotations.NotNull;

public class SimulationResourceImpl
extends ProjectObjectImpl
implements ModelEvent,
SimulationResource {
    private int availability = 100;
    private int capacity = 1;
    private double cost = 1.0;
    private double efficiency = 100.0;
    private String id;
    private List<ModelListener> listeners = new ArrayList<ModelListener>();
    private ProjectSimulation projectSimulation;
    private String[] roles = new String[0];
    private boolean selected = true;
    private boolean virtual = false;

    public SimulationResourceImpl(Project project) {
        super(project);
    }

    public SimulationResourceImpl(Project project, String resourceId) {
        this(project);
        this.id = resourceId;
    }

    public void setProjectSimulation(ProjectSimulation projectSimulation) {
        this.projectSimulation = projectSimulation;
    }

    @Override
    public void setAvailability(int availability) {
        int oldValue = this.availability;
        this.availability = availability;
        this.events().objectChanged("availability", oldValue, availability);
    }

    @Override
    public int getAvailability() {
        return this.availability;
    }

    @Override
    public void setCapacity(int capacity) {
        int oldValue = this.capacity;
        this.capacity = capacity;
        this.fireCapacityChangedEvent();
        this.events().objectChanged("availability", oldValue, capacity);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCost(double cost) {
        double oldValue = this.cost;
        this.cost = cost;
        this.events().objectChanged("cost", oldValue, cost);
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public void setEfficiency(double efficiency) {
        double oldValue = this.efficiency;
        this.efficiency = efficiency;
        this.events().objectChanged("efficiency", oldValue, efficiency);
    }

    @Override
    public double getEfficiency() {
        return this.efficiency;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.SIMULATION_RESOURCE;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.projectSimulation;
    }

    public String getRoleList() {
        String[] roles = this.getRoles();
        StringBuffer roleListBuffer = new StringBuffer();
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (i != 0) {
                roleListBuffer.append(",");
            }
            roleListBuffer.append(role);
        }
        return roleListBuffer.toString();
    }

    @Override
    public void setRoles(String[] roles) {
        String[] oldValue = this.roles;
        this.roles = roles;
    }

    @Override
    public String[] getRoles() {
        return this.roles;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean oldValue = this.selected;
        this.selected = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    public void addListener(ModelListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimulationResourceImpl)) {
            return false;
        }
        SimulationResource resource = (SimulationResource)o;
        if (this.getCapacity() != resource.getCapacity()) {
            return false;
        }
        if (this.getAvailability() != resource.getAvailability()) {
            return false;
        }
        if (this.getCost() != resource.getCost()) {
            return false;
        }
        return this.getEfficiency() == resource.getEfficiency() && this.getId().equals(resource.getId());
    }

    @Override
    public boolean hasRole(String role) {
        return Arrays.asList(this.getRoles()).contains(role);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        long temp = this.cost != 0.0 ? Double.doubleToLongBits(this.cost) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = this.efficiency != 0.0 ? Double.doubleToLongBits(this.efficiency) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + this.availability;
        result = 29 * result + this.capacity;
        return result;
    }

    public String toString() {
        return "Resource {id='" + this.id + "'" + ", availability=" + this.availability + ", virtual=" + this.virtual + ", cost=" + this.cost + ", efficiency=" + this.efficiency + ", capacity=" + this.capacity + "}";
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.virtual = isVirtual;
    }

    @Override
    public int compareTo(SimulationResource simulationResource) {
        return this.getId().compareTo(simulationResource.getId());
    }

    private void fireCapacityChangedEvent() {
        for (ModelListener listener : this.listeners) {
            listener.capacityChanged(this);
        }
    }
}

