/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.Event;
import fuego.simulation.ResourceInfo;
import fuego.simulation.SimulationEventListener;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Heap;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;
import org.jetbrains.annotations.NotNull;

public abstract class Simulation
implements Runnable,
ModelListener,
Run {
    protected long currentTime;
    @NotNull
    protected PriorityQueue<Event> eventQueue;
    protected long pausedTime;
    protected boolean performingAnimation;
    @NotNull
    protected final Random random;
    protected boolean simulationPaused;
    protected long simulationPauseEndTime;
    protected long simulationPauseStartTime;
    protected long startTime;
    protected int stepIncrement = 10;
    protected volatile boolean stopSimulation;
    @NotNull
    private final ArrayList<Event> eventList;
    private long finishTime;
    @NotNull
    private final ArrayList<SimulationEventListener> listenerList;
    private boolean pauseSimulation;
    private final ProjectSimulation projectSimulation;
    private boolean running;
    private boolean sleeping;
    private int timeScalePct = 50;
    private static final long HALF_SECOND = 500L;

    public Simulation(ProjectSimulation projectSimulation) {
        this.projectSimulation = projectSimulation;
        this.random = new Random();
        this.listenerList = new ArrayList();
        this.eventList = new ArrayList();
        this.eventQueue = Heap.create();
    }

    public abstract ModelSimulation getModel(String var1);

    public abstract int getProcessInstanceCount(Process var1);

    public abstract Map<Process, Integer> getProcessInstanceCountMap();

    public abstract ModelSimulation getProcessModel(Process var1);

    public abstract void setProcessRuntimeInfo(String var1, ActivityInfo var2);

    public abstract ProcessInfo getProcessRuntimeInfo(String var1);

    public abstract String[] getProcesses();

    public abstract String[] getProcessNames();

    public abstract ResourceInfo getResourceInfo(Simulation var1, ProjectSimulation var2, SimulationResource var3);

    @Override
    public long getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public long getFinishTime() {
        return this.finishTime;
    }

    public int getNextCategory(ProjectSimulation model) {
        int result;
        double[] categoryProbabilities = model.getCategoryProbabilities();
        if (categoryProbabilities == null) {
            result = -1;
        } else {
            double prob = this.random.nextDouble();
            for (result = 0; result < categoryProbabilities.length && prob >= 0.0; prob -= categoryProbabilities[result], ++result) {
            }
            --result;
        }
        return result;
    }

    public void setPerformingAnimation(boolean performingAnimation) {
        this.performingAnimation = performingAnimation;
    }

    public boolean isPerformingAnimation() {
        return this.performingAnimation;
    }

    public ProjectSimulation getProjectSimulation() {
        return this.projectSimulation;
    }

    @NotNull
    public Random getRandom() {
        return this.random;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    public synchronized void setSimulationPaused(boolean simulationPaused) {
        boolean doNotify = !simulationPaused && this.simulationPaused;
        this.simulationPaused = simulationPaused;
        if (doNotify) {
            this.notify();
        }
    }

    public boolean isSimulationPaused() {
        return this.simulationPaused;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void setStepIncrement(int stepIncrement) {
        this.stepIncrement = stepIncrement;
    }

    public int getStepIncrement() {
        return this.stepIncrement;
    }

    public synchronized void setTimeScalePct(int value) {
        if (this.sleeping) {
            this.notify();
        }
        this.timeScalePct = value;
    }

    public void addEventListener(SimulationEventListener l) {
        this.listenerList.add(l);
    }

    @Override
    public void capacityChanged(ModelEvent e) {
        boolean wasPaused = this.simulationPaused;
        this.pause();
        ArrayList<ActivityInfo> activities = new ArrayList<ActivityInfo>();
        if (e instanceof SimulationFlowNodeImpl) {
            SimulationFlowNodeImpl simulationActivityImpl = (SimulationFlowNodeImpl)e;
            ActivityInfo activityRuntimeInfo = (ActivityInfo)this.getProcessRuntimeInfo(simulationActivityImpl.getFlowNode().getProcess().getId()).getActivity(e.getId());
            activityRuntimeInfo.setCapacity(e.getCapacity());
            activities.add(activityRuntimeInfo);
        } else {
            this.resourceCapacityChanged(e, activities);
        }
        this.changeCapacity(activities, wasPaused);
    }

    public synchronized void pause() {
        while (!this.simulationPaused && !this.stopSimulation) {
            this.pauseSimulation = true;
            if (this.sleeping) {
                this.notify();
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void removeEventListener(SimulationEventListener l) {
        this.listenerList.remove(l);
    }

    public synchronized void resume() {
        this.simulationPaused = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            this.runSimulation();
        }
        finally {
            this.stopSimulation();
            this.running = false;
        }
    }

    public synchronized void stopSimulation() {
        this.stopSimulation = true;
        this.performingAnimation = false;
        this.simulationPaused = false;
        this.finishTime = this.currentTime;
        this.notify();
    }

    public int getTimeScalePct() {
        return this.timeScalePct;
    }

    protected abstract void generateFirstEvent(long var1);

    protected abstract void resourceCapacityChanged(ModelEvent var1, List<ActivityInfo> var2);

    protected abstract void runSimulation();

    protected abstract void simulate(long var1, int var3);

    protected static Subprocess getParentGroup(FlowNode node) {
        return node.getSubprocess();
    }

    protected long getNextIAT(ModelSimulation simulationModel) {
        return this.currentTime + simulationModel.getDistributions()[0].next(this.random, this.currentTime);
    }

    protected long getNextIAT(SimulationFlowNode simulationActivity) {
        return this.currentTime + simulationActivity.getDistribution().next(this.random, this.currentTime);
    }

    protected synchronized void checkPause() {
        boolean wasSimulationPaused = false;
        if (this.pauseSimulation) {
            this.simulationPauseStartTime = System.currentTimeMillis() * 1000L;
            this.simulationPaused = true;
            this.pauseSimulation = false;
            wasSimulationPaused = true;
            this.notify();
        }
        while (this.simulationPaused) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (wasSimulationPaused) {
            this.simulationPauseEndTime = System.currentTimeMillis() * 1000L;
        }
    }

    protected void fireEventDue(Event e) {
        if (this.performingAnimation && !this.listenerList.isEmpty()) {
            Event last = (Event)CollectionUtils.last(this.eventList);
            if (last != null && (last.getDueTime() != e.getDueTime() || last.getStep() != e.getStep())) {
                this.doNotify();
                this.eventList.clear();
            }
            this.eventList.add(e);
        }
    }

    protected synchronized void letsTimePass(long sleepTime) {
        if (this.pauseSimulation || this.simulationPaused) {
            return;
        }
        if (sleepTime > 1000L) {
            this.stepIncrement = 100 / ((int)(((double)sleepTime - 1000.0) / 4000.0) * 10 + 10);
            try {
                this.sleeping = true;
                this.wait(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sleeping = false;
        } else {
            this.stepIncrement = sleepTime < 1000L ? 100 / ((int)((double)sleepTime / 1000.0) * 6 + 4) : 10;
        }
    }

    protected void resourceCapacityChanged(ModelEvent e, List<ActivityInfo> activities, ProcessInfo processInfo) {
        if (!processInfo.containsResourceInfo(e.getId())) {
            return;
        }
        ResourceInfo resourceRuntimeInfo = (ResourceInfo)processInfo.getResourceInfo(e.getId());
        resourceRuntimeInfo.setCapacity(e.getCapacity());
        for (SimulationFlowNode activityModel : this.getModel(processInfo.getName()).getSimulationFlowNodes()) {
            ActivityInfo activityRuntimeInfo = (ActivityInfo)processInfo.getActivity(activityModel.getId());
            if (!activityRuntimeInfo.containsResourceInfo(e.getId())) continue;
            ((ResourceInfo)activityRuntimeInfo.getResourceInfo(e.getId())).setCapacity(e.getCapacity());
            activities.add(activityRuntimeInfo);
        }
    }

    protected synchronized void terminateSimulation() {
        if (this.performingAnimation && !this.listenerList.isEmpty()) {
            Event event = this.stopSimulation ? Event.createStop(this.getCurrentTime()) : Event.createEnd(this.getCurrentTime());
            this.eventList.add(event);
            this.doNotify();
        }
    }

    private void changeCapacity(List<ActivityInfo> activities, boolean wasPaused) {
        for (ActivityInfo activityRuntimeInfo : activities) {
            for (Token token : activityRuntimeInfo.activate()) {
                if (token == null) continue;
                ModelSimulation modelSimulation = this.getModel(token.getProcessInfo().getName());
                SimulationFlowNode simulationActivity = modelSimulation.findSimulationFlowNode(activityRuntimeInfo.getName());
                if (simulationActivity == null) {
                    simulationActivity = modelSimulation.createSimulationFlowNode(activityRuntimeInfo.getName());
                    try {
                        modelSimulation.addSimulationFlowNode(simulationActivity);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                }
                ((SimulationFlowNodeImpl)simulationActivity).scheduleMove(this.currentTime, this.currentTime, token, this.eventQueue, this.random);
            }
        }
        if (!wasPaused) {
            this.resume();
        }
    }

    private void doNotify() {
        if (!this.listenerList.isEmpty()) {
            for (SimulationEventListener listener : new ArrayList<SimulationEventListener>(this.listenerList)) {
                listener.eventDue(this.eventList);
            }
        }
    }
}

