/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.SimulationResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.Priority;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class ProjectSimulationImpl
extends ResourceObjectImpl
implements ProjectListener<Process>,
ProjectSimulation,
ResourceObject {
    private String[] categoryLabels = new String[]{Priority.LOWEST.getString(), Priority.LOW.getString(), Priority.NORMAL.getString(), Priority.HIGH.getString(), Priority.HIGHEST.getString()};
    private double[] categoryProbabilities = new double[]{0.2, 0.2, 0.2, 0.2, 0.2};
    private Interval duration = Interval.valueOf((long)10000000L);
    private boolean inflightFinish = false;
    private Collection<ModelSimulation> modelSimulations = new ArrayList<ModelSimulation>();
    private String name;
    private Map<String, SimulationResource> simulationResources = new TreeMap<String, SimulationResource>();
    private long startTime = Time.now().getMicroSeconds();
    private BooleanFeature useCalendarRules = BooleanFeature.create("useCalendarRules", false);

    public ProjectSimulationImpl(Project project) {
        super(project);
        this.init();
    }

    public ProjectSimulationImpl(Project project, String name) {
        this(project);
        this.setId(name);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT_SIMULATION;
    }

    @Override
    public void setCategoryLabels(String[] categoryLabels) {
        String[] oldValues = this.categoryLabels;
        this.categoryLabels = categoryLabels;
        this.events().objectChanged("categoryLabels", oldValues, categoryLabels);
    }

    @Override
    public String[] getCategoryLabels() {
        return this.categoryLabels;
    }

    @Override
    public void setCategoryProbabilities(double[] probabilities) {
        double[] oldValues = this.categoryProbabilities;
        this.categoryProbabilities = probabilities;
        this.events().objectChanged("categoryProbabilities", oldValues, probabilities);
    }

    @Override
    public double[] getCategoryProbabilities() {
        return this.categoryProbabilities;
    }

    @Override
    public void setDuration(Interval duration) {
        Interval oldValue = this.duration;
        this.duration = duration;
        this.events().objectChanged("duration", oldValue, duration);
    }

    @Override
    public Interval getDuration() {
        return this.duration;
    }

    @Override
    public ModelSimulation findModelSimulation(String modelId) {
        if (!this.modelSimulations.isEmpty()) {
            for (ModelSimulation aModelSimulation : this.modelSimulations) {
                if (!aModelSimulation.getProcess().getId().equals(modelId)) continue;
                return aModelSimulation;
            }
        }
        return null;
    }

    @Override
    public String findModelSimulationId(String modelId) {
        ModelSimulation modelSimulation = this.findModelSimulation(modelId);
        if (modelSimulation != null) {
            return modelSimulation.getId();
        }
        return null;
    }

    @Override
    public Collection<ModelSimulation> getModelSimulations() {
        return Collections.unmodifiableCollection(this.modelSimulations);
    }

    @Override
    public boolean containsModel(String modelId) {
        if (!this.modelSimulations.isEmpty()) {
            for (ModelSimulation modelSimulation : this.modelSimulations) {
                if (!modelSimulation.getProcess().getId().equals(modelId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<SimulationResource> getResources() {
        return this.simulationResources.values();
    }

    @Override
    public SimulationResource createResource(String resourceId) {
        return new SimulationResourceImpl(this.getProject(), resourceId);
    }

    @Override
    public SimulationResource findResource(String s) {
        return this.simulationResources.get(s);
    }

    public List<SimulationResource> getResourcesAssignedToRole(String roleId) {
        ArrayList<SimulationResource> result = new ArrayList<SimulationResource>();
        for (SimulationResource resourceModel : this.getResources()) {
            if (!resourceModel.hasRole(roleId)) continue;
            result.add(resourceModel);
        }
        return result;
    }

    @Override
    public void setStartTime(Time startTime) {
        long oldValue = this.startTime;
        this.startTime = startTime.getMicroSeconds();
        this.events().objectChanged("startTime", oldValue, startTime);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setUseCalendarRules(boolean useCalendarRules) {
        this.useCalendarRules.setValue(useCalendarRules);
        this.events().objectChanged((ProjectObject)this, this.useCalendarRules);
    }

    @Override
    public boolean getUseCalendarRules() {
        return this.useCalendarRules.getValue();
    }

    @Override
    public void addModelSimulation(ModelSimulation modelSimulation) throws ProjectException {
        assert (modelSimulation != null);
        Process model = modelSimulation.getProcess();
        if (model != null && this.containsModel(model.getId())) {
            throw new ProjectException(modelSimulation, ProjectMsg.SIMULATION_PROJECT_HAS_MODEL);
        }
        this.modelSimulations.add(modelSimulation);
    }

    @Override
    public void removeModelSimulation(ModelSimulation modelSimulation) throws ProjectException {
        if (!this.containsModel(modelSimulation.getProcess().getId())) {
            throw new ProjectException(modelSimulation, ProjectMsg.SIMULATION_MODEL_NOT_PRESENT);
        }
        this.modelSimulations.remove(modelSimulation);
    }

    @Override
    public void removeModelSimulations(Collection<ModelSimulation> simulations) throws ProjectException {
        if (!this.modelSimulations.containsAll(simulations)) {
            throw new ProjectException(this, ProjectMsg.SIMULATION_MODEL_NOT_PRESENT);
        }
        Collection<ModelSimulation> checkedModelSimulations = Collections.checkedCollection(simulations, ModelSimulation.class);
        this.modelSimulations.removeAll(checkedModelSimulations);
    }

    @Override
    public void addResource(SimulationResource simulationResource) throws ProjectException {
        if (this.simulationResources.containsKey(simulationResource.getId())) {
            throw new ProjectException(simulationResource, ProjectMsg.SIMULATION_MODEL_HAS_RESOURCE);
        }
        ((SimulationResourceImpl)simulationResource).setProjectSimulation(this);
        this.events().preObjectAdded(simulationResource, (ProjectObject)this);
        this.simulationResources.put(simulationResource.getId(), simulationResource);
        this.events().postObjectAdded(simulationResource, (ProjectObject)this);
        this.events().objectChanged("simulationResources", null, this.simulationResources);
    }

    @Override
    public void removeResource(SimulationResource simulationResource) throws ProjectException {
        if (!this.simulationResources.containsKey(simulationResource.getId())) {
            throw new ProjectException(this, ProjectMsg.SIMULATION_RESOURCE_NOT_PRESENT);
        }
        this.events().preObjectAdded(simulationResource, (ProjectObject)this);
        this.simulationResources.remove(simulationResource.getId());
        this.events().postObjectRemoved(simulationResource, (ProjectObject)this);
        ((SimulationResourceImpl)simulationResource).setProjectSimulation(null);
        this.events().objectChanged("simulationResources", null, this.simulationResources);
    }

    @Override
    public void removeResources(Collection<SimulationResource> simResources) throws ProjectException {
        if (!this.simulationResources.values().containsAll(simResources)) {
            throw new ProjectException(this, ProjectMsg.SIMULATION_RESOURCE_NOT_PRESENT);
        }
        ArrayList<SimulationResource> checkedSimulationResources = new ArrayList<SimulationResource>(simResources);
        for (SimulationResource simulationResource : checkedSimulationResources) {
            this.events().preObjectRemoved(simulationResource, (ProjectObject)this);
        }
        for (SimulationResource simulationResource : checkedSimulationResources) {
            this.simulationResources.remove(simulationResource.getId());
        }
        for (SimulationResource simulationResource : checkedSimulationResources) {
            this.events().postObjectRemoved(simulationResource, (ProjectObject)this);
            ((SimulationResourceImpl)simulationResource).setProjectSimulation(null);
        }
        this.events().objectChanged("simulationResources", null, this.simulationResources);
    }

    @Override
    public void removeAllResources() throws ProjectException {
        ArrayList<SimulationResource> checkedSimulationResources = new ArrayList<SimulationResource>(this.simulationResources.values());
        for (SimulationResource simulationResource : checkedSimulationResources) {
            this.events().preObjectRemoved(simulationResource, (ProjectObject)this);
        }
        this.simulationResources.clear();
        for (SimulationResource simulationResource : checkedSimulationResources) {
            this.events().postObjectRemoved(simulationResource, (ProjectObject)this);
            ((SimulationResourceImpl)simulationResource).setProjectSimulation(null);
        }
        this.events().objectChanged("simulationResources", null, this.simulationResources);
    }

    public void init() {
        this.duration = Interval.ONE_HOUR;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public long getDurationMicroseconds() {
        return this.duration.getTotalMicroseconds();
    }

    @Override
    public boolean getInflightFinish() {
        return this.inflightFinish;
    }

    @Override
    public void setInflightFinish(boolean inflightFinish) {
        this.inflightFinish = inflightFinish;
    }

    public void setInflightFinish(String inflightFinish) {
        this.setInflightFinish(Boolean.valueOf(inflightFinish));
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.SIMULATIONS.create(this.getId());
        }
        return this.path;
    }

    @Override
    public ProjectObject getParentObject() {
        SimulationsContainer simulationsContainer;
        Project p = this.getProject();
        if (p != null && (simulationsContainer = p.getSimulations()) != null) {
            return simulationsContainer.getProjectSimulationsContainer();
        }
        return null;
    }

    @Override
    public void setId(String id) {
        this.name = id;
    }

    @Override
    public Class<Process> getSupportedTypes() {
        return Process.class;
    }

    @Override
    public void preObjectAdded(Process object, ProjectObject parent) throws ProjectException {
    }

    @Override
    public void preObjectRemoved(Process object, ProjectObject parent) throws ProjectException {
    }

    @Override
    public void postObjectAdded(Process object, ProjectObject parent) {
    }

    @Override
    public void postObjectRemoved(Process object, ProjectObject parent) {
        SimulationsContainer simulationsContainer = object.getProject().getSimulations();
        for (ModelSimulation modelSimulation : simulationsContainer.getModelSimulationsByProcess(object)) {
            if (!this.modelSimulations.contains(modelSimulation)) continue;
            this.modelSimulations.remove(modelSimulation);
        }
    }

    @Override
    public void objectChanged(Process projectObject, ProjectEvent event) {
    }

    @Override
    public void objectReplaced(Process oldObject, Process newObject) {
    }

    @Override
    public void processPreEvents(ProjectEventSet events) throws ProjectException {
    }

    @Override
    public void processPostEvents(ProjectEventSet events) {
    }
}

