/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.AbstractDistribution;
import java.util.Random;
import oracle.bpm.project.model.simulation.DistributionType;

public class NormalDistribution
extends AbstractDistribution {
    protected long deviation = DEFAULT_DEVIATION;
    protected long mean = DEFAULT_MEAN;
    public static long DEFAULT_MEAN = 30000000L;
    public static long DEFAULT_DEVIATION = 3000000L;

    public NormalDistribution(long mean, long deviation) {
        super(DistributionType.NORMAL);
        this.setMean(mean);
        this.setDeviation(deviation);
    }

    public static AbstractDistribution create(long mean, long stDev) {
        return new NormalDistribution(mean, stDev);
    }

    public static AbstractDistribution create() {
        return NormalDistribution.create(DEFAULT_MEAN, DEFAULT_DEVIATION);
    }

    public static boolean hasNoSample(NormalDistribution distribution) {
        return distribution.getAvgValue() == Long.MAX_VALUE && distribution.getDeviation() == 0L;
    }

    @Override
    public long getAvgValue() {
        return this.getMean();
    }

    public void setDeviation(long deviation) {
        this.deviation = deviation;
    }

    @Deprecated
    public void setDeviationPercentage(String deviationPercentage) {
        this.setDeviation(Long.valueOf(deviationPercentage));
    }

    @Override
    public long getDeviation() {
        return this.deviation;
    }

    public void setMean(long mean) {
        this.mean = mean;
    }

    public void setMean(String avg) {
        this.setMean(Long.parseLong(avg));
    }

    public long getMean() {
        return this.mean;
    }

    @Override
    public long next(Random random) {
        long result = (long)(random.nextGaussian() * (double)this.getSigma() + (double)this.getMean());
        return result < 0L ? 0L : result;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (int)this.deviation;
        result = 31 * result + (int)(this.mean ^ this.mean >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NormalDistribution other = (NormalDistribution)obj;
        if (this.deviation != other.deviation) {
            return false;
        }
        return this.mean == other.mean;
    }

    private long getSigma() {
        return this.getDeviation();
    }
}

