/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.ProcessRuntimeInfoInterface;
import fuego.simulation.ResourceInfo;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.CostType;
import oracle.bpm.project.model.simulation.ParticipantSelectionPolicy;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;

public class InteractiveActivityInfo
extends ActivityInfo
implements Comparable {
    private Set sortedResources;
    static final long serialVersionUID = -7189428275941761723L;
    static final long serialCheck = -899963584213198473L;

    protected InteractiveActivityInfo(ActivityInfo parent, ActivityImpl activityImpl, int capacity) {
        super(parent, activityImpl, capacity);
        this.loadResources();
    }

    public ProcessInfo getProcessInfo() {
        return this.getProcessInfo(this.getFuegoActivity().getProcess().getId());
    }

    public ProcessInfo getProcessInfo(String processId) {
        return ((ProcessRuntimeInfoInterface)((Object)this.getRun())).getProcessRuntimeInfo(processId);
    }

    @Override
    public void remove(Token token, boolean normalTransition) {
        SimulationFlowNode simulationActivity;
        double resourceCostPerHour = 0.0;
        if (this.isUseOrgResources()) {
            ResourceInfo currentResourceInfo = token.getCurrentResource();
            token.setCurrentResource(null);
            currentResourceInfo.stopWorking(token);
            ResourceInfo resourceInfo = (ResourceInfo)this.getResourceInfo(currentResourceInfo.getName());
            resourceInfo.stopWorking(token);
            if (this.isUseResourceCost()) {
                resourceCostPerHour = resourceInfo.getResourceModel().getCost();
            }
        }
        if ((simulationActivity = this.model.findSimulationFlowNode(this.getFuegoActivity().getId())) == null) {
            simulationActivity = this.model.createSimulationFlowNode(this.getFuegoActivity().getId());
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        super.remove(token, normalTransition, resourceCostPerHour, simulationActivity.getCost());
    }

    public boolean isUseOrgResources() {
        return this.getActivityModel().getUseOrgResources();
    }

    public int compareTo(Object o) {
        return -1;
    }

    @Override
    protected boolean queueIt(Token token) {
        ResourceInfo processResourceInfo;
        if (!this.isUseOrgResources()) {
            return super.queueIt(token);
        }
        ResourceInfo resourceInfo = this.selectResource();
        if (resourceInfo != null && (processResourceInfo = (ResourceInfo)this.getProcessInfo().getResourceInfo(resourceInfo.getName())).isAvailable() && resourceInfo.isAvailable()) {
            processResourceInfo.startWorking(token);
            resourceInfo.startWorking(token);
            token.setCurrentResource(processResourceInfo);
            return false;
        }
        return true;
    }

    private SimulationFlowNodeImpl getActivityModel() {
        SimulationFlowNode simulationActivity = this.model.findSimulationFlowNode(this.getName());
        if (simulationActivity == null) {
            simulationActivity = this.model.createSimulationFlowNode(this.getName());
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return (SimulationFlowNodeImpl)simulationActivity;
    }

    private List getAvailableResources() {
        return this.getActivityModel().getAvailableResources();
    }

    private Set getSortedResources() {
        ParticipantSelectionPolicy policy = this.getActivityModel().getParticipantSelectionPolicy();
        if (this.sortedResources == null || this.sortedResources.size() != this.getResources().size() || policy == ParticipantSelectionPolicy.RANDOM) {
            this.sortedResources = new TreeSet(new ResourceComparator(policy));
            for (oracle.bpm.bamdata.ResourceInfo o : this.getResources().values()) {
                this.sortedResources.add(o);
            }
        }
        return this.sortedResources;
    }

    private boolean isUseResourceCost() {
        return this.getActivityModel().getActivityCostType() == CostType.BASE_COST_PLUS_RESOURCE_COST;
    }

    private void loadResources() {
        if (this.isUseOrgResources()) {
            for (Object o : this.getAvailableResources()) {
                SimulationResource simulationResource = (SimulationResource)o;
                ResourceInfo processResourceInfo = (ResourceInfo)this.getProcessInfo().getResourceInfo(simulationResource.getId());
                if (processResourceInfo == null) {
                    processResourceInfo = new ResourceInfo(this.getRun(), this.getProjectSimulation(), simulationResource.getId(), simulationResource.getCapacity(), simulationResource.getCost());
                    this.getProcessInfo().addResourceInfo(processResourceInfo.getName(), processResourceInfo);
                }
                ResourceInfo activityResourceInfo = new ResourceInfo(this.getRun(), this.getProjectSimulation(), simulationResource.getId(), simulationResource.getCapacity(), simulationResource.getCost());
                this.addResourceInfo(activityResourceInfo.getName(), activityResourceInfo);
            }
            ((ProcessRuntimeInfoInterface)((Object)this.getRun())).addInteractiveActivity(this);
        }
    }

    private ResourceInfo selectResource() {
        ResourceInfo selectedResource = null;
        for (Object o : this.getSortedResources()) {
            ResourceInfo resourceInfo = (ResourceInfo)o;
            ResourceInfo processResourceInfo = (ResourceInfo)this.getProcessInfo().getResourceInfo(resourceInfo.getName());
            if (!processResourceInfo.isAvailable()) continue;
            selectedResource = resourceInfo;
            break;
        }
        return selectedResource;
    }

    private static class ResourceComparator
    implements Comparator {
        private ParticipantSelectionPolicy policy;
        static final Random random = new Random();

        ResourceComparator(ParticipantSelectionPolicy policy) {
            this.policy = policy;
        }

        public int compare(Object o1, Object o2) {
            SimulationResource model2;
            ResourceInfo resource1 = (ResourceInfo)o1;
            ResourceInfo resource2 = (ResourceInfo)o2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            SimulationResource model1 = resource1.getResourceModel();
            if (model1 == (model2 = resource2.getResourceModel())) {
                return 0;
            }
            if (model1 == null) {
                return -1;
            }
            if (model2 == null) {
                return 1;
            }
            if (this.policy == ParticipantSelectionPolicy.MINIMUM_COST) {
                double cost2 = model2.getCost();
                double cost1 = model1.getCost();
                return cost1 > cost2 ? 1 : -1;
            }
            if (this.policy == ParticipantSelectionPolicy.MAXIMUM_EFFICIENCY) {
                double efficiency1 = model1.getEfficiency();
                double efficiency2 = model2.getEfficiency();
                return efficiency2 > efficiency1 ? 1 : -1;
            }
            int res = 1 - random.nextInt(2);
            return res == 0 ? -1 : res;
        }
    }
}

