/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.Event;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.Random;
import oracle.bpm.collections.PriorityQueue;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;

public class GroupEndSimulationActivityImpl
extends SimulationFlowNodeImpl {
    protected GroupEndSimulationActivityImpl(FlowNode node) {
        super(node);
    }

    @Override
    public void scheduleMove(long eventTime, long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        token.remove();
        Token parent = token.getParent();
        assert (parent != null) : "An instance has arrived to the End of a Group without a Parent!";
        assert (parent.getChildren() == 0) : "Token '" + token.getId() + "'must have no child";
        SequenceFlow transition = this.chooseTransition(currentTime, parent, random);
        Event event = Event.createMoveEvent(parent, currentTime, this.getParentGroup(), transition.getTarget(), transition);
        eventQueue.offer((Object)event);
    }

    @Override
    public void scheduleTerminate(long currentTime, Token token, PriorityQueue<Event> eventQueue, Random random) {
        assert (ModelUtils.isEndEvent(this.getFlowNode())) : "Cannot schedule for termination because activity '" + this.getId() + "' is not the End!";
        Token parent = token.getParent();
        if (parent == null) {
            super.scheduleTerminate(currentTime, token, eventQueue, random);
        } else if (this.isIpcChild(token)) {
            super.scheduleTerminate(currentTime, token, eventQueue, random);
            token.remove();
            assert (parent.getChildren() == 0) : "Token '" + token.getId() + "'must have no child";
            SequenceFlow transition = token.getParent().getCurrentActivity().chooseTransition(currentTime, token.getParent(), random);
            Event event = Event.createImmediateMoveEvent(token.getParent(), currentTime, transition.getSource(), transition.getTarget(), transition);
            eventQueue.offer((Object)event);
        } else {
            SequenceFlow transition = this.getDynamicTransition(this.getFlowNode().getId());
            Event event = Event.createImmediateMoveEvent(token.getParent(), currentTime, this.getParentGroup(), this.getFlowNode(), transition, false);
            eventQueue.offer((Object)event);
        }
    }

    private boolean isIpcChild(Token token) {
        return token.getModel() != token.getParent().getModel();
    }
}

