/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.Token;
import oracle.bpm.lang.Time;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.msg.ProjectMsg;

public class Event
implements Comparable {
    private boolean canBeLogged;
    private long dueTime;
    private FlowNode from;
    private long id;
    private int step;
    private FlowNode to;
    private Token token;
    private SequenceFlow transition;
    private int type;
    public static final int GENERATE = 1;
    public static final int MOVE = 2;
    public static final int TERMINATE = 3;
    public static final int STOP = 4;
    public static final int END = 5;
    public static final int IMMEDIATE_MOVE = 6;
    public static final int GENERATE_IPC = 7;
    private static long nextId;

    private Event(Token id, long dueTime, int type, boolean canBeLogged) {
        this.token = id;
        this.dueTime = dueTime;
        this.type = type;
        this.id = nextId++;
        this.canBeLogged = canBeLogged;
    }

    public static Event createGenerateEvent(long ms, int category, ProjectSimulation projectSimulation, ModelSimulation simulationModel, ActivityInfo processInfo) {
        return new Event(Token.create(ms, category, projectSimulation, simulationModel, processInfo), ms, 1, true);
    }

    public static Event createGenerateEvent(long ms, int category, ProjectSimulation projectSimulation, ModelSimulation simulationModel, ActivityInfo processInfo, FlowNode from) {
        Event event = new Event(Token.create(ms, category, projectSimulation, simulationModel, processInfo), ms, 1, true);
        event.from = from;
        return event;
    }

    public static Event createGenerateIPCEvent(long ms, int category, Token parent, ProjectSimulation projectSimulation, ModelSimulation model, ActivityInfo processInfo) {
        return new Event(Token.create(parent, ms, category, projectSimulation, model, processInfo), ms, 7, true);
    }

    public static Event createImmediateMoveEvent(Token token, long ms, FlowNode from, FlowNode to, SequenceFlow transition) {
        return Event.createImmediateMoveEvent(token, ms, from, to, transition, true);
    }

    public static Event createImmediateMoveEvent(Token token, long ms, FlowNode from, FlowNode to, SequenceFlow transition, boolean canBeLogged) {
        Event event = new Event(token, ms, 6, canBeLogged);
        event.from = from;
        event.to = to;
        event.step = 0;
        event.transition = transition;
        return event;
    }

    public static Event createMoveEvent(Token token, long ms, FlowNode from, FlowNode to, SequenceFlow transition) {
        return Event.createMoveEvent(token, ms, from, to, transition, true);
    }

    public static Event createMoveEvent(Token token, long ms, FlowNode from, FlowNode to, SequenceFlow transition, boolean canBeLogged) {
        Event event = new Event(token, ms, 2, canBeLogged);
        event.from = from;
        event.to = to;
        event.step = 0;
        event.transition = transition;
        return event;
    }

    public static Event createMoveStep(Event event, int stepIncrement) {
        Event result = Event.createMoveEvent(event.getToken(), event.getDueTime(), event.getFrom(), event.getTo(), event.getTransition(), event.canBeLogged());
        result.step = event.getStep() + stepIncrement;
        if (result.step > 100) {
            result.step = 100;
        }
        return result;
    }

    public static Event createEnd(long currentTime) {
        return new Event(null, currentTime, 5, true);
    }

    public static Event createStop(long ms) {
        return new Event(null, ms, 4, true);
    }

    public static Event createTerminateEvent(Token token, long ms, FlowNode from) {
        Event event = new Event(token, ms, 3, true);
        event.from = from;
        return event;
    }

    public boolean canBeLogged() {
        return this.canBeLogged;
    }

    public void setDueTime(long dueTime) {
        this.dueTime = dueTime;
    }

    public long getDueTime() {
        return this.dueTime;
    }

    public boolean isFirstStep() {
        return this.step == 0;
    }

    public FlowNode getFrom() {
        return this.from;
    }

    public boolean isLastStep() {
        return this.step >= 100 || this.type == 6;
    }

    public int getStep() {
        return this.step;
    }

    public FlowNode getTo() {
        return this.to;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public SequenceFlow getTransition() {
        return this.transition;
    }

    public int getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        Event that = (Event)o;
        if (this == that) {
            return 0;
        }
        return this.dueTime > that.dueTime ? -1 : (this.dueTime < that.dueTime ? 1 : (this.step > that.step ? -1 : (this.step < that.step ? 1 : (this.id > that.id ? -1 : (this.id < that.id ? 1 : 0)))));
    }

    public String toString() {
        String result = Time.valueOf((long)this.dueTime).format() + ": ";
        if (this.token != null) {
            result = result + this.getToken().getModel().getProcess() + ": " + ProjectMsg.INSTANCE + this.token + " ";
        }
        switch (this.getType()) {
            case 1: {
                return result + ProjectMsg.GENERATED;
            }
            case 3: {
                return result + ProjectMsg.TERMINATED;
            }
            case 2: 
            case 6: {
                return result + ProjectCompileMsg.MOVED_FROM_TO((String)this.getFrom().getDefaultLabel(), (String)this.getTo().getDefaultLabel());
            }
            case 4: {
                return result + ProjectMsg.STOP;
            }
            case 5: {
                return result + ProjectMsg.END;
            }
        }
        return "";
    }
}

