/*
 * Decompiled with CFR 0.152.
 */
package fuego.simulation;

import fuego.simulation.BeginActivityInfo;
import fuego.simulation.EndActivityInfo;
import fuego.simulation.GroupActivityInfo;
import fuego.simulation.InteractiveActivityInfo;
import fuego.simulation.JoinActivityInfo;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.SplitActivityInfo;
import fuego.simulation.SubflowActivityInfo;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.bpm.bamdata.BAMActivityInfo;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.bamdata.RunningInfo;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.util.ModelUtils;

public class ActivityInfo
extends ProcessInfo {
    protected ModelSimulation model;
    protected transient LinkedList<Token> queue;
    private ActivityImpl activityImpl;
    private int capacity;
    private ProjectSimulation projectSimulation;
    static final long serialVersionUID = -6768646867305121783L;
    static final long serialCheck = -100485553488069693L;

    protected ActivityInfo(ActivityInfo parent, ActivityImpl activityImpl, int capacity) {
        super(parent, activityImpl.getId());
        this.queue = new LinkedList();
        this.capacity = capacity;
        this.model = parent.model;
        this.activityImpl = activityImpl;
        this.projectSimulation = parent.getProjectSimulation();
        this.initCost();
    }

    protected ActivityInfo(Run run, ProjectSimulation projectSimulation, ModelSimulation model, String processName, String[] categories) {
        super(run, processName, categories);
        this.projectSimulation = projectSimulation;
        this.model = model;
    }

    public static oracle.bpm.bamdata.ActivityInfo create(ActivityInfo parent, int capacity, ActivityImpl activityImpl) {
        ActivityInfo info = ModelUtils.isAnySplit(activityImpl) ? new SplitActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isAnyJoin(activityImpl) ? new JoinActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isStartEvent(activityImpl) ? new BeginActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isEndEvent(activityImpl) ? new EndActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isSubprocess(activityImpl) ? new GroupActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isAnyInteractive(activityImpl) ? new InteractiveActivityInfo(parent, activityImpl, capacity) : (ModelUtils.isCallActivity(activityImpl) ? new SubflowActivityInfo(parent, activityImpl, capacity) : new ActivityInfo(parent, activityImpl, capacity)))))));
        return info;
    }

    public static ActivityInfo create(Run run, ProjectSimulation projectSimulationModel, ModelSimulation model, String name, String[] categories) {
        return new ActivityInfo(run, projectSimulationModel, model, name, categories);
    }

    public ProjectSimulation getProjectSimulation() {
        return this.projectSimulation;
    }

    public ActivityImpl getFuegoActivity() {
        return this.activityImpl;
    }

    @Override
    public BAMActivityInfo getActivity(String activityName) {
        BAMActivityInfo info = super.getActivity(activityName);
        SimulationFlowNode simulationActivity = this.model.findSimulationFlowNode(activityName);
        if (simulationActivity == null) {
            simulationActivity = this.model.createSimulationFlowNode(activityName);
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        int capacity = Integer.MAX_VALUE;
        if (simulationActivity instanceof SimulationFlowNodeImpl) {
            capacity = simulationActivity.getCapacity();
        }
        if (info == null) {
            info = ActivityInfo.create(this, capacity, (ActivityImpl)simulationActivity.getFlowNode());
        }
        return info;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public List<Token> activate() {
        ArrayList<Token> result = new ArrayList<Token>();
        long currTime = this.getRun().getCurrentTime();
        while (!this.queue.isEmpty() && !this.queueIt(this.queue.getFirst())) {
            Token token = this.queue.removeFirst();
            result.add(token);
            token.setActivationTime(currTime);
            token.setCurrentActivityInfo(this);
            long waitTime = this.followsDueTransition(token) ? 0L : currTime - token.getArrivalTime();
            this.getRunningInfoImpl().activateInstance(currTime, waitTime);
            RunningInfo categoryInfo = this.getCategoryRunningInfo(token.getCategory());
            if (categoryInfo == null) continue;
            categoryInfo.activateInstance(currTime, waitTime);
        }
        return result;
    }

    public boolean queue(Token token) {
        long currTime = this.getRun().getCurrentTime();
        boolean queueIt = this.queueIt(token);
        if (queueIt) {
            this.queue.addLast(token);
        } else {
            token.setActivationTime(currTime);
        }
        token.setArrivalTime(currTime);
        this.getRunningInfoImpl().addInstance(currTime, queueIt);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(token.getCategory());
        if (categoryInfo != null) {
            categoryInfo.addInstance(currTime, queueIt);
        }
        return queueIt;
    }

    public void remove(Token token) {
        this.remove(token, true);
    }

    public void remove(Token token, boolean normalTransition) {
        SimulationFlowNode simulationActivity = this.model.findSimulationFlowNode(this.getFuegoActivity().getId());
        if (simulationActivity == null) {
            simulationActivity = this.model.createSimulationFlowNode(this.getFuegoActivity().getId());
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        this.remove(token, normalTransition, 0.0, simulationActivity.getCost());
    }

    public void remove(Token token, boolean normalTransition, double resourceCostPerHour, double unitCost) {
        long currTime = this.getRun().getCurrentTime();
        long cycleTime = currTime - token.getArrivalTime();
        long workTime = currTime - token.getActivationTime();
        this.getRunningInfoImpl().removeInstance(currTime, workTime, cycleTime, resourceCostPerHour, unitCost);
        RunningInfo categoryInfo = this.getCategoryRunningInfo(token.getCategory());
        if (categoryInfo != null) {
            categoryInfo.removeInstance(currTime, workTime, cycleTime, resourceCostPerHour, unitCost);
        }
        if (normalTransition) {
            token.addTrace(this.getName());
        }
    }

    protected boolean isACopy(Token token) {
        return token.getParent() != null && token.getChildren() == 0;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    protected int getCurrentWorkCount() {
        return this.getRunningInfo().getCurrentWorkCount();
    }

    protected void initCost() {
        SimulationFlowNode simulationActivity = this.model.findSimulationFlowNode(this.getName());
        if (simulationActivity == null) {
            simulationActivity = this.model.createSimulationFlowNode(this.getName());
            try {
                this.model.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        if (simulationActivity instanceof SimulationFlowNodeImpl) {
            this.setUnitCost(((SimulationFlowNodeImpl)simulationActivity).getCost());
        }
    }

    protected boolean queueIt(Token token) {
        return !this.followsDueTransition(token) && this.getCurrentWorkCount() >= this.getCapacity();
    }

    private boolean followsDueTransition(Token token) {
        ModelSimulation modelSimulation = token.getModel();
        SimulationFlowNode simulationActivity = modelSimulation.findSimulationFlowNode(this.getName());
        if (simulationActivity == null) {
            simulationActivity = modelSimulation.createSimulationFlowNode(this.getName());
            try {
                modelSimulation.addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        if (simulationActivity instanceof SimulationFlowNodeImpl) {
            SimulationFlowNodeImpl simulationActivityImpl = (SimulationFlowNodeImpl)simulationActivity;
            long eventTime = simulationActivityImpl.getNextIPT(token, this.getRun().getCurrentTime(), ((Simulation)this.getRun()).getRandom());
            if (simulationActivityImpl.chooseDueTransition(this.getRun().getCurrentTime(), eventTime - this.getRun().getCurrentTime()) != null) {
                return true;
            }
        }
        return false;
    }
}

