/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util.ant;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntExecutor {
    private File antDirectory;
    public static final String ANT_EXECUTOR = "oracle.bpm.pml.service.util.ant.TaskInvoker";
    private static final String LIB_DIR = "lib";
    private static ClassLoader antExecutorClassloader;

    public AntExecutor(@NotNull File antDirectory) {
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/ant/AntExecutor.<init> must not be null");
        }
        this.antDirectory = antDirectory;
    }

    public void invoke(@NotNull File antFile, @NotNull String target, @Nullable Map<String, String> args) throws Exception {
        if (antFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/ant/AntExecutor.invoke must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/ant/AntExecutor.invoke must not be null");
        }
        ClassLoader classloader = this.getAntExecutorClassloader();
        Class<?> aClass = classloader.loadClass(ANT_EXECUTOR);
        Method method = aClass.getMethod("doInvoke", File.class, String.class, Map.class);
        method.invoke(null, antFile, target, args);
    }

    private ClassLoader getAntExecutorClassloader() throws MalformedURLException {
        if (antExecutorClassloader == null) {
            URL executorLib = AntExecutor.class.getProtectionDomain().getCodeSource().getLocation();
            URL antLauncherLib = new File(this.antDirectory, File.separator + LIB_DIR + File.separator + "ant-launcher.jar").toURI().toURL();
            URL antNodepsLib = new File(this.antDirectory, File.separator + LIB_DIR + File.separator + "ant-nodeps.jar").toURI().toURL();
            URL antLib = new File(this.antDirectory, File.separator + LIB_DIR + File.separator + "ant.jar").toURI().toURL();
            antExecutorClassloader = new URLClassLoader(new URL[]{executorLib, antLib, antLauncherLib, antNodepsLib}, null);
        }
        return antExecutorClassloader;
    }
}

