/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.util;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.artifact.jaxb.ProjectType;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.exception.InvalidNamespaceException;
import org.jetbrains.annotations.NotNull;

public final class MdsUrlResolver {
    public static <T extends MdProject> URL getResourceUrl(@NotNull T project, @NotNull VFile resourceLocation) throws MetadataException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/util/MdsUrlResolver.getResourceUrl must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/util/MdsUrlResolver.getResourceUrl must not be null");
        }
        LocalRef folderRef = (LocalRef)Cast.force(project.getFolder());
        ProjectFolder folder = (ProjectFolder)folderRef.get();
        try {
            ProjectType projectType = MetadataArtifactHelper.getProjectType(project.getClass());
            String path = MetadataArtifactHelper.getRelativePathFrom(projectType);
            return new URL("oramds:/" + path + folder.getLocation() + resourceLocation.getCanonicalPath());
        }
        catch (InvalidNamespaceException e) {
            throw PersistenceException.createInvalidPathException(folder.getLocation(), e);
        }
        catch (MalformedURLException e) {
            throw PersistenceException.createInvalidPathException(folder.getLocation(), e);
        }
    }
}

