/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.service.security.Privilege;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public enum AbstractRole implements Serializable
{
    ADMIN_ANY_PROJECT("BPMComposerAdmin", MetadataMsg.ADMIN_ANY_PROJECT, Privilege.ALTER_PRIVILEGE, Privilege.CREATE_DRAFT, Privilege.SAVE_DRAFT, Privilege.COMMIT_DRAFT, Privilege.DELETE_DRAFT, Privilege.UPDATE_PUBLIC_SHARE, Privilege.DELETE_PUBLIC_SHARE, Privilege.APPLY_PATCH, Privilege.DEPLOY_PROJECT, Privilege.GET_WORKFLOW_PROJECT, Privilege.RELEASE_WORKFLOW_PROJECT, Privilege.GENERATE_SAR, Privilege.GET_PUBLIC_SHARE_LOCK, Privilege.RELEASE_PUBLIC_SHARE_LOCK, Privilege.ASSIGN_PUBLIC_SHARE_LOCK, Privilege.VIEW_PROJECT, Privilege.ADD_DOCUMENTATION, Privilege.IMPLEMENT_PROJECT, Privilege.CREATE_PROCESS, Privilege.UPDATE_PROCESS, Privilege.CREATE_PROJECT_FROM_TEMPLATE, Privilege.CREATE_PROJECT_FROM_SCRATCH, Privilege.MANAGE_FOLDER),
    DEVELOP_ANY_PROJECT("BPMComposerDeveloper", MetadataMsg.DEVELOP_ANY_PROJECT, Privilege.GET_PUBLIC_SHARE_LOCK, Privilege.CREATE_DRAFT, Privilege.RELEASE_PUBLIC_SHARE_LOCK, Privilege.DELETE_DRAFT, Privilege.SAVE_DRAFT, Privilege.COMMIT_DRAFT, Privilege.IMPLEMENT_PROJECT, Privilege.CREATE_PROCESS, Privilege.UPDATE_PROCESS, Privilege.MANAGE_FOLDER, Privilege.VIEW_PROJECT),
    DESIGN_ANY_PROJECT("BPMComposerDesigner", MetadataMsg.DESIGN_ANY_PROJECT, Privilege.GET_PUBLIC_SHARE_LOCK, Privilege.CREATE_DRAFT, Privilege.RELEASE_PUBLIC_SHARE_LOCK, Privilege.DELETE_DRAFT, Privilege.SAVE_DRAFT, Privilege.COMMIT_DRAFT, Privilege.CREATE_PROCESS, Privilege.UPDATE_PROCESS, Privilege.VIEW_PROJECT),
    DEPLOY_ANY_PROJECT("BPMComposerDeployer", MetadataMsg.DEPLOY_ANY_PROJECT, Privilege.VIEW_PROJECT, Privilege.DEPLOY_PROJECT, Privilege.GET_WORKFLOW_PROJECT, Privilege.GENERATE_SAR),
    CREATE_NEW_PROJECT("BPMComposerCreateNewProject", MetadataMsg.CREATE_NEW_PROJECT, Privilege.VIEW_PROJECT, Privilege.CREATE_PROJECT_FROM_TEMPLATE, Privilege.CREATE_PROJECT_FROM_SCRATCH),
    CREATE_PROJECT_FROM_TEMPLATE("BPMComposerCreateProjectFromTemplate", MetadataMsg.CREATE_PROJECT_FROM_TEMPLATE, Privilege.VIEW_PROJECT, Privilege.CREATE_PROJECT_FROM_TEMPLATE),
    VIEW_ANY_PROJECT("BPMComposerViewProject", MetadataMsg.VIEW_ANY_PROJECT, Privilege.VIEW_PROJECT, Privilege.GENERATE_SAR),
    DOCUMENT_ANY_PROJECT("BPMComposerDocumentProject", MetadataMsg.DOCUMENT_ANY_PROJECT, Privilege.ADD_DOCUMENTATION, Privilege.CREATE_DRAFT, Privilege.RELEASE_PUBLIC_SHARE_LOCK, Privilege.DELETE_DRAFT, Privilege.SAVE_DRAFT, Privilege.COMMIT_DRAFT, Privilege.GET_PUBLIC_SHARE_LOCK, Privilege.VIEW_PROJECT),
    SOA_DESIGNER("SOADesigner", MetadataMsg.SOA_DESIGNER, new Privilege[0]);

    private EnumSet<Privilege> privileges;
    private Msg label;
    private String id;

    private AbstractRole(@NotNull String id, Msg label, Privilege ... grantedPrivileges) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/security/AbstractRole.<init> must not be null");
        }
        if (label == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/security/AbstractRole.<init> must not be null");
        }
        if (grantedPrivileges == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/security/AbstractRole.<init> must not be null");
        }
        this.id = id;
        this.label = label;
        this.privileges = EnumSet.noneOf(Privilege.class);
        this.privileges.addAll(Arrays.asList(grantedPrivileges));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Msg getLabel() {
        Msg msg = this.label;
        if (msg == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/security/AbstractRole.getLabel must not return null");
        }
        return msg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/pml/service/security/AbstractRole.getId must not return null");
        }
        return string;
    }

    public EnumSet<Privilege> getGrantedPrivileges() {
        return this.privileges;
    }

    public static AbstractRole valueOfId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/AbstractRole.valueOfId must not be null");
        }
        AbstractRole result = null;
        for (AbstractRole role : AbstractRole.values()) {
            if (!id.equals(role.id)) continue;
            result = role;
            break;
        }
        return result;
    }

    public static AbstractRole valueOfLabel(@NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/security/AbstractRole.valueOfLabel must not be null");
        }
        AbstractRole result = null;
        for (AbstractRole role : AbstractRole.values()) {
            if (!label.equals(role.label.getString())) continue;
            result = role;
            break;
        }
        return result;
    }
}

