/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.IOException;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.artifact.jaxb.ObjectFactory;
import oracle.bpm.metadata.artifact.jaxb.PublicShareMetadata;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.MetadataExceptionFactory;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.metadata.impl.MetadataArtifactBuilder;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.pml.service.StudioMetadataService;
import oracle.bpm.pml.service.impl.BaseMetadataService;
import oracle.bpm.project.model.ProjectLoader;
import oracle.mds.core.MDSInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioMetadataServiceImpl
extends BaseMetadataService
implements StudioMetadataService {
    public StudioMetadataServiceImpl(@NotNull MDSInstance instance) throws MetadataException {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.<init> must not be null");
        }
        super(instance);
    }

    @Override
    public <K extends ProjectArtifact> MdTree getTemplates(@Nullable Predicate<TemplateProject> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        return this.mdDomain.browseProject(TemplateProject.class, predicate, parent);
    }

    @Override
    public <K extends ProjectArtifact> MdTree getPublicShares(@Nullable Predicate<PublicShareProject> predicate, @Nullable LocalRef<K> parent) throws MetadataException {
        return this.mdDomain.browseProject(PublicShareProject.class, predicate, parent);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> type, @NotNull String fullProjectPath) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        if (fullProjectPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.loadProject must not be null");
        }
        return this.mdDomain.loadProject(type, fullProjectPath, false);
    }

    @Override
    public void deleteTemplateProject(@NotNull ProjectFolder projetFolder) throws MetadataException {
        if (projetFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteTemplateProject must not be null");
        }
        this.mdDomain.removeProject(TemplateProject.class, projetFolder);
    }

    @Override
    public void deletePublicShare(@NotNull ProjectFolder projetFolder) throws MetadataException {
        if (projetFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deletePublicShare must not be null");
        }
        this.mdDomain.removePublicShare(projetFolder);
    }

    @Override
    public TemplateProject saveTemplateProject(@NotNull ProjectFolder location, @NotNull TemplateProject template, boolean overwrite, boolean checkVersion) throws MetadataException {
        TemplateProject result;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.saveTemplateProject must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.saveTemplateProject must not be null");
        }
        template.setOwner("BPM Studio");
        ProjectLoader loader = template.getProject().get().getLoader();
        if (loader != null) {
            VFileSystem filesystem = loader.getProjectFileSystem().getDataFileSystem();
            MetadataType localMetadata = MetadataArtifactHelper.getMetadataArtifact(filesystem, TemplateProject.class, "/");
            if (localMetadata != null) {
                template.setUpdateTimestamp(localMetadata.getUpdateTimestamp());
            }
            result = this.mdDomain.createTemplateProject(location, template, overwrite, checkVersion);
            try {
                ObjectFactory objectFactory = new ObjectFactory();
                MetadataType savedMetadata = MetadataArtifactBuilder.create(result, location.getLocation());
                VFile file = filesystem.createFile("projectMetadata.xml");
                MetadataArtifactHelper.serialize(objectFactory.createMetadata(savedMetadata), file);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
        } else {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        return result;
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.createFolder must not be null");
        }
        this.mdDomain.createFolder(type, folder);
    }

    @Override
    public <T extends MdProject> void deleteFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.deleteFolder must not be null");
        }
        this.mdDomain.removeFolder(type, folder, recursive);
    }

    @Override
    public PublicShareProject savePublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShare, boolean overwrite, boolean checkVersion) throws MetadataException {
        PublicShareProject result;
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.savePublicShare must not be null");
        }
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.savePublicShare must not be null");
        }
        publicShare.setOwner("BPM Studio");
        ProjectLoader loader = publicShare.getProject().get().getLoader();
        if (loader != null) {
            VFileSystem filesystem = loader.getProjectFileSystem().getDataFileSystem();
            MetadataType localMetadata = MetadataArtifactHelper.getMetadataArtifact(filesystem, PublicShareProject.class, "/");
            if (localMetadata != null) {
                publicShare.setUpdateTimestamp(localMetadata.getUpdateTimestamp());
            }
            result = this.mdDomain.createPublicShare(location, publicShare, overwrite, checkVersion);
            try {
                ObjectFactory objectFactory = new ObjectFactory();
                PublicShareMetadata savedMetadata = MetadataArtifactBuilder.create(result, location.getLocation());
                VFile file = filesystem.createFile("projectMetadata.xml");
                MetadataArtifactHelper.serialize(objectFactory.createMetadata(savedMetadata), file);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
        } else {
            throw MetadataExceptionFactory.createInvalidProjectException();
        }
        return result;
    }

    @Override
    public <T extends MdProject> boolean existsProject(@NotNull Class<T> type, @NotNull ProjectFolder location) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsProject must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.existsProject must not be null");
        }
        return this.mdDomain.existsProject(type, location);
    }

    @Override
    public boolean isPublicShareUpToDate(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.isPublicShareUpToDate must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.isPublicShareUpToDate must not be null");
        }
        boolean result = false;
        try {
            result = this.mdDomain.isPublicShareUpToDate(location, publicShareProject);
        }
        catch (ProjectNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProjec) throws MetadataException {
        if (publicShareProjec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.releaseLock must not be null");
        }
        this.mdDomain.releaseLock(publicShareProjec);
    }

    @Override
    public void acquireLock(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.acquireLock must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/StudioMetadataServiceImpl.acquireLock must not be null");
        }
        this.mdDomain.assignLock(publicShareProject, username, true);
    }
}

