/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.MdTree;
import oracle.bpm.metadata.entity.DeployedProject;
import oracle.bpm.metadata.entity.DraftProject;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.ProjectToDeploy;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MdDomainImpl;
import oracle.bpm.metadata.mds.MdsInstanceInitializer;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.service.ComposerMetadataService;
import oracle.bpm.pml.service.deployment.DeploymentHelper;
import oracle.bpm.pml.service.deployment.DeploymentResult;
import oracle.bpm.pml.service.impl.BaseMetadataService;
import oracle.bpm.pml.service.security.Privilege;
import oracle.bpm.pml.service.security.SecurityContext;
import oracle.bpm.pml.service.util.DeployedProjectHelper;
import oracle.fabric.composite.CompositeDN;
import oracle.mds.core.MDSInstance;
import oracle.mds.exception.MDSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerMetadataServiceImpl
extends BaseMetadataService
implements ComposerMetadataService {
    private DeployedProjectHelper deployedProjectHelper;
    private DeploymentHelper deploymentHelper;
    private SecurityContext securityContext;

    public ComposerMetadataServiceImpl(@NotNull URL composerMdsConfig, @Nullable URL soainfraMdsConfig, @NotNull SecurityContext securityContext, @Nullable DeploymentHelper deploymentHelper) throws MetadataException, MalformedURLException, MDSException {
        if (composerMdsConfig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (securityContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        super(composerMdsConfig);
        this.deployedProjectHelper = null;
        if (soainfraMdsConfig != null) {
            MDSInstance mdsInstance = MdsInstanceInitializer.getMDSInstance("SOAINFRA_MDS", soainfraMdsConfig);
            MdDomainImpl soainfraMdDomain = new MdDomainImpl(mdsInstance);
            this.deployedProjectHelper = new DeployedProjectHelper(soainfraMdDomain, mdsInstance);
        }
        this.securityContext = securityContext;
        this.deploymentHelper = deploymentHelper;
    }

    public ComposerMetadataServiceImpl(@NotNull MDSInstance composerMdsInstance, @NotNull SecurityContext securityContext, @Nullable DeploymentHelper deploymentHelper, @Nullable MDSInstance soainfraMdsInstance) throws MetadataException {
        if (composerMdsInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        if (securityContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.<init> must not be null");
        }
        super(composerMdsInstance);
        this.deployedProjectHelper = null;
        if (soainfraMdsInstance != null) {
            MdDomainImpl soainfraMdDomain = new MdDomainImpl(soainfraMdsInstance);
            this.deployedProjectHelper = new DeployedProjectHelper(soainfraMdDomain, soainfraMdsInstance);
        }
        this.securityContext = securityContext;
        this.deploymentHelper = deploymentHelper;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public <K extends MdProject> MdTree browse(@NotNull Class<K> type, Predicate<K> predicate) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.browse must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.VIEW_PROJECT);
        return this.mdDomain.browseProject(type, predicate, null);
    }

    @Override
    public <T extends MdProject> LocalRef<T> loadProject(@NotNull Class<T> type, @NotNull String projectFolder, boolean reload) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProject must not be null");
        }
        if (projectFolder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProject must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.VIEW_PROJECT);
        if (reload) {
            this.mdDomain.releaseFromCache(type, projectFolder);
        }
        return this.mdDomain.loadProject(type, projectFolder, false);
    }

    @Override
    public LocalRef<DraftProject> loadDraft(@NotNull String projectName, boolean reload) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadDraft must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.VIEW_PROJECT);
        if (reload) {
            String draftLocation = projectName + "/" + this.securityContext.getPrincipal();
            this.mdDomain.releaseFromCache(DraftProject.class, draftLocation);
        }
        return this.mdDomain.loadDraftProject(projectName, this.securityContext.getPrincipal());
    }

    @Override
    public LocalRef<ProjectToDeploy> loadProjectPendingForDeploy(@NotNull String projectName, @NotNull String workflowTicket) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProjectPendingForDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.loadProjectPendingForDeploy must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.GET_WORKFLOW_PROJECT);
        StringBuilder id = new StringBuilder("/");
        id.append(projectName).append("/").append(workflowTicket);
        return this.mdDomain.loadProject(ProjectToDeploy.class, id.toString(), false);
    }

    @Override
    public PublicShareProject createPublicShare(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, @NotNull TemplateProject templateProject, boolean overwrite) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        if (templateProject == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createPublicShare must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.CREATE_PROJECT_FROM_TEMPLATE);
        publicShareProject.setOwner(this.securityContext.getPrincipal());
        return this.mdDomain.createPublicShare(location, publicShareProject, templateProject, overwrite, false);
    }

    @Override
    public PublicShareProject createProjectFromScratch(@NotNull ProjectFolder location, @NotNull PublicShareProject publicShareProject, boolean overwrite) throws MetadataException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createProjectFromScratch must not be null");
        }
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createProjectFromScratch must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.CREATE_PROJECT_FROM_SCRATCH);
        publicShareProject.setProjectFromScratch(true);
        publicShareProject.setOwner(this.securityContext.getPrincipal());
        return this.mdDomain.createPublicShare(location, publicShareProject, overwrite, false);
    }

    @Override
    public DraftProject createDraft(@NotNull PublicShareProject project) throws MetadataException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createDraft must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.CREATE_DRAFT);
        return this.mdDomain.createDraftProject(project, this.securityContext.getPrincipal());
    }

    @Override
    public void releaseDraft(@NotNull DraftProject draft) throws MetadataException {
        if (draft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseDraft must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.DELETE_DRAFT);
        this.mdDomain.removeDraft(draft.getFolder().get().getLocation());
    }

    @Override
    public void deletePublicShare(@NotNull PublicShareProject publicShareProject) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deletePublicShare must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.DELETE_PUBLIC_SHARE);
        this.mdDomain.removePublicShare(publicShareProject.getFolder().get());
    }

    @Override
    public void updateDraft(@NotNull DraftProject draftProject) throws MetadataException {
        if (draftProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updateDraft must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.SAVE_DRAFT);
        this.mdDomain.updateDraft(draftProject);
    }

    @Override
    public void commitDraft(@NotNull DraftProject draft) throws MetadataException {
        if (draft == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.commitDraft must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.COMMIT_DRAFT);
        this.mdDomain.commitChanges(draft.getFolder().get().getLocation());
    }

    @Override
    public <T extends MdProject> void createFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.createFolder must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.MANAGE_FOLDER);
        this.mdDomain.createFolder(type, folder);
    }

    @Override
    public <T extends MdProject> void deleteFolder(@NotNull Class<T> type, @NotNull ProjectFolder folder, boolean recursive) throws MetadataException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteFolder must not be null");
        }
        if (folder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deleteFolder must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.MANAGE_FOLDER);
        this.mdDomain.removeFolder(type, folder, recursive);
    }

    @Override
    public void releaseProjectPendingForDeploy(@NotNull ProjectToDeploy projectToDeploy) throws MetadataException {
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseProjectPendingForDeploy must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.RELEASE_WORKFLOW_PROJECT);
        ProjectFolder folder = ProjectFolder.create(projectToDeploy.getId());
        this.mdDomain.removeProject(ProjectToDeploy.class, folder);
    }

    @Override
    public MdTree getProjectsPendingForDeploy(@Nullable Predicate<ProjectToDeploy> predicate) throws MetadataException {
        this.securityContext.assertPrivilege(Privilege.GET_WORKFLOW_PROJECT);
        return this.mdDomain.browseProject(ProjectToDeploy.class, predicate, null);
    }

    @Override
    public void prepareProjectToDeploy(@NotNull PublicShareProject publicShare, @NotNull String workflowTicket) throws MetadataException {
        if (publicShare == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.prepareProjectToDeploy must not be null");
        }
        if (workflowTicket == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.prepareProjectToDeploy must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.DEPLOY_PROJECT);
        this.mdDomain.prepareProjectToDeploy(publicShare, workflowTicket);
    }

    @Override
    public DeploymentResult deployProject(@NotNull URL host, @NotNull String username, @NotNull String password, boolean overwrite, boolean useDefaultVersion, @NotNull ProjectToDeploy project) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.deployProject must not be null");
        }
        try {
            this.securityContext.assertPrivilege(Privilege.DEPLOY_PROJECT);
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.deploy(host, username, password, project, project.getVersion(), overwrite, useDefaultVersion, null, null);
    }

    @Override
    public DeploymentResult generateSarFile(@NotNull PublicShareProject project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.generateSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.generateSarFile must not be null");
        }
        try {
            this.securityContext.assertPrivilege(Privilege.GENERATE_SAR);
            this.checkDeploymentHelper();
        }
        catch (MetadataException e) {
            return new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, e.getKey());
        }
        return this.deploymentHelper.generateSarFile(project, version);
    }

    @Override
    public InputStream getSarFile(@NotNull MdProject project, @NotNull String version) throws MetadataException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getSarFile must not be null");
        }
        File sarFile = this.deploymentHelper.getSarFile(project, version);
        try {
            return new BufferedInputStream(new FileInputStream(sarFile));
        }
        catch (FileNotFoundException e) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_FAILED);
        }
    }

    @Override
    public Collection<LocalRef<DeployedProject>> getDeployedProjects() throws MetadataException {
        if (this.deployedProjectHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
        return this.deployedProjectHelper.getDeployedProjects();
    }

    @Override
    public LocalRef<DeployedProject> getDeployedProject(@NotNull CompositeDN compositeDN) throws MetadataException {
        if (compositeDN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getDeployedProject must not be null");
        }
        if (this.deployedProjectHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
        return this.deployedProjectHelper.getDeployedProject(compositeDN);
    }

    @Override
    public void releaseLock(@NotNull PublicShareProject publicShareProjec) throws MetadataException {
        if (publicShareProjec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.releaseLock must not be null");
        }
        this.mdDomain.releaseLock(publicShareProjec);
    }

    @Override
    public void acquireLock(@NotNull PublicShareProject publicShareProject, @NotNull String username) throws MetadataException {
        if (publicShareProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.acquireLock must not be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.acquireLock must not be null");
        }
        this.mdDomain.assignLock(publicShareProject, username, true);
    }

    @Override
    public void updatePublicShareProperties(@NotNull String publicShareId, boolean allowSharing, @Nullable String workflow, @Nullable List<String> participantIds) throws MetadataException {
        if (publicShareId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.updatePublicShareProperties must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.CREATE_PROJECT_FROM_TEMPLATE);
        LocalRef<PublicShareProject> projectLocalRef = this.mdDomain.loadProject(PublicShareProject.class, publicShareId, false);
        PublicShareProject project = projectLocalRef.get();
        if (!project.getOwner().equals(this.securityContext.getPrincipal())) {
            throw new MetadataException(MetadataMsg.NOT_OWNER(projectLocalRef.getName()));
        }
        this.mdDomain.updatePublicShareProperties(publicShareId, allowSharing, workflow, participantIds);
    }

    @Override
    public String getLastDeployedVersion(@NotNull String projectName) throws MetadataException {
        if (projectName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/impl/ComposerMetadataServiceImpl.getLastDeployedVersion must not be null");
        }
        this.securityContext.assertPrivilege(Privilege.DEPLOY_PROJECT);
        return this.deployedProjectHelper.getLastDeployedVersion(projectName);
    }

    private void checkDeploymentHelper() throws MetadataException {
        if (this.deploymentHelper == null) {
            throw new MetadataException(MetadataMsg.DEPLOYMENT_NOT_AVAILABLE);
        }
    }
}

