/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pml.service.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.Cast;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.pml.service.deployment.AdfConfigFileWriter;
import oracle.bpm.pml.service.deployment.DeploymentResult;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.pml.service.util.ant.AntExecutor;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Base64;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeploymentHelper {
    final Pattern deployErrorPattern;
    private AntExecutor antExecutor;
    private File antScaDirectory;
    private URL soaSharedBundle;
    private File tmpDirectory;
    private static final String REGEX_DEPLYMENT_ERROR = "(Error during deployment: )(.*)";
    private static final String SOA_INFRA = "soa-infra";
    private static final String ANT_SCA_DEPLOY = "ant-sca-deploy.xml";
    private static final String ANT_SCA_PACKAGE = "ant-sca-package.xml";
    private static final String DEPLOY = "deploy";
    private static final String PACKAGE = "package";
    private static final String JAR_EXTENSION = ".jar";
    private static final String SAR_FILE_PREFIX = "sca_";

    public DeploymentHelper(@NotNull File tmpDirectory, @NotNull File antScaDirectory, @NotNull File antDirectory, @NotNull URL soaSharedBundle) {
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.<init> must not be null");
        }
        if (antScaDirectory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.<init> must not be null");
        }
        if (antDirectory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.<init> must not be null");
        }
        if (soaSharedBundle == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.<init> must not be null");
        }
        this.tmpDirectory = tmpDirectory;
        this.antScaDirectory = antScaDirectory;
        this.antExecutor = new AntExecutor(antDirectory);
        this.soaSharedBundle = soaSharedBundle;
        this.deployErrorPattern = Pattern.compile(REGEX_DEPLYMENT_ERROR);
    }

    public DeploymentResult generateSarFile(@NotNull MdProject mdProject, @NotNull String version) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.generateSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.generateSarFile must not be null");
        }
        DeploymentResult result = null;
        try {
            Project project = mdProject.getProject().get();
            Collection processes = project.getProcesses();
            if (!processes.isEmpty()) {
                Process process = (Process)processes.iterator().next();
                CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
            }
        }
        catch (MetadataException e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault((Throwable)((Object)e));
        }
        if (result == null && (result = this.copyProjectToTempFolder(mdProject)) == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            String oracleHome = this.getOracleHome();
            args.put("oracle.home", oracleHome);
            args.put("compositeDir", this.getTempFolderForProject(mdProject).getAbsolutePath());
            args.put("compositeName", mdProject.getName());
            args.put("revision", version);
            result = this.invokeTask(mdProject, PACKAGE, args);
        }
        return result;
    }

    public DeploymentResult deploy(@NotNull URL serverURL, @NotNull String user, @NotNull String password, @NotNull MdProject project, @NotNull String version, boolean overwrite, boolean forceDefault, @Nullable InputStream configPlan, @Nullable InputStream sysProp) {
        boolean failed;
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.deploy must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.deploy must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.deploy must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.deploy must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.deploy must not be null");
        }
        DeploymentResult result = this.validateDeploymentUser(serverURL, user, password);
        boolean bl = failed = result != null && (!result.hasFaults() || result.shouldFail());
        if (!failed) {
            result = this.generateSarFile(project, version);
            boolean bl2 = failed = result != null && (!result.hasFaults() || result.shouldFail());
            if (!failed) {
                File sarFile = this.getSarFile(project, version);
                HashMap<String, String> args = new HashMap<String, String>();
                String oracleHome = this.getOracleHome();
                String beaHomeFolder = new File(new File(oracleHome), "../").getAbsolutePath();
                args.put("bea.home", beaHomeFolder);
                args.put("oracle.home", oracleHome);
                args.put("serverURL", serverURL.toString());
                args.put("user", user);
                args.put("password", password);
                args.put("sarLocation", sarFile.getAbsolutePath());
                args.put("overwrite", Boolean.toString(overwrite));
                args.put("forceDefault", Boolean.toString(forceDefault));
                args.put("failOnError", Boolean.TRUE.toString());
                if (configPlan != null) {
                    File configPlanFile = new File(sarFile, "configPlanTemp.xml");
                    FileUtils.fileCopy((InputStream)configPlan, (File)configPlanFile);
                    args.put("configplan", configPlanFile.getAbsolutePath());
                }
                if (sysProp != null) {
                    File sysPropFileFile = new File(sarFile, "sysPropsTemp.xml");
                    FileUtils.fileCopy((InputStream)sysProp, (File)sysPropFileFile);
                    args.put("sysPropFile", sysPropFileFile.getAbsolutePath());
                }
                result = this.invokeTask(project, DEPLOY, args);
            }
        }
        return result;
    }

    public File getCompileOutput(@NotNull MdProject projectToDeploy) {
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.getCompileOutput must not be null");
        }
        return new File(this.getTempFolderForLogs(projectToDeploy), "sca_compile_output.xml");
    }

    public File getSarFile(@NotNull MdProject project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.getSarFile must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.getSarFile must not be null");
        }
        File projectPath = this.getTempFolderForProject(project);
        StringBuilder sarFilePath = new StringBuilder(projectPath.getAbsolutePath());
        sarFilePath.append(File.separator).append(DEPLOY);
        sarFilePath.append(File.separator).append(SAR_FILE_PREFIX);
        sarFilePath.append(DeployedProjectUtil.buildDeployedCompositeName(project.getName(), version));
        return new File(sarFilePath.append(JAR_EXTENSION).toString());
    }

    private DeploymentResult invokeTask(@NotNull MdProject mdProject, @NotNull String task, @NotNull Map<String, String> args) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.invokeTask must not be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.invokeTask must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.invokeTask must not be null");
        }
        DeploymentResult result = null;
        File outputFile = this.getCompileOutput(mdProject);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        args.put("scac.output", outputFile.getAbsolutePath());
        File scacBuildFile = task.equals(DEPLOY) ? new File(this.antScaDirectory, ANT_SCA_DEPLOY) : new File(this.antScaDirectory, ANT_SCA_PACKAGE);
        try {
            this.antExecutor.invoke(scacBuildFile, task, args);
            result = DeploymentResult.parseCompileOutput(outputFile, DeploymentResult.DeploymentFaultType.VALIDATION, null);
        }
        catch (InvocationTargetException e) {
            Matcher matcher;
            Throwable exception = e.getTargetException();
            exception.getMessage();
            String message = exception.getMessage();
            Msg deployMessage = null;
            if (message != null && message.length() > 0 && (matcher = this.deployErrorPattern.matcher(message)).find() && matcher.groupCount() == 2) {
                deployMessage = Msg.QUOTE((String)matcher.group(2));
            }
            if (deployMessage == null) {
                result = DeploymentResult.parseCompileOutput(outputFile, DeploymentResult.DeploymentFaultType.VALIDATION, null);
            }
            if (result == null) {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT, deployMessage);
            }
            result.addFault(e);
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.DEPLOYMENT);
            result.addFault(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DeploymentResult validateDeploymentUser(@NotNull URL serverURL, @NotNull String user, @NotNull String password) {
        if (serverURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.validateDeploymentUser must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.validateDeploymentUser must not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.validateDeploymentUser must not be null");
        }
        String encoding = Base64.encode((byte[])(user + ":" + password).getBytes());
        InputStream inputStream = null;
        DeploymentResult result = null;
        try {
            URL validationUrl = new URL(serverURL.toURI().toString() + "/" + SOA_INFRA);
            URLConnection uc = validationUrl.openConnection();
            uc.setRequestProperty("Authorization", "Basic " + encoding);
            inputStream = uc.getInputStream();
        }
        catch (IOException e) {
            block10: {
                String message = e.getMessage();
                if (message != null && message.contains("401")) {
                    result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.AUTHENTICATION_FAILED);
                    break block10;
                }
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION);
                result.addFault(e);
            }
            StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        }
        catch (URISyntaxException e2) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.CONFIGURATION, (Msg)MetadataMsg.DEPLOYMENT_URL_ERROR);
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtils.close((Closeable[])new Closeable[]{inputStream});
        return result;
    }

    private String getOracleHome() {
        File oracleHome = new File(this.antScaDirectory, "../");
        return oracleHome.getAbsolutePath();
    }

    private File getTempFolderForLogs(@NotNull MdProject mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.getTempFolderForLogs must not be null");
        }
        return new File(this.tmpDirectory, mdProject.getName());
    }

    private File getTempFolderForProject(@NotNull MdProject mdProject) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.getTempFolderForProject must not be null");
        }
        return new File(this.getTempFolderForLogs(mdProject), mdProject.getName());
    }

    private DeploymentResult copyProjectToTempFolder(@NotNull MdProject projectToDeploy) {
        if (projectToDeploy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.copyProjectToTempFolder must not be null");
        }
        DeploymentResult result = null;
        try {
            LocalRef projectLocalRef = (LocalRef)Cast.forceTo(projectToDeploy.getProject());
            Project project = (Project)projectLocalRef.get();
            ProjectLoader loader = project.getLoader();
            assert (loader != null);
            ProjectFileSystem fileSystem = loader.getProjectFileSystem();
            VFileSystem sourceFS = fileSystem.getDataFileSystem();
            File targetFolder = this.getTempFolderForProject(projectToDeploy);
            if (targetFolder.exists()) {
                FileUtils.deleteDirectory((File)targetFolder, (boolean)true);
            }
            targetFolder.mkdirs();
            JavaFileSystem targetFS = new JavaFileSystem(targetFolder);
            boolean wasCopied = VFileUtils.dirCopy((VFile)sourceFS.getRoot(), (VFile)targetFS.getRoot(), null);
            if (wasCopied) {
                this.createAdfConfigFile((VFileSystem)targetFS);
                targetFS.flush();
            } else {
                result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION, (Msg)MetadataMsg.COPY_FILE_ERROR);
            }
        }
        catch (Exception e) {
            result = new DeploymentResult(DeploymentResult.DeploymentFaultType.VALIDATION);
            result.addFault(e);
        }
        return result;
    }

    private void createAdfConfigFile(@NotNull VFileSystem targetFS) throws IOException {
        if (targetFS == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/pml/service/deployment/DeploymentHelper.createAdfConfigFile must not be null");
        }
        this.unZipSoaBundle();
        VFile adfFolder = targetFS.createFile(".adf");
        adfFolder.mkdirs();
        VFile metaInfFolder = targetFS.createFile(adfFolder, "META-INF");
        metaInfFolder.mkdirs();
        AdfConfigFileWriter.writeBaseOnFsMds(metaInfFolder, "/soa/shared", "soa-shared", this.tmpDirectory.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unZipSoaBundle() throws IOException {
        if (this.soaSharedBundle != null) {
            File zipFolder = new File(this.tmpDirectory, "soa-shared");
            zipFolder.mkdir();
            File soaZipFile = new File(zipFolder, "soa-shared-bundle.zip");
            FileUtils.fileCopy((InputStream)this.soaSharedBundle.openStream(), (File)soaZipFile);
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(soaZipFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (zipEntry.isDirectory()) {
                        new File(zipFolder, zipEntry.getName()).mkdirs();
                        continue;
                    }
                    FileUtils.fileCopy((InputStream)zipFile.getInputStream(zipEntry), (File)new File(zipFolder, zipEntry.getName()));
                }
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
    }
}

