/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;

class VariableDummper {
    VariableDummper() {
    }

    static String arrayAsString(Object obj) {
        assert (obj.getClass().isArray()) : "obj must be a native array";
        StringBuilder buf = new StringBuilder();
        int length = Array.getLength(obj);
        buf.append("[");
        for (int i = 0; i < length; ++i) {
            Object elem = Array.get(obj, i);
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(VariableDummper.asString(elem));
        }
        buf.append("]");
        return buf.toString();
    }

    static String asString(Object variable) {
        String ret;
        if (variable == null) {
            ret = "(null)";
        } else if (variable instanceof Character) {
            ret = VariableDummper.asString((Character)variable);
        } else if (variable instanceof Byte) {
            ret = VariableDummper.asString((Byte)variable);
        } else if (variable instanceof Short) {
            ret = VariableDummper.asString((Short)variable);
        } else if (variable instanceof String) {
            ret = VariableDummper.asString((String)variable);
        } else if (variable instanceof Long) {
            ret = variable.toString() + "L";
        } else if (variable instanceof Float) {
            ret = variable.toString() + "f";
        } else if (variable instanceof BigDecimal) {
            ret = variable.toString() + "d";
        } else if (variable instanceof Time) {
            ret = "'" + variable.toString() + "'";
        } else if (variable instanceof Interval) {
            ret = "'" + variable.toString() + "'";
        } else if (variable instanceof byte[]) {
            ret = VariableDummper.asString((byte[])variable);
        } else if (variable.getClass().isArray()) {
            ret = VariableDummper.arrayAsString(variable);
        } else if (variable instanceof Collection) {
            ret = VariableDummper.asString((Collection)variable);
        } else if (variable instanceof Map) {
            ret = VariableDummper.asString((Map)variable);
        } else {
            try {
                Method toStringMethod = variable.getClass().getMethod("toString", new Class[0]);
                Class<?> toStringDeclaredClazz = toStringMethod.getDeclaringClass();
                ret = toStringDeclaredClazz.equals(Object.class) ? variable.getClass().getName() : String.valueOf(variable);
            }
            catch (NoSuchMethodException e) {
                ret = String.valueOf(variable);
            }
            ret = Str.replaceString(ret, "\n", "\\n");
        }
        return ret;
    }

    static String asString(String obj) {
        return Str.replaceString("\"" + String.valueOf(obj) + "\"", "\n", "\\n");
    }

    static String asString(Character obj) {
        return "'" + String.valueOf(obj) + "'";
    }

    static String asString(Byte obj) {
        return String.valueOf(obj) + 'b';
    }

    static String asString(Short obj) {
        return String.valueOf(obj) + 's';
    }

    static String asString(Collection<Object> collection) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            buf.append(VariableDummper.asString(elem));
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private static String asString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        result.append('|');
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (i > 0) {
                result.append(' ');
            }
            result.append(Integer.toHexString(b >> 4 & 0xF));
            result.append(Integer.toHexString(b & 0xF));
        }
        result.append('|');
        return result.toString();
    }

    private static String asString(Map<Object, Object> map) {
        String result;
        if (map instanceof SortedMap) {
            result = VariableDummper.stringToMap(map);
        } else {
            SortedStringMap<Object> m = SortedStringMap.create();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object k = entry.getKey();
                String key = k instanceof String ? (String)k : VariableDummper.asString(k);
                m.put(key, entry.getValue());
            }
            result = VariableDummper.stringToMap(m);
        }
        return result;
    }

    private static String stringToMap(Map<?, Object> map) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Map.Entry<?, Object> e : map.entrySet()) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(VariableDummper.asString(e.getKey()));
            buf.append(":");
            buf.append(VariableDummper.asString(e.getValue()));
        }
        buf.append("]");
        return buf.toString();
    }
}

