/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.visualbasic;

import java.util.Set;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.lang.TypeDescription;
import org.jetbrains.annotations.NonNls;

public class VisualBasicTypeRenderer
extends TypeRenderer {
    public VisualBasicTypeRenderer(TokenNames names, Set<CharSequence> tokens) {
        super(tokens);
        this.arrayDeclarationStart = names.getArrayDeclarationStart();
        this.arrayDeclarationEnd = names.getArrayDeclarationEnd();
        this.parameterStart = names.getParameterStart();
        this.parameterEnd = names.getParameterEnd();
        this.orderedSymbol = names.getOrderedSymbol();
        this.declarationSymbol = names.getDeclarationSymbol();
    }

    @Override
    protected void renderBuiltInType(TypeDescription type, @NonNls StringBuilder buffer, int flags) {
        int length = type.getLength();
        int kind = type.getKind();
        switch (kind) {
            case 2: {
                if (length <= 8) {
                    buffer.append("Byte");
                    break;
                }
                if (length <= 16) {
                    buffer.append("Short");
                    break;
                }
                if (length <= 32) {
                    buffer.append("Integer");
                    break;
                }
                buffer.append("Long");
                break;
            }
            case 5: {
                buffer.append(length == 1 ? "Char" : "String" + (length == -1 ? "" : "<" + length + ">"));
                break;
            }
            case 4: {
                buffer.append(length <= 32 ? "Single" : "Double");
                break;
            }
            case 1: {
                buffer.append("Boolean");
                break;
            }
            case 0: {
                buffer.append("Void");
                break;
            }
            default: {
                super.renderBuiltInType(type, buffer, flags);
            }
        }
    }
}

