/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.langs.visualbasic;

import fuego.lexer.FuegoLexerInputStream;
import fuego.lexer.LexerConfigurator;
import fuego.parser.TokenStreamException;
import oracle.bpm.compiler.SqlReservedWords;
import oracle.bpm.compiler.langs.fuego.Fuego2CILLexerConfigurator;

public class VisualBasicCILLexerConfigurator
extends LexerConfigurator {
    private static final String[] rwA = new String[]{"AddHandler", "AddressOf", "AndAlso", "Alias", "@And", "Ansi", "As", "Assembly", "Auto"};
    private static final String[] rwB = new String[]{"Boolean", "ByRef", "Byte", "ByVal"};
    private static final String[] rwC = new String[]{"Call", "Case", "Catch", "CBool", "CByte", "CChar", "CDate", "CDec", "CDbl", "Char", "CInt", "Class", "CLng", "CObj", "Const", "CShort", "CSng", "CStr", "CType"};
    private static final String[] rwD = new String[]{"Date", "Decimal", "Declare", "Default", "Delegate", "Dim", "DirectCast", "Do", "Double"};
    private static final String[] rwE = new String[]{"Each", "Else", "ElseIf", "End", "ENUM:Enum", "Erase", "Error", "Event", "Exit"};
    private static final String[] rwF = new String[]{"@False", "Finally", "For", "Friend", "Function"};
    private static final String[] rwG = new String[]{"Get", "GetType", "GoSub", "GoTo"};
    private static final String[] rwH = new String[]{"Handles"};
    private static final String[] rwI = new String[]{"If", "Implements", "Imports", "In", "Inherits", "Integer", "Interface", "Is"};
    private static final String[] rwL = new String[]{"Let", "Lib", "Like", "Long", "Loop"};
    private static final String[] rwM = new String[]{"Me", "Mod", "Module", "MustInherit", "MustOverride", "MyBase", "MyClass"};
    private static final String[] rwN = new String[]{"Namespace", "New", "Next", "@Not", "@Nothing", "NotInheritable", "NotOverridable"};
    private static final String[] rwO = new String[]{"Object", "On", "Option", "Optional", "@Or", "OrElse", "Overloads", "Overridable", "Overrides"};
    private static final String[] rwP = new String[]{"ParamArray", "Preserve", "Private", "Property", "Protected", "Public"};
    private static final String[] rwR = new String[]{"RaiseEvent", "ReadOnly", "ReDim", "REM", "RemoveHandler", "Resume", "Return"};
    private static final String[] rwS = new String[]{"Select", "Set", "Shadows", "Shared", "Short", "Single", "Static", "Step", "Stop", "String", "Structure", "Sub", "SyncLock"};
    private static final String[] rwT = new String[]{"Then", "Throw", "To", "@True", "Try", "TypeOf"};
    private static final String[] rwU = new String[]{"Unicode", "Until"};
    private static final String[] rwV = new String[]{"Variant"};
    private static final String[] rwW = new String[]{"When", "While", "With", "WithEvents", "WriteOnly"};
    private static final String[] rwX = new String[]{"Xor"};
    private static final String[] nonStandardReservedWords = new String[]{"Out", "Display", "LogMessage", "Input", "Ordered", "Relay"};
    private static final String[] multiCharTokens = new String[]{"ADD:+", "SUB:-", "MUL:*", "DIV:/", "EXP:^", "INTEGER_DIV:\\", "GT:>", "GE:>=", "LT:<", "LE:<=", "EQ:=", "NE:<>", "QUESTION:?", "COLON::", "DOT:.", "RANGE:..", "SEMICOLON:;", "CONCAT:&", "GT:>", "GE:>=", "LT:<", "LE:<=", "QUESTION:?", "COLON::", "DOT:.", "RANGE:..", "SEMICOLON:;", "COMMA:,", "LPAREN:(", "RPAREN:)", "LBRACK:[", "RBRACK:]", "LBRACE:{", "RBRACE:}", "INC:++", "DEC:--", "LEFT_SHIFT:<<", "RIGHT_SHIFT:>>", "ARG_EQ::=", "PLUS_EQ:+=", "MINUS_EQ:-=", "MUL_EQ:*=", "DIV_EQ:/=", "CAT_EQ:&=", "EXP_EQ:^="};

    public VisualBasicCILLexerConfigurator() {
        super("1");
    }

    public char getEscapeForNewLine() {
        return '_';
    }

    public boolean isLineCommentStart(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '\'') {
            return true;
        }
        if (c == 'R' || c == 'r') {
            c = lexer.read();
            if (c == 'E' || c == 'e') {
                c = lexer.read();
                if (c == 'M' || c == 'm') {
                    c = lexer.read();
                    if (Character.isWhitespace(c)) {
                        return true;
                    }
                    lexer.unread();
                }
                lexer.unread();
            }
            lexer.unread();
        }
        return false;
    }

    public boolean isNewLineToken() {
        return true;
    }

    public boolean isRegExpEnd(char c) {
        return c == '#';
    }

    public boolean isRegExpStart(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '#') {
            c = lexer.read();
            if (c == '/') {
                return true;
            }
            lexer.unread();
        }
        return false;
    }

    public boolean isTimeLiteralDelimiter(char c) {
        return c == '#';
    }

    public int numberSuffixType(char c) {
        int type = -1;
        switch (c) {
            case 'S': {
                type = 11;
                break;
            }
            case 'I': {
                type = 11;
                break;
            }
            case 'L': {
                type = 11;
                break;
            }
            case '%': {
                type = 11;
                break;
            }
            case '&': {
                type = 11;
                break;
            }
            case 'F': {
                type = 12;
                break;
            }
            case 'R': {
                type = 12;
                break;
            }
            case 'D': {
                type = 13;
                break;
            }
            case '!': {
                type = 12;
                break;
            }
            case '#': {
                type = 12;
                break;
            }
            case '@': {
                type = 13;
            }
        }
        return type;
    }

    public String getLanguageName() {
        return "VisualBasic";
    }

    protected String[][] getMultiCharTokensArrays(int state) {
        switch (state) {
            case 1: {
                return new String[][]{multiCharTokens, {"CAT:||"}};
            }
        }
        return new String[][]{multiCharTokens, {"OR:||"}};
    }

    protected String[][] getReservedWordsArrays(int state) {
        switch (state) {
            case 1: {
                return new String[][]{Fuego2CILLexerConfigurator.getReservedWords(), SqlReservedWords.getReservedWords()};
            }
        }
        return new String[][]{rwA, rwB, rwC, rwD, rwE, rwF, rwG, rwH, rwI, rwL, rwM, rwN, rwO, rwP, rwR, rwS, rwT, rwU, rwV, rwW, rwX, nonStandardReservedWords};
    }
}

