/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.Template;
import oracle.bpm.type.SourceCode;

public class TemplateSpec
implements MessageListener {
    private SourceCode code;
    private Node compiledCode;
    private boolean expression;

    private TemplateSpec(SourceCode code) {
        this.code = code;
    }

    public static TemplateSpec create(SourceCode code) {
        return new TemplateSpec(code);
    }

    public Template instantiate(Node context) throws CompilerException {
        if (this.compiledCode == null) {
            this.expression = context.isExpression();
            this.compiledCode = this.parse(this.code, context.getCompiler());
        }
        return new Template(Node.deepCopy(this.compiledCode), context);
    }

    @Override
    public void reportError(CilException error) {
        System.err.println("Could not apply refactor [" + new String(this.code.getText()) + "]");
        System.err.println("Reason: " + error);
    }

    @Override
    public void reportWarning(CilException error) {
    }

    static Node parseCompilerCode(SourceCode code) {
        String text = new String(code.getText());
        if (!(text = text.trim()).startsWith("#")) {
            return null;
        }
        int lparen = text.indexOf(40);
        int rparen = text.lastIndexOf(41);
        if (lparen == -1 || rparen == -1) {
            return null;
        }
        String[] args = TemplateSpec.parseArgs(text.substring(lparen + 1, rparen));
        String className = text.substring(1, lparen);
        Node tree = TemplateSpec.instantiateNode(className);
        if (tree != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!arg.startsWith("$")) {
                    return null;
                }
                tree.addChild((AST)new Parameter(arg.substring(1)));
            }
        }
        return tree;
    }

    boolean isExpression() {
        return this.expression;
    }

    Node parse(SourceCode code, FuegoCompiler compiler) throws InvalidLanguageException, CompilerParserException {
        try {
            String language = code.getLanguage();
            Node tree = "Compiler".equals(language) ? TemplateSpec.parseCompilerCode(code) : (this.isExpression() ? compiler.parse(code, this) : compiler.parseMethod(code, false, this));
            return tree;
        }
        catch (CompilerParserException e) {
            this.reportError(e);
            throw e;
        }
        catch (InvalidLanguageException e) {
            this.reportError(e);
            throw e;
        }
    }

    private static Node instantiateNode(String className) {
        Node result;
        try {
            Class<?> cl = Class.forName("oracle.bpm.compiler." + className);
            result = (Node)cl.newInstance();
        }
        catch (Exception ignore) {
            result = null;
        }
        return result;
    }

    private static String[] parseArgs(String args) {
        return args.split(",\\w*");
    }
}

