/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Delete;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.Display;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.GroupByColumns;
import oracle.bpm.compiler.Having;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.Input;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.Insert;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Log;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectInput;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.OrderBy;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SelectColumns;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateSpec;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.Update;
import oracle.bpm.compiler.While;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NonNls;

public class TemplateFactory {
    public static Node createAssignment() {
        return new Assignment(TemplateFactory.local("variable"), TemplateFactory.expression());
    }

    public static Node createCase() {
        Switch switchNode = new Switch();
        switchNode.addChild((AST)TemplateFactory.expression());
        Switch.Case caseNode = new Switch.Case();
        caseNode.addChild((AST)TemplateFactory.idParameter("case1"));
        caseNode.addChild((AST)TemplateFactory.statements());
        switchNode.addChild((AST)caseNode);
        caseNode = new Switch.Case();
        caseNode.addChild((AST)TemplateFactory.idParameter("case2"));
        caseNode.addChild((AST)TemplateFactory.statements());
        switchNode.addChild((AST)caseNode);
        Switch.Default defaultCase = new Switch.Default();
        defaultCase.addChild((AST)TemplateFactory.statements());
        switchNode.addChild((AST)defaultCase);
        return switchNode;
    }

    public static Node createDeclaration() {
        return new Declaration((AST)TemplateFactory.parameter("variable"), (AST)TemplateFactory.type(TypeFactory.getString()), null);
    }

    public static Node createDisplay() {
        Display display = Display.message(TemplateFactory.stringParameter(CompilerMsg.MESSAGE));
        Args inArgs = new Args(1L);
        TemplateFactory.addInArg(inArgs, "title", TemplateFactory.stringParameter("title"));
        return display;
    }

    public static Node createDisplayFull() {
        Display display = Display.message(TemplateFactory.stringParameter(CompilerMsg.MESSAGE));
        Args inArgs = new Args(1L);
        TemplateFactory.addInArg(inArgs, "title", TemplateFactory.stringParameter("title"));
        TemplateFactory.addInArg(inArgs, "type", TemplateFactory.stringParameter("info"));
        TemplateFactory.addInArg(inArgs, "options", TemplateFactory.buttons());
        TemplateFactory.addInArg(inArgs, "default", TemplateFactory.stringParameter("Ok"));
        Args outArgs = new Args(2L);
        TemplateFactory.addOutArg(outArgs, "selection", TemplateFactory.local("selectedButton"));
        inArgs.setNext(outArgs);
        display.addChild((AST)inArgs);
        return display;
    }

    public static DoBlock createDoBlock() {
        DoBlock block = new DoBlock();
        block.addChild((AST)new Block());
        block.addChild((AST)new Block((AST)TemplateFactory.statements()));
        return block;
    }

    public static Node createExit() {
        return Exit.from(TemplateFactory.label(), TemplateFactory.condition());
    }

    public static Node createFor() {
        return new For(TemplateFactory.idParameter("index"), TemplateFactory.array(), TemplateFactory.statements());
    }

    public static Node createForEach() {
        ForEach forEach = new ForEach();
        forEach.setOperands(TemplateFactory.idParameter("element"), TemplateFactory.array(), TemplateFactory.statements());
        return forEach;
    }

    public static Node createIf() {
        return If.condition(TemplateFactory.condition(), TemplateFactory.statements());
    }

    public static Node createIfElse() {
        return If.condition(TemplateFactory.condition(), TemplateFactory.statements(), TemplateFactory.statements());
    }

    public static Node createIfElseIf() {
        If ifnode = If.condition(TemplateFactory.condition(), TemplateFactory.statements(), TemplateFactory.statements());
        Node elseBlock = ifnode.getFirst().getLast();
        elseBlock.replace(TemplateFactory.createIf());
        return ifnode;
    }

    public static Input createInput() {
        Input input = new Input(null);
        input.setOperand(TemplateFactory.inputFields());
        Args args = new Args(1L);
        TemplateFactory.addInArg(args, "title", TemplateFactory.stringParameter("title"));
        input.addChild((AST)args);
        return input;
    }

    public static Input createInputFull() {
        Input input = TemplateFactory.createInput();
        Args inArgs = (Args)input.getOp2();
        TemplateFactory.addInArg(inArgs, "buttons", TemplateFactory.buttons());
        Args outArgs = new Args(2L);
        TemplateFactory.addOutArg(outArgs, "selection", TemplateFactory.local("selectedButton"));
        inArgs.setNext(outArgs);
        return input;
    }

    public static Node createInputInterceptor() {
        Input input = TemplateFactory.createInputFull();
        Args inArgs = (Args)input.getOp2();
        TemplateFactory.addInArg(inArgs, "htmlForm", TemplateFactory.stringParameter("relative or full url"));
        TemplateFactory.addInArg(inArgs, "until", TemplateFactory.stringParameter("pattern@URL or pattern@file"));
        TemplateFactory.addInArg(inArgs, "links", TemplateFactory.parameter(new Node[]{TemplateFactory.string("intercept"), TemplateFactory.string("popup"), TemplateFactory.string("clear")}));
        TemplateFactory.addInArg(inArgs, "userControl", TemplateFactory.parameter(new Node[]{TemplateFactory.falseValue(), TemplateFactory.trueValue()}));
        ArrayConst cookies = new ArrayConst();
        cookies.setMap(true);
        cookies.addChild((AST)TemplateFactory.string("name"));
        cookies.addChild((AST)TemplateFactory.string("value"));
        TemplateFactory.addInArg(inArgs, "cookies", TemplateFactory.parameter(cookies));
        return input;
    }

    public static Node createLog() {
        Log log = new Log();
        log.addChild((AST)TemplateFactory.stringParameter("message"));
        return log;
    }

    public static SourceTemplate createMappedArray(MethodTypeDescription method, Node object, Completion completion) {
        Node node;
        Node op2 = object.getOp2();
        Identifier member = new Identifier(method.getName());
        if (op2.isCompletion()) {
            op2.replace(member);
            node = object;
        } else {
            node = new MemberReference(object, member);
        }
        return new SourceTemplate(node, method.getName(), method.getDescription());
    }

    public static SourceTemplate createObjectInput(String name, String target) {
        ObjectInput input = new ObjectInput();
        input.addChild((AST)TemplateFactory.idParameter(target));
        Args args = new Args(1L);
        TemplateFactory.addInArg(args, "selectedPresentation", TemplateFactory.stringParameter(name));
        input.addChild((AST)args);
        return new SourceTemplate(input);
    }

    public static ObjectInput createObjectInput() {
        ObjectInput input = new ObjectInput();
        input.addChild((AST)TemplateFactory.idParameter("object"));
        Args args = new Args(1L);
        TemplateFactory.addInArg(args, "selectedPresentation", TemplateFactory.stringParameter("presentation"));
        input.addChild((AST)args);
        return input;
    }

    public static Node createOnExit() {
        DoBlock block = TemplateFactory.createDoBlock();
        Block exceptions = new Block();
        block.addChild((AST)exceptions);
        OnExit on = new OnExit();
        on.addChild((AST)TemplateFactory.statements());
        exceptions.addChild((AST)on);
        return block;
    }

    public static Node createOnStatement() {
        DoBlock block = TemplateFactory.createDoBlock();
        Block exceptions = new Block();
        On on = new On();
        on.addChild((AST)TemplateFactory.type(TypeFactory.getAny()));
        on.addChild((AST)TemplateFactory.idParameter("e"));
        on.addChild((AST)TemplateFactory.statements());
        exceptions.addChild((AST)on);
        block.addChild((AST)exceptions);
        return block;
    }

    public static Node createReturn() {
        return Return.expression(TemplateFactory.expression());
    }

    public static Node createSqlDelete() {
        Delete delete = new Delete();
        delete.addChild((AST)TemplateFactory.table());
        delete.addChild((AST)TemplateFactory.condition());
        return delete;
    }

    public static Node createSqlInsert() {
        Insert insert = new Insert();
        insert.addChild((AST)TemplateFactory.table());
        insert.addChild((AST)TemplateFactory.insertColumns());
        insert.addChild((AST)TemplateFactory.insertValues());
        return insert;
    }

    public static Node createSqlInsertFromTable() {
        Insert insert = new Insert();
        insert.addChild((AST)TemplateFactory.table());
        insert.addChild((AST)TemplateFactory.insertColumns());
        insert.addChild((AST)TemplateFactory.createSelect());
        return insert;
    }

    public static SourceTemplate createSqlSelect(ObjectTypeDescription table) {
        Node each = TemplateFactory.createForEach();
        Select select = TemplateFactory.createSelect(table);
        each.getOp2().replace(select);
        return new SourceTemplate(each);
    }

    public static Node createSqlSelect() {
        Node each = TemplateFactory.createForEach();
        Select select = TemplateFactory.createSelect();
        each.getOp2().replace(select);
        return each;
    }

    public static Node createSqlSelectFull() {
        Node node = TemplateFactory.createSqlSelect();
        Select select = (Select)node.getOp2();
        select.addChild((AST)TemplateFactory.groupBy());
        select.addChild((AST)TemplateFactory.having());
        select.addChild((AST)TemplateFactory.orderBy());
        return node;
    }

    public static Node createSqlUpdate() {
        Update update = new Update();
        update.addChild((AST)TemplateFactory.table());
        update.addChild((AST)TemplateFactory.updateSetValues());
        update.addChild((AST)TemplateFactory.condition());
        return update;
    }

    public static SourceTemplate createTemplate(MethodTypeDescription member) {
        return new SourceTemplate.MemberSourceTemplate(member);
    }

    public static Node createThrow() {
        try {
            Throw node = new Throw();
            TypeRef type = TypeUtils.getDefaultCatalog().find("Java.Lang.Exception");
            node.setFirst(TemplateFactory.type(type.get()));
            return node;
        }
        catch (AmbiguousTypeNameException e) {
            return null;
        }
    }

    public static Node createWhile() {
        return While.condition(TemplateFactory.condition(), TemplateFactory.statements());
    }

    static SourceTemplate createEqualsTemplate(Node object) {
        Equality equality = Equality.equals(object, TemplateFactory.parameter("other"));
        return new SourceTemplate(equality, "equals", "description");
    }

    static Node createMemberTemplate(Completion completion, Node object, MethodTypeDescription member) {
        return TemplateFactory.createMemberTemplate(completion, object, member, false);
    }

    static Node createMemberTemplate(Completion completion, Node object, MethodTypeDescription member, boolean qualify) {
        ObjectClass currentClass;
        if (completion != null && object == null && (currentClass = completion.getCurrentClass()) != null) {
            TypeDescription type = currentClass.getTypeDescription();
            if (member.getParent().isAssignableFrom(type)) {
                object = member.isStatic() ? new TypeSpec(type, (Token)null) : TemplateFactory.createThis();
                if (!qualify) {
                    object.setSynthetic(true);
                }
            }
        }
        Node result = member.isAttribute() ? TemplateFactory.createAttribute(member, object) : (member.isMethod() ? TemplateFactory.createMethod(member, object, completion) : TemplateFactory.createTransform(member, object));
        return result;
    }

    static SourceTemplate createTemplate(MethodTypeDescription member, Node object, Completion completion) {
        return TemplateFactory.createTemplate(member, object, completion, false);
    }

    static SourceTemplate createTemplate(MethodTypeDescription member, Node object, Completion completion, boolean qualify) {
        Node result = TemplateFactory.createMemberTemplate(completion, object, member, qualify);
        return new SourceTemplate(result, member.getName(), member.getDescription());
    }

    static Node defaultValue(TypeDescription type) {
        return TemplateFactory.defaultValue(type, null);
    }

    static Node defaultValue(TypeDescription type, String custom) {
        Const result;
        boolean isEmpty = custom == null || custom.trim().length() == 0;
        switch (type.getKind()) {
            case 5: {
                result = isEmpty ? new StringConst("") : new StringConst(custom);
                break;
            }
            case 2: {
                result = isEmpty ? new IntConst(0L, type) : new IntConst((long)Int.asInteger(custom).intValue(), type);
                break;
            }
            case 4: {
                result = isEmpty ? new RealConst("0.0", type) : new RealConst(custom, type);
                break;
            }
            case 3: {
                result = isEmpty ? new DecimalConst("0.0", 0, 1) : new DecimalConst(custom, 0, 1);
                break;
            }
            case 7: {
                result = isEmpty ? new IntervalConst(Interval.ZERO, null) : new IntervalConst(Interval.valueOf(custom), null);
                break;
            }
            case 6: {
                result = isEmpty ? new TimeConst("now") : new TimeConst(custom);
                break;
            }
            case 1: {
                result = isEmpty ? new BoolConst(false) : new BoolConst(Bool.booleanValue(custom));
                break;
            }
            case 12: {
                result = new ArrayConst((Token)null);
                break;
            }
            default: {
                result = new NullConst();
            }
        }
        return TemplateFactory.parameter(result);
    }

    private static void addInArg(Args inArgs, @NonNls String name, Node value) {
        Argument argument = new Argument(name, TypeFactory.getAny(), 1L);
        Arg arg = new Arg(argument, 1L);
        arg.setValue(value);
        inArgs.addInArgument(arg);
    }

    private static void addOutArg(Args outArgs, @NonNls String name, Node value) {
        Argument argument = new Argument(name, TypeFactory.getAny(), 2L);
        Arg arg = new Arg(argument, 2L);
        arg.setValue(value);
        outArgs.addOutArgument(arg);
    }

    private static Node array() {
        return TemplateFactory.idParameter("array");
    }

    private static Node buttons() {
        ArrayConst okCancel = new ArrayConst();
        okCancel.addChild((AST)TemplateFactory.string("Ok"));
        okCancel.addChild((AST)TemplateFactory.string("Cancel"));
        ArrayConst ok = new ArrayConst();
        ok.addChild((AST)TemplateFactory.string("Ok"));
        Node[] options = new Node[]{okCancel, ok};
        return TemplateFactory.parameter(options);
    }

    private static Node column(int number) {
        return TemplateFactory.parameter("column" + number);
    }

    private static Node condition() {
        return TemplateFactory.parameter(CompilerMsg.CONDITION);
    }

    private static Node createAttribute(MethodTypeDescription attribute, Node object) {
        if (object == null) {
            object = TemplateFactory.type(attribute.getParent());
        }
        return new MemberReference(object, TemplateFactory.member(attribute));
    }

    private static Node createMethod(MethodTypeDescription member, Node object, Completion completion) {
        boolean hasReturn;
        block20: {
            String template = member.getTemplate();
            if (object == null) {
                object = TemplateFactory.type(member.getParent());
                if (completion != null) {
                    object.setScope(completion.getScope());
                } else {
                    FuegoCompiler compiler = new FuegoCompiler();
                    Scope scope = new Scope(compiler);
                    object.setScope(scope);
                }
            }
            if (template != null) {
                SourceCode code = SourceCode.create(template, "Fuego");
                Node context = completion != null ? completion : object;
                try {
                    TemplateSpec templateSpec = TemplateSpec.create(code);
                    Template refactor = templateSpec.instantiate(context);
                    refactor.setStatement(true);
                    object.setTypeDescription(member.getParent());
                    refactor.addParameter("object", object);
                    Node result = refactor.apply();
                    if (result != null) {
                        result = TemplateFactory.replaceConstsByParameters(result);
                        return result;
                    }
                }
                catch (CompilerException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block20;
                    throw new AssertionError((Object)("Invalid template: '" + e + "'. Problem: " + e));
                }
            }
        }
        Args inArgs = new Args(1L);
        Args outArgs = new Args(2L);
        inArgs.setNext(outArgs);
        Argument resultArgument = member.getResultArgument();
        TypeDescription resultType = resultArgument.getType();
        String resultName = resultArgument.getName();
        boolean canBeFunction = hasReturn = !resultType.isVoid();
        int argc = member.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            Arg argument;
            Argument arg = member.getArgument(i);
            if (arg.isIn()) {
                argument = new Arg(arg, 1L);
                argument.setValue(TemplateFactory.defaultValue(arg.getType()));
                inArgs.addInArgument(argument);
            }
            if (!arg.isOut()) continue;
            argument = new Arg(arg, 2L);
            argument.setValue(TemplateFactory.local(arg.getName()));
            outArgs.addOutArgument(argument);
            canBeFunction = false;
        }
        boolean parentIsExpression = false;
        Node parent = object.getParent();
        if (parent == null && completion != null) {
            parent = completion.getParent();
        }
        if (parent instanceof MemberAccess && parent.isExpression() || parent instanceof Assignment || parent instanceof Args) {
            parentIsExpression = true;
        }
        Invoke invoke = new Invoke(TemplateFactory.member(member), object, inArgs);
        invoke.setMemberType(member);
        Diadic result = invoke;
        if (!hasReturn) {
            invoke.setStatement(true);
        } else {
            if ("return".equals(resultName)) {
                resultName = resultType.isObject() ? oracle.bpm.util.Identifier.attribute(resultType.getName()) : "result";
            }
            if (completion != null) {
                resultName = completion.findFreeId(resultName);
                Method currentMember = completion.getCurrentMember();
                if (currentMember != null) {
                    MethodTypeDescription currentMethod = currentMember.getMethodType();
                    resultName = currentMethod.getParent().findFreeMemberName(resultName);
                }
            }
            if (!canBeFunction) {
                Arg arg = new Arg(resultArgument, 2L);
                arg.setValue(TemplateFactory.local(resultName));
                outArgs.addOutArgument(arg);
                invoke.setStatement(true);
            } else if (parentIsExpression) {
                invoke.setExpression(true);
            } else {
                result = new Assignment(TemplateFactory.local(resultName), invoke);
                invoke.setStatement(false);
            }
        }
        return result;
    }

    private static Select createSelect(ObjectTypeDescription table) {
        Select select = new Select();
        select.addChild((AST)TemplateFactory.selectColumns(table));
        select.addChild((AST)(table == null ? TemplateFactory.table() : TemplateFactory.type(table)));
        if (table == null) {
            select.addChild((AST)TemplateFactory.condition());
        }
        return select;
    }

    private static Select createSelect() {
        return TemplateFactory.createSelect(null);
    }

    private static Node createThis() {
        return new Identifier.This(null);
    }

    private static Node createTransform(MethodTypeDescription member, Node library) {
        TransformTypeDescription transform = (TransformTypeDescription)member;
        Diadic call = new TransformCall();
        int sourceCount = transform.getSourceCount();
        if (sourceCount == 1) {
            call.addChild((AST)TemplateFactory.idParameter(transform.getSourceName(0)));
        } else {
            NList list = new NList();
            for (int i = 0; i < sourceCount; ++i) {
                list.addChild((AST)TemplateFactory.idParameter(transform.getSourceName(i)));
            }
            call.addChild((AST)list);
        }
        ObjectTypeDescription libraryType = transform.getParent().asObject();
        if (library == null) {
            library = TemplateFactory.type(libraryType);
        }
        call.addChild((AST)new TypeSpec(transform.getTarget(), (Token)null));
        call.addChild((AST)new TypeSpec((TypeDescription)libraryType, (Token)null));
        Node parent = library.getParent();
        if (parent == null || parent.isStatement()) {
            call = new Assignment(TemplateFactory.idParameter(transform.getTargetName()), call);
        }
        return call;
    }

    private static Node expression() {
        return TemplateFactory.parameter(CompilerMsg.EXPRESSION);
    }

    private static BoolConst falseValue() {
        return new BoolConst(false);
    }

    private static Node groupBy() {
        GroupByColumns columns = new GroupByColumns();
        columns.addChild((AST)TemplateFactory.column(1));
        columns.addChild((AST)TemplateFactory.column(2));
        return columns;
    }

    private static Node having() {
        Having having = new Having();
        having.addChild((AST)TemplateFactory.condition());
        return having;
    }

    private static Node idParameter(@NonNls String name) {
        return TemplateFactory.parameter(name);
    }

    private static Node inputFields() {
        InputFields fields = new InputFields();
        fields.addChild((AST)new InputField(TemplateFactory.stringParameter("label1"), TemplateFactory.local("variable1")));
        fields.addChild((AST)new InputField(TemplateFactory.stringParameter("label2"), TemplateFactory.local("variable2")));
        return fields;
    }

    private static Node insertColumns() {
        Insert.Columns columns = new Insert.Columns();
        columns.addChild((AST)TemplateFactory.column(1));
        columns.addChild((AST)TemplateFactory.column(2));
        return columns;
    }

    private static Node insertValues() {
        Insert.Values values = new Insert.Values();
        values.addChild((AST)TemplateFactory.value(1));
        values.addChild((AST)TemplateFactory.value(2));
        return values;
    }

    private static Node label() {
        return TemplateFactory.parameter("label");
    }

    private static Node local(@NonNls String name) {
        return TemplateFactory.parameter(name);
    }

    private static Node member(MethodTypeDescription member) {
        return new Identifier(member.getName());
    }

    private static Node orderBy() {
        OrderBy orderBy = new OrderBy();
        orderBy.addChild((AST)TemplateFactory.column(1));
        orderBy.addChild((AST)TemplateFactory.column(2));
        return orderBy;
    }

    private static Node parameter(Msg msg) {
        return TemplateFactory.parameter(msg.getString());
    }

    private static Node parameter(Node op) {
        return new Parameter(op);
    }

    private static Parameter parameter(@NonNls String op) {
        return TemplateFactory.parameter(op, false);
    }

    private static Parameter parameter(String op, boolean complete) {
        Parameter parameter = new Parameter(op);
        parameter.setMustComplete(complete);
        return parameter;
    }

    private static Node parameter(Node[] options) {
        Completion completion = new Completion(options);
        return new Parameter(options[0], completion);
    }

    private static Node replaceConstsByParameters(Node result) {
        Node prev = null;
        Node current = result.getFirst();
        while (current != null) {
            Node next = current.getNext();
            Node newNode = TemplateFactory.replaceConstsByParameters(current);
            if (newNode != current) {
                if (prev == null) {
                    result.setFirst(newNode);
                } else {
                    prev.setNext(newNode);
                }
                newNode.setNext(next);
            }
            prev = newNode;
            current = next;
        }
        if (result instanceof Const) {
            result = new Parameter(result);
        }
        return result;
    }

    private static Node selectColumns(ObjectTypeDescription table) {
        SelectColumns columns = new SelectColumns();
        if (table == null) {
            columns.addChild((AST)TemplateFactory.column(1));
            columns.addChild((AST)TemplateFactory.column(1));
        } else {
            List<MethodTypeDescription> attrs = table.getAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                MethodTypeDescription attr = attrs.get(i);
                columns.addChild((AST)TemplateFactory.parameter(attr.getName()));
            }
        }
        return columns;
    }

    private static Node statements() {
        return TemplateFactory.parameter(new Comment(null, "statements"));
    }

    private static StringConst string(@NonNls String msg) {
        return new StringConst(msg);
    }

    private static Node stringParameter(Msg msg) {
        return TemplateFactory.parameter(new StringConst(msg));
    }

    private static Node stringParameter(@NonNls String msg) {
        return TemplateFactory.parameter(TemplateFactory.string(msg));
    }

    private static Node table() {
        return TemplateFactory.parameter("table");
    }

    private static BoolConst trueValue() {
        return new BoolConst(true);
    }

    private static Node type(TypeDescription type) {
        return TemplateFactory.parameter(new TypeSpec(type, (Token)null));
    }

    private static Node updateSetValues() {
        Update.SetValues setValues = new Update.SetValues();
        setValues.addChild((AST)new Assignment(TemplateFactory.column(1), TemplateFactory.expression()));
        setValues.addChild((AST)new Assignment(TemplateFactory.column(2), TemplateFactory.expression()));
        return setValues;
    }

    private static Node value(int number) {
        return TemplateFactory.parameter("value" + number);
    }
}

