/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public final class StringConst
extends Const {
    String value;
    static final long serialVersionUID = -5692831923866523815L;
    static final long serialCheck = 7760459694748343029L;

    public StringConst(Token t) {
        this(t, t.getText());
    }

    StringConst(String txt) {
        this(null, txt);
    }

    StringConst(Msg msg) {
        this(msg.getString());
    }

    StringConst(String txt, int length) {
        this(null, txt, length);
    }

    StringConst(String txt, Node init) {
        this(txt);
        this.initialize(init);
    }

    StringConst(String txt, int length, Node init) {
        this(txt, length);
        this.initialize(init);
    }

    private StringConst(Token t, String txt) {
        this(t, txt, txt.length());
    }

    private StringConst(Token t, String txt, int length) {
        super(t, TypeFactory.getString(length));
        this.value = length >= 0 ? (txt.length() <= length ? txt : txt.substring(0, length)) : txt;
    }

    @Override
    public String getTypeText() {
        return this.value;
    }

    @Override
    public Object getPrimitiveValue() {
        return this.value;
    }

    @Override
    public String getText() {
        return this.value;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + "\"" + this.value + "\"";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static StringConst append(StringConst a, StringConst b) {
        a.value = a.value + b.value;
        a.setTypeDescription(TypeFactory.getString(a.value.length()));
        return a;
    }

    boolean equals(Node b) {
        if (!(b instanceof StringConst)) {
            return false;
        }
        return this.value.equals(((StringConst)b).value);
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(27, null, null, this.getText());
    }

    @Override
    int compare(Node b) {
        StringConst string = (StringConst)b;
        return this.value.compareTo(string.value);
    }

    @Override
    Const convertTo(TypeDescription type) throws TypeException {
        switch (type.getKind()) {
            case 17: {
                EnumTypeDescription enumType = (EnumTypeDescription)type;
                MethodTypeDescription member = enumType.findMember(this.getText());
                if (member == null) {
                    throw new ConversionException((Node)this, type, this.getText());
                }
                return new EnumConst(enumType, member.asAttribute(), this);
            }
            case 10: 
            case 11: {
                return this;
            }
            case 15: {
                return null;
            }
        }
        return StringConst.valueOf(this.getText(), type, this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        sql.append("'" + Str.escape(this.value) + "'");
    }

    int indexOf(StringConst str) {
        return this.getText().indexOf(str.getText());
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.value;
    }

    StringConst toLowerCase() {
        return new StringConst(this.getText().toUpperCase(), this.getTypeDescription().getLength(), this);
    }

    StringConst toUpperCase() {
        return new StringConst(this.getText().toUpperCase(), this.getTypeDescription().getLength(), this);
    }
}

