/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import java.util.Collection;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.Accessor;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.MissingExpressionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RequireMethod;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.Validation;
import oracle.bpm.type.Variable;

class Setter
extends Accessor {
    private Node[] check;
    private Method require;
    static final long serialVersionUID = -769751646900016958L;
    static final long serialCheck = -3408937746602911733L;

    Setter(AttributeTypeDescription attribute, int attrIndex) {
        super(attribute, attrIndex);
        assert (!attribute.getType().isUnknown());
        this.setMemberToReport(attribute);
        this.setMemberPartToReport(7);
    }

    protected Node getTargetObject() {
        Node reference = this.getCurrentClass().createReference(null);
        reference.initialize(this);
        return reference;
    }

    @Override
    protected Collection<Variable> getVariables(MethodTypeDescription method) {
        return method.asAttribute().getWriteVariables();
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(this.attr);
        boolean isDetached = Modifier.isDetached(this.attr.getModifiers());
        String name = this.attr.getName();
        Block statements = new Block();
        TypeDescription type = this.attr.getType();
        if (!isDetached) {
            long modifiers;
            if (this.require != null) {
                Invoke requireCall = this.require.createCall(this);
                Args inputArgs = requireCall.getInputArgs();
                inputArgs.addInArgument(this.createArgumentRef("value"));
                statements.addChild((AST)requireCall);
            }
            if (this.check != null) {
                Validation[] checkCode = this.attr.getCheckCode();
                ObjectClass cl = this.getCurrentClass();
                if (cl != null) {
                    CodeKit.Check checks = cl.getCheck();
                    for (int i = 0; i < this.check.length; ++i) {
                        checks.addCheck(this.check[i], this.attr.getName(), this.getMethodType(), checkCode[i].getMessage());
                    }
                }
            }
            if (Modifier.isIncludeInCheck(modifiers = this.attr.getModifiers())) {
                ObjectClass cl;
                TypeDescription elemType;
                ObjectClass cl2;
                if (type.isBpmObject() && (cl2 = this.getCurrentClass()) != null) {
                    CodeKit.Check checks = cl2.getCheck();
                    checks.addInnerCheck(this.attr.getName(), type);
                }
                if (type.isArray() && (elemType = type.getElementType()).isBpmObject() && (cl = this.getCurrentClass()) != null) {
                    CodeKit.Check checks = cl.getCheck();
                    checks.addArrayCheck(this.attr.getName(), elemType);
                }
            }
        } else {
            MemberAccess handler = new MemberReference("this", "detachedFieldHandler");
            Args args = new Args(1L);
            args.addInArgument("name", new StringConst(name, this));
            args.addInArgument("value", this.createArgumentRef("value"));
            handler = new Invoke(new Identifier("setDetachedField"), handler, args);
            statements.addChild((AST)handler);
        }
        if (this.attrIndex != -1 && !this.attr.isStatic()) {
            statements.addChild((AST)new CodeKit.SetBitSet(this, this.getUnit(), this.getBitIndex()));
        }
        if (!isDetached) {
            Node writeCode = this.getFirst();
            if (writeCode == null) {
                Node value = this.createArgumentRef("value");
                if (type.isString() && (type.getLength() != -1 || type.getScale() != -1)) {
                    value = Conversion.Stringify.create(value, type);
                } else if (type.isDecimal() && (type.getLength() != -1 || type.getScale() != -1)) {
                    value = Conversion.Decimal.create(value, type);
                } else if (this.attr.isAbsoluteTime() && this.attr.getType().getKind() == 6) {
                    value = new Conversion.ToGMT(value);
                }
                writeCode = SetMember.value(this.getTargetObject(), new Identifier(name), value);
            }
            statements.addChild((AST)writeCode);
        }
        statements.initialize(this);
        this.setBody(this.getName(), statements);
        this.addDeclarationsForVariables(this.getTypeDescription().asMethod());
        MethodTypeDescription method = this.createMethod();
        method.setResultType(TypeFactory.getVoid());
        method.setSignature(this.attr.getJavaWriteSignature());
        Argument arg = new Argument("value", type, 1L);
        arg.setJavaType(this.attr.getJavaType());
        arg.setExternal(Modifier.isExternal(this.attr.getModifiers()));
        method.addArgument(arg);
        this.setMethodType(method);
        this.checkOverridings(method);
        return super.checkType();
    }

    @Override
    String getJavaSignature() {
        return this.attr.getJavaWriteSignature();
    }

    @Override
    boolean isSetter() {
        return true;
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        Validation[] checkSource;
        assert (this.getFirst() == null) : "Already parsed: " + this.attr;
        SourceCode code = this.attr.getWriteCode();
        try {
            Node writeCode = null;
            if (code != null) {
                writeCode = Modifier.isExpression(this.attr.getModifiers()) ? compiler.parse(code, this) : compiler.parseMethod(code, false, this);
            }
            if (writeCode == null && this.attr.isVirtual()) {
                MissingExpressionException exception = new MissingExpressionException(this);
                throw exception;
            }
            if (writeCode != null) {
                writeCode.setScope(this.getScope());
                this.setFirst(writeCode);
            }
        }
        catch (CompilerParserException e) {
            e.setMember(this.getMethodType());
            this.reportError(e);
        }
        Validation[] requireSource = this.attr.getRequireCode();
        if (requireSource.length > 0 || RequireMethod.needsNotNullCheck(this.attr)) {
            this.require = new RequireMethod(this.getCurrentClass(), this.attr);
            this.require.setMemberToReport(this.getMemberToReport());
            this.require.setMemberPartToReport(4);
            this.getCurrentClass().addSyntheticMember(this.require);
        }
        if ((checkSource = this.attr.getCheckCode()).length > 0) {
            this.check = new Node[checkSource.length];
            for (int i = 0; i < checkSource.length; ++i) {
                Validation validation = checkSource[i];
                this.check[i] = compiler.parse(validation, this);
                assert (this.check[i] != null) : "Null expr for validation: " + validation + ", member: " + this.attr;
            }
        }
    }

    static class Forward
    extends Setter {
        private FieldDeclaration target;
        static final long serialVersionUID = 6906319135334316606L;
        static final long serialCheck = -8003441517374753189L;

        public Forward(FieldDeclaration target, AttributeTypeDescription attribute, int attrIndex) {
            super(attribute, attrIndex);
            this.target = target;
        }

        @Override
        public void reportWarning(CilException error) {
        }

        @Override
        protected Node getTargetObject() {
            return this.target.createReference();
        }

        @Override
        void parse(FuegoCompiler compiler) throws CompilerException {
        }
    }
}

