/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ConstantAssignmentException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NoSuchArgumentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.ReadOnlyMemberException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateSpec;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnexpectedMethodException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public class SetMember
extends MemberAccess {
    static final long serialVersionUID = -1063233275691169302L;
    static final long serialCheck = 3519059562983076342L;

    public SetMember() {
    }

    SetMember(MemberReference var, Node value) {
        this.copyParentFrom(var);
        this.setMemberType(var.getMemberType());
        TypeDescription type = var.getOp1().getTypeDescription();
        this.setObjType(type);
        this.setOperands(var.getOp1(), var.getOp2(), value);
        this.initialize(var);
    }

    @Override
    public String getText() {
        MethodTypeDescription memberType = this.getMemberType();
        if (this.getObjType() != null && memberType != null) {
            return ".[" + memberType.getName() + "]";
        }
        return memberType == null ? ".=" : ".[" + memberType + "]=";
    }

    @Override
    public Node getObject() {
        return this.getOp1();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2(), this.getOp3());
    }

    static SetMember value(String object, String member, Node value) {
        Identifier objectNode = new Identifier(object);
        Identifier memberNode = new Identifier(member);
        return SetMember.value(objectNode, memberNode, value);
    }

    static SetMember value(Node object, Node member, Node value) {
        assert (value.getScope() != null);
        SetMember set = new SetMember();
        set.copyParentFrom(value);
        set.addChild((AST)object);
        set.addChild((AST)member);
        set.addChild((AST)value);
        set.initialize(value);
        return set;
    }

    @Override
    boolean isPrimitiveAccess() {
        return this.isReferenceToCurrentSetter();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        context = super.checkFlow(context);
        context.use(this.getMemberType(), this.getOp2());
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription resultType;
        String memberName;
        MethodTypeDescription memberType;
        TypeDescription objType;
        Node member = this.getOp2();
        Node value = this.getOp3();
        Node object = this.getOp1();
        object.setLeftValue(true);
        if (member.isCompletion()) {
            try {
                object = new TypeSpec(TypeSpec.findType(object), object);
            }
            catch (AmbiguousComponentNameException e) {
                TypeRef[] possibleTypes;
                TypeRef candidate = null;
                int moduleDepth = Integer.MAX_VALUE;
                for (TypeRef possibleType : possibleTypes = e.getPossibleTypes()) {
                    TypeDescription td = possibleType.get();
                    if (!td.isModule()) continue;
                    int depth = possibleType.getText().split("\\.").length;
                    if (depth < moduleDepth) {
                        moduleDepth = depth;
                        candidate = possibleType;
                        continue;
                    }
                    if (depth != moduleDepth || depth < 2) continue;
                    candidate = null;
                }
                if (candidate != null) {
                    object = new TypeSpec(candidate.get(), object);
                }
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        if ((object = object.checkType()) == null) {
            if (this.getOp1().getText().equals("arg")) {
                Symbol arg = this.getSymbolTable().getArgument(this.getOp2().getText());
                if (member.isCompletion()) {
                    member.complete(5, this.getOp1());
                }
                if (arg == null) {
                    throw new NoSuchArgumentException(this.getOp2(), this.getCurrentMember().getMethodType(), this.getOp2().getText());
                }
                LocalVar local = new LocalVar(arg, null);
                local.initialize(this.getOp2());
                local.setParent(this);
                Assignment assign = new Assignment(local, value);
                assign.setStatement(true);
                assign.initialize(this);
                return assign.checkType();
            }
            objType = TypeSpec.findType(this.getOp1());
            if (objType != null) {
                object = new TypeSpec(objType, this.getOp1());
                object.setParent(this);
            } else {
                object = null;
            }
        } else {
            object = this.derefLocal(object);
            objType = object.getTypeDescription();
        }
        if (objType == null) {
            throw new MemberReferenceException(this.getOp1());
        }
        if (member.isCompletion()) {
            member.complete(2, object);
        }
        if (objType.getKind() != 11 && objType.getKind() != 15) {
            object.setNext(null);
            Function f = new Function();
            MemberReference target = new MemberReference(SetMember.deepCopy(object), SetMember.deepCopy(member));
            Node ref = SetMember.deepCopy(object);
            f.setFirst(target);
            f.addArg(ref);
            f.addArg(value);
            f.initialize(this);
            f.setParent(this);
            try {
                Invoke invoke = (Invoke)f.checkType();
                if (this.isGeneratingSource()) {
                    Args inputArgs = invoke.getInputArgs();
                    Arg arg = (Arg)inputArgs.getFirst().getNext();
                    value = arg.getValue();
                    this.setObjType(invoke.getObject().getTypeDescription());
                    this.setOperands(invoke.getObject(), member, value);
                    this.setTypeDescription(TypeFactory.getVoid());
                    return this;
                }
                Assignment result = new Assignment(object, invoke);
                result.initialize(this);
                return ((Node)result).checkType();
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        if ((memberType = this.findMember(objType, memberName = member.getText(), 18, member)) == null) {
            if (value instanceof InvalidExpr) {
                value.checkType();
            }
            Node targetTypeNode = value.getTargetValue();
            TypeDescription targetTypeDescription = null;
            if (targetTypeNode != null) {
                targetTypeDescription = targetTypeNode.getTypeDescription();
            }
            throw MemberReferenceException.illegallMemberSearchClosest(objType, member, targetTypeDescription);
        }
        long memberModifiers = memberType.getModifiers();
        if (object instanceof TypeSpec && !memberType.isStatic()) {
            object = SetMember.defaultInstanceFor(objType, object);
            objType = object.getTypeDescription();
        }
        if ((resultType = memberType.getResultType()).isVoid()) {
            throw new UnexpectedMethodException(this.getOp1(), memberType, objType);
        }
        if (Modifier.isConst(memberModifiers)) {
            throw new ReadOnlyMemberException(this.getOp1(), member);
        }
        this.setMemberType(memberType);
        this.getCurrentClass().declareDependency(objType);
        try {
            this.checkTypeCompatibility(object, member, value, memberType, objType);
        }
        catch (ConstantAssignmentException e) {
            LanguageSpec language = this.getCurrentLanguage();
            if (language.isFuego1()) {
                boolean isEmptyArray;
                TypeDescription valueType = value.getTypeDescription();
                boolean bl = isEmptyArray = value instanceof ArrayConst && valueType.equals(TypeFactory.getArray(TypeFactory.getNull()));
                if (isEmptyArray && objType.isBpmObject()) {
                    Invoke invoke = new Invoke(new Identifier("clear"), new MemberReference(object, member), new Args(1L));
                    invoke.setParent(this);
                    invoke.initialize(this);
                    try {
                        return invoke.checkType();
                    }
                    catch (TypeException e1) {
                        throw e;
                    }
                }
            }
            throw e;
        }
        this.checkDeprecated(memberType, member);
        this.checkSillyOperation(this, value);
        return this.checkRefactor(memberType, object, this.getOp3());
    }

    void checkTypeCompatibility(Node object, Node member, Node value, MethodTypeDescription memberType, TypeDescription objType) throws TypeException {
        TypeDescription resultType = memberType.getResultType();
        long modifiers = memberType.getModifiers();
        TypeDescription valueType = (value = value instanceof InvalidExpr ? value.checkType() : value.checkType(resultType)).getTypeDescription();
        if (!resultType.isAssignableFrom(valueType)) {
            if (this.isAssignableFrom45(resultType, valueType)) {
                value = Conversion.promoteFrom45(value, resultType);
            } else {
                throw new InvalidAssignmentException((Node)this, valueType, resultType);
            }
        }
        if (!(Modifier.hasSetter(modifiers) || Modifier.isIn(modifiers) || this.isPrimitiveAccess())) {
            throw new ConstantAssignmentException(member);
        }
        if (objType.isInvokeable()) {
            resultType = resultType.setReferenceType(true);
        }
        value = Conversion.promote(value, resultType);
        if (Modifier.isExternal(modifiers)) {
            Argument resultArgument = memberType.getResultArgument();
            String javaType = this.isReferenceToCurrentSetter() ? resultArgument.getType().getJavaType() : resultArgument.getJavaType();
            value = Conversion.Export.create(value, javaType, resultType).checkType(resultType);
        }
        this.setObjType(objType);
        this.setOperands(object, member, value);
        this.setTypeDescription(this.isExpression() ? resultType : TypeFactory.getVoid());
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        assert (this.hasType()) : "Node was not compiled. \n" + this.dumpContext();
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        MethodTypeDescription member = this.getMemberType();
        String setter = SetMember.getWriteSignature(this.getObjType(), member);
        Object instance = this.runObjectReference(rm);
        Node op = this.getOp3() != null ? this.getOp3() : this.getOp2();
        Object value = op.value(rm);
        try {
            if (instance instanceof FuegoInvokeable && this.isPrimitiveAccess()) {
                ((FuegoInvokeable)instance).setField(FieldDeclaration.name(this.getMemberName()), value);
            } else if (instance instanceof Invokeable) {
                Invokeable invokeable = (Invokeable)instance;
                invokeable.setAttributeValue(setter, value);
            } else {
                if (instance == null && this.getObjectType().isBpmObject() && !member.isStatic()) {
                    Symbol s = this.getObject().getSymbol();
                    if (s != null) {
                        throw new NullReferenceException((Node)this, new ValueReference.VariableReference(s));
                    }
                    throw new NullReferenceException(this);
                }
                String signature = MemberAccess.getWriteSignature(this.objType, member);
                member.getParent().invokeMethod(signature, instance, new Object[]{value});
            }
        }
        catch (ComponentExecutionException e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
        return null;
    }

    private boolean isReferenceToCurrentSetter() {
        Method method = this.getCurrentMember();
        Symbol objectSymbol = this.getObject().getSymbol();
        return objectSymbol == this.getThis() && method != null && method.isSetter() && this.getMemberName().equals(method.getName()) && !method.getMethodType().hasModifiers(0x20000000000L);
    }

    private Node checkRefactor(MethodTypeDescription member, Node object, Node value) {
        Node result = this;
        if (Modifier.isRefactor(member.getModifiers()) && member.isAttribute()) {
            try {
                SourceCode code = member.asAttribute().getWriteCode();
                TemplateSpec spec = TemplateSpec.create(code);
                Template refactor = spec.instantiate(this);
                refactor.addParameter("object", object);
                refactor.addParameter("value", value);
                result = refactor.apply();
            }
            catch (CompilerException e) {
                // empty catch block
            }
        }
        return result;
    }
}

