/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CannotExtendArrayException;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidIndexTypeException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;

public class SetElement
extends Ternary {
    private ClassConst arrayJavaType;
    private ClassConst elementJavaType;
    private boolean extendArray = false;
    static final long serialVersionUID = 4934102644023728301L;
    static final long serialCheck = 3327313365004680412L;

    public SetElement() {
    }

    SetElement(ArrayReference reference, Node value) {
        this.copyParentFrom(reference);
        assert (!(value instanceof LocalVar));
        Node array = reference.getOp1();
        Node index = reference.getOp2();
        this.setOperands(array, index, value);
        this.setStatement(true);
    }

    SetElement(Node array, Node index, Node value) {
        this.copyParentFrom(array);
        this.setOperands(array, index, value);
        this.setStatement(true);
    }

    public ClassConst getArrayClass() {
        return this.arrayJavaType;
    }

    public ClassConst getElementClass() {
        return this.elementJavaType;
    }

    public boolean isExtendArray() {
        return this.extendArray;
    }

    @Override
    public String getText() {
        return "[]=";
    }

    public void generateIndex(CodeGenerator cg) throws CodeGenerationException {
        if (!this.isExtendArray()) {
            this.getOp2().gen(cg);
        }
    }

    public void generateValue(CodeGenerator cg) throws CodeGenerationException {
        Node operand = this.isExtendArray() ? this.getOp2() : this.getOp3();
        operand.setStatement(false);
        operand.gen(cg);
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node array = this.getOp1();
        Node index = this.getOp2();
        Node value = this.getOp3();
        if (value == null) {
            value = index;
            index = null;
        }
        cg.generate(this, array, index, value);
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription indexType;
        TypeDescription arrayType;
        if (this.getKind() != -1) {
            return this;
        }
        Node array = this.getOp1();
        Node index = this.getOp2();
        Node value = this.getOp3();
        array.setLeftValue(true);
        array = array.checkType();
        TypeDescription typeDescription = arrayType = array == null ? null : array.getTypeDescription();
        if (value == null) {
            value = index;
            index = null;
            this.extendArray = true;
            indexType = TypeFactory.getPrimitiveInt(32);
        } else {
            index = index.checkType(arrayType == null ? null : arrayType.getIndexType());
            indexType = index.getTypeDescription();
        }
        value = value.checkType(arrayType == null ? null : arrayType.getElementType());
        TypeDescription valueType = value.getTypeDescription();
        if (array == null) {
            array = this.getOp1();
            arrayType = indexType.isInt() ? TypeFactory.getArray(valueType.primitiveEquivalent(false)) : TypeFactory.getMap(valueType.primitiveEquivalent(false), indexType.primitiveEquivalent(false));
            array = array.getAutoDeclared(arrayType);
            arrayType = array.getTypeDescription();
            value = Conversion.promote(value, arrayType.getElementType());
        } else {
            arrayType = (array = array.externalNode()).getTypeDescription();
            if (!arrayType.isCollection()) {
                throw new ArrayReferenceException(array, arrayType);
            }
            TypeDescription elemType = arrayType.getElementType();
            if (!elemType.isAssignableFrom(valueType)) {
                this.reportError(new InvalidAssignmentException(value, valueType, elemType));
            }
            this.elementJavaType = new ClassConst(elemType, (Node)this);
            this.arrayJavaType = new ClassConst(arrayType, (Node)this);
            elemType = elemType.primitiveEquivalent(false);
            value = Conversion.promote(value, elemType);
            if (arrayType.isPrimitive() && array.isExternal()) {
                this.elementJavaType = new ClassConst(Conversion.getElementType(array.getJavaType()), (Node)this);
                this.arrayJavaType = new ClassConst(array.getJavaType(), (Node)this);
                value = Conversion.Export.create(value, this.elementJavaType.getText(), elemType).checkType(elemType);
            }
        }
        TypeDescription it = arrayType.getIndexType();
        if (it == null) {
            it = TypeFactory.getPrimitiveInt(32);
        }
        if (this.extendArray && arrayType.getKind() == 13) {
            this.reportError(new CannotExtendArrayException(array));
        }
        if (!this.extendArray && !it.isAssignableFrom(indexType)) {
            this.reportError(new InvalidIndexTypeException(index, it));
        }
        if (!this.extendArray) {
            index = Conversion.promote(index, it);
        }
        if (array instanceof LocalVar) {
            array = new Deref(array);
            array = array.checkType();
        }
        if (index == null) {
            this.setOperands(array, value);
        } else {
            this.setOperands(array, index, value);
        }
        this.setTypeDescription(TypeFactory.getVoid());
        Node result = this;
        if (arrayType.isPrimitive() && array instanceof MemberReference) {
            MemberReference ref = (MemberReference)array;
            MethodTypeDescription member = ref.getMemberType();
            long modifiers = member.getModifiers();
            if (!Modifier.hasSetter(modifiers) && !Modifier.isIn(modifiers)) {
                if (this.extendArray) {
                    this.reportError(new CannotExtendArrayException(array, ref.getMemberName()));
                }
            } else if (!this.isGeneratingSource()) {
                ref = (MemberReference)SetElement.deepCopy(ref);
                array.setLeftValue(false);
                this.setTypeDescription(ref.getTypeDescription());
                this.setExpression(true);
                Node parent = this.getParent();
                Assignment assign = new Assignment(ref, this);
                assign.setParent(parent);
                result = assign.checkType();
            }
        }
        return result;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.elementJavaType != null) {
            this.elementJavaType.collectConstants(cp);
        }
        if (this.arrayJavaType != null) {
            this.arrayJavaType.collectConstants(cp);
        }
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        Node array = this.getOp1();
        Node index = this.getOp2();
        Node value = this.getOp3();
        if (value == null) {
            value = index;
            index = null;
        }
        if (index != null && index instanceof MemberAccess) {
            MemberAccess ma = (MemberAccess)index;
            TypeDescription arrType = array.getTypeDescription();
            TypeDescription objType = ma.getObjType();
            Node obj = ma.getObject();
            if (arrType.equals(objType) && ma.getMemberName().equals("length") && obj != null && array.equalsTree(obj)) {
                this.extendArray = true;
                this.setOperands(array, value);
            }
        }
        return this;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object value;
        TypeDescription arrayType = this.getOp1().getTypeDescription();
        Object array = this.getOp1().value(rm);
        Object index = this.getOp2().value(rm);
        Object object = value = this.getOp3() != null ? this.getOp3().value(rm) : null;
        if (!this.extendArray) {
            index = this.notNull(index, this.getOp2().getTypeDescription(), rm);
        } else {
            value = index;
            index = null;
        }
        if (arrayType.isMap()) {
            Map map = (Map)array;
            map.put(index, value);
        } else if (arrayType.isSet()) {
            Set set = (Set)array;
            set.add(value);
        } else if (!arrayType.isPrimitive()) {
            List list = (List)array;
            if (array == null) {
                Symbol s = this.getOp1().getSymbol();
                if (s == null && this.getOp1() instanceof Conversion) {
                    s = ((Conversion)this.getOp1()).getOperand().getSymbol();
                }
                if (s != null) {
                    throw new NullReferenceException(this.getOp1(), new ValueReference.VariableReference(s));
                }
                throw new NullReferenceException(this.getOp1());
            }
            if (this.extendArray) {
                list.add(value);
            } else {
                assert (index != null) : "Illegal state exception";
                int indexValue = ((Number)index).intValue();
                ArrayUtils.listSetElement(list, indexValue, value);
            }
        } else {
            Class elemClass = (Class)this.elementJavaType.value(rm);
            if (this.extendArray) {
                array = ArrayUtils.addElement(elemClass, array, value);
            } else {
                assert (index != null) : "Illegal state exception";
                int indexValue = ((Number)index).intValue();
                array = ArrayUtils.setElement(elemClass, array, indexValue, value, this.isExpression());
            }
            if (this.isExpression()) {
                return array;
            }
        }
        return null;
    }
}

