/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import oracle.bpm.compiler.GroupByColumns;
import oracle.bpm.compiler.Having;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.OrderBy;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.SelectColumns;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;

public class Select
extends SQLStatement {
    private SelectColumns columns;
    private boolean distinct;
    private Tables from;
    private GroupByColumns groupby;
    private Having having;
    private OrderBy orderby;
    private Node where;
    static final long serialVersionUID = 8181756990089462877L;
    static final long serialCheck = -2376103904516884006L;

    public Select(Token t) {
        super(t);
    }

    Select() {
    }

    Select(Tables tables, Node where) {
        this.copyParentFrom(tables);
        SelectColumns columns = new SelectColumns();
        columns.setNext(tables);
        if (where != null) {
            where.setNext(null);
            where = SqlColumnReference.updateReferences(where);
        }
        tables.setNext(where);
        this.setFirst(columns);
        this.initialize(tables);
    }

    @Override
    public String getText() {
        return "select" + (this.distinct ? " distinct" : "");
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    boolean isAllColumns() {
        return this.columns.isAllColumns();
    }

    Node getColumns() {
        return this.getOp1();
    }

    boolean isDistinct() {
        return this.distinct;
    }

    Node getGroupBy() {
        return this.findChildByClass(GroupByColumns.class);
    }

    Node getHaving() {
        return this.findChildByClass(Having.class);
    }

    Node getOrderBy() {
        return this.findChildByClass(OrderBy.class);
    }

    TypeDescription getSQLType() {
        ObjectTypeDescription object = new ObjectTypeDescription("sql.query");
        object.setModifiers(object.getModifiers() | 0x10000000L);
        object.setComponentType(ComponentType.SQL.getText());
        MethodTypeDescription delete = new MethodTypeDescription("remove");
        delete.setResultType(TypeFactory.getVoid());
        delete.setSignature("Mremove()V");
        MethodTypeDescription update = new MethodTypeDescription("store");
        update.setResultType(TypeFactory.getVoid());
        update.setSignature("Mstore()V");
        object.addMember(delete);
        object.addMember(update);
        this.columns.addMembers(object);
        return object;
    }

    Node getTables() {
        return this.getOp2();
    }

    @Override
    boolean isUpdate() {
        return false;
    }

    Node getWhere() {
        Node op3 = this.getOp3();
        return op3 instanceof OrderBy || op3 instanceof GroupByColumns ? null : op3;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType((ColumnReference[])null);
    }

    Node checkType(ColumnReference[] requiredTypes) throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node current = this.getFirst();
        if (current instanceof Identifier.Distinct) {
            this.distinct = true;
            current = current.getNext();
            this.removeFirst();
        }
        this.columns = (SelectColumns)current;
        this.from = (Tables)this.columns.getNext();
        for (current = this.from.getNext(); current != null; current = current.getNext()) {
            if (current instanceof OrderBy) {
                this.orderby = (OrderBy)current;
                continue;
            }
            if (current instanceof GroupByColumns) {
                this.groupby = (GroupByColumns)current;
                continue;
            }
            if (current instanceof Having) {
                this.having = (Having)current;
                continue;
            }
            this.where = current;
        }
        this.from = this.checkTables(this.from);
        if (this.where != null) {
            this.where = this.where.checkType();
            if (!this.where.getTypeDescription().isBool()) {
                this.reportError(new NonBooleanException(this.where));
            }
            this.collectParameters(this.where);
        }
        ColumnReference[] groupingcols = null;
        if (this.groupby != null) {
            this.groupby.checkType();
            groupingcols = this.groupby.getGroupingColumns();
        }
        if (this.having != null) {
            this.having.checkType();
            this.collectParameters(this.having);
        }
        this.columns.setGroupingColumns(groupingcols);
        this.columns.checkType(requiredTypes);
        if (this.orderby != null) {
            this.orderby.checkType();
        }
        this.setTypeDescription(this.getSQLType());
        return this;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.where != null) {
            params = this.where.collectParameters(params);
        }
        if (this.having != null) {
            params = this.having.collectParameters(params);
        }
        return params;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append("SELECT ").append(this.distinct ? " DISTINCT " : "");
        this.columns.generateSQLCode(sql);
        sql.append(" FROM ");
        this.from.generateSQLCode(sql);
        if (this.where != null) {
            sql.append(" WHERE ");
            this.where.generateSQLCode(sql);
        }
        if (this.groupby != null) {
            this.groupby.generateSQLCode(sql);
        }
        if (this.having != null) {
            this.having.generateSQLCode(sql);
        }
        if (this.orderby != null) {
            this.orderby.generateSQLCode(sql);
        }
    }
}

