/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Watch;
import oracle.bpm.lang.EnumTypeDescription;

class Scope {
    private FuegoCompiler compiler = null;
    private List<EnumTypeDescription> enumStack;
    private Scope first = null;
    private Scope next = null;
    private boolean onlyLocal;
    private boolean stepEnabled = true;
    private Scope superScope = null;
    private SymbolTable superTable = null;
    private SymbolTable symbolTable = null;
    private List<Watch> watches;

    Scope() {
        this(null);
    }

    Scope(FuegoCompiler compiler) {
        this(compiler, new SymbolTable());
    }

    Scope(FuegoCompiler compiler, SymbolTable symTable) {
        this.compiler = compiler;
        this.symbolTable = symTable;
    }

    FuegoCompiler getCompiler() {
        return this.compiler;
    }

    EnumTypeDescription getCurrentEnum() {
        int length = this.enumStack != null ? this.enumStack.size() : 0;
        return length == 0 ? null : this.enumStack.get(length - 1);
    }

    void setOnlyLocal(boolean local) {
        this.onlyLocal = local;
        if (local) {
            SymbolTable st = this.symbolTable.getDefaultTable();
            this.superTable = st != null ? st : this.superTable;
            this.symbolTable.setDefaultTable(null);
        } else if (this.superTable != null) {
            this.symbolTable.setDefaultTable(this.superTable);
            this.superTable = null;
        }
    }

    boolean isOnlyLocal() {
        return this.onlyLocal;
    }

    boolean isSQLScope() {
        return false;
    }

    void setStepEnabled(boolean enabled) {
        this.stepEnabled = enabled;
        for (Scope current = this.getFirst(); current != null; current = current.getNext()) {
            current.setStepEnabled(enabled);
        }
    }

    boolean isStepEnabled() {
        return this.stepEnabled;
    }

    void setSuperScope(Scope superscp) {
        this.superScope = superscp;
        this.symbolTable.setDefaultTable(superscp.symbolTable);
    }

    Scope getSuperScope() {
        return this.superScope;
    }

    SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    Scope makeSubScope() {
        return this.makeSubScope(null);
    }

    Scope makeSubScope(Scope newscope) {
        newscope = newscope == null ? new Scope() : newscope;
        newscope.compiler = this.compiler;
        newscope.getSymbolTable().setDefaultTable(this.symbolTable);
        newscope.setNext(this.first);
        this.setFirst(newscope);
        newscope.setSuperScope(this);
        return newscope;
    }

    Scope makeSubScopeOver(Scope child) {
        this.removeChild(child);
        Scope newscp = this.makeSubScope();
        newscp.setFirst(child);
        child.setSuperScope(newscp);
        return newscp;
    }

    void popCurrentEnum() {
        this.enumStack.remove(this.enumStack.size() - 1);
        if (this.enumStack.size() == 0) {
            CollectionPool.releaseArrayList(this.enumStack);
            this.enumStack = null;
        }
    }

    void pushCurrentEnum(EnumTypeDescription enumType) {
        if (this.enumStack == null) {
            this.enumStack = CollectionPool.getArrayList();
        }
        this.enumStack.add(enumType);
    }

    void removeSubScope(Scope scp) {
        this.removeChild(scp);
        for (Scope current = scp.getFirst(); current != null; current = current.getNext()) {
            current.setSuperScope(this);
        }
    }

    void removeWatch(Watch wp) {
        if (this.watches != null) {
            this.watches.remove(wp);
            for (Scope scp = this.getFirst(); scp != null; scp = scp.getNext()) {
                scp.removeWatch(wp);
            }
        }
    }

    void removeWatches() {
        this.watches = null;
        for (Scope scp = this.getFirst(); scp != null; scp = scp.getNext()) {
            scp.removeWatches();
        }
    }

    private void setFirst(Scope first) {
        this.first = first;
    }

    private Scope getFirst() {
        return this.first;
    }

    private void setNext(Scope next) {
        this.next = next;
    }

    private Scope getNext() {
        return this.next;
    }

    private void removeChild(Scope scp) {
        Scope current;
        Scope prev = null;
        for (current = this.getFirst(); current != scp && current != null; current = current.getNext()) {
            prev = current;
        }
        if (current == null) {
            assert (false) : "Child not found";
        } else if (prev == null) {
            this.setFirst(current.getNext());
        } else {
            prev.setNext(current.getNext());
        }
    }
}

